/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ui.history;

import javax.baja.driver.history.BArchiveDescriptor;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.HistoryLearn;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;

public class ArchiveManagerController
extends FolderController {
    static Lexicon lex = Lexicon.make((String)"driver");
    public final MgrController.MgrCommand archive;

    public ArchiveManagerController(BArchiveManager manager) {
        super((BFolderManager)manager);
        this.archive = new ArchiveCommand(manager);
        this.cancel.setFlags(0);
        this.archive.setFlags(15);
    }

    public CommandArtifact doDiscover(Context cx) throws Exception {
        HistoryLearn learn;
        super.doDiscover(cx);
        MgrLearn mgrLearn = this.getManager().getLearn();
        if (mgrLearn instanceof HistoryLearn && (learn = (HistoryLearn)mgrLearn).getJobBar() == null) {
            learn.updateRoots(learn.getDiscovery((BComponent)this.getManager().getCurrentValue()));
        }
        return null;
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        MgrController.IMgrCommand[] cmds = super.makeCommands();
        if (!((BArchiveManager)this.getManager()).supportsArchiveFolders()) {
            Array stripped = new Array(MgrController.IMgrCommand.class, cmds.length);
            for (int i = 0; i < cmds.length; ++i) {
                if (cmds[i] == this.newFolder || cmds[i] == this.allDescendants) continue;
                stripped.add((Object)cmds[i]);
            }
            cmds = (MgrController.IMgrCommand[])stripped.trim();
        }
        return ArchiveManagerController.append((MgrController.IMgrCommand[])cmds, (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.archive});
    }

    public void updateCommands() {
        super.updateCommands();
        BMgrTable table = this.getManager().getModel().getTable();
        this.archive.setEnabled(table != null && !table.getSelection().isEmpty());
    }

    public MgrEdit makeEdit(String label) {
        return new ArchiveEdit(this.getManager(), label);
    }

    class ArchiveCommand
    extends MgrController.MgrCommand {
        ArchiveCommand(BArchiveManager owner) {
            super((BWidget)owner, lex, "archive.command.archive");
        }

        public CommandArtifact doInvoke() {
            BComponent[] sel = ArchiveManagerController.this.getManager().getModel().getTable().getSelectedComponents();
            for (int i = 0; i < sel.length; ++i) {
                if (!(sel[i] instanceof BArchiveDescriptor)) continue;
                ((BArchiveDescriptor)sel[i]).execute();
            }
            return null;
        }
    }

    private class ArchiveEdit
    extends MgrEdit {
        public ArchiveEdit(BAbstractManager manager, String label) {
            super(manager, label);
        }

        protected MgrEditRow makeRow(BComponent target, Object discovery, MgrTypeInfo[] types) throws Exception {
            target.lease(3);
            return new MgrEditRow(target, discovery, types);
        }
    }
}

