/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ui.device;

import com.tridium.driver.util.DrUtil;
import com.tridium.sys.transfer.DeployToComp;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.TemplateManager;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.workbench.transfer.TransferArtifact;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceTemplateEdit;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.BTemplateTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;

public class DeviceController
extends FolderController {
    static boolean TEST_ONLY = true;
    static boolean COMMIT = false;
    final Lexicon lex = Lexicon.make(DeviceController.class);
    public final MgrController.MgrCommand editTemplate;

    public DeviceController(BDeviceManager manager) {
        super((BFolderManager)manager);
        this.editTemplate = new EditTemplate((BWidget)manager);
        this.editTemplate.setFlags(7);
        this.editTemplate.setEnabled(false);
        this.templateMode.setEnabled(true);
    }

    public void headerPopup(BTemplateTable table, BMouseEvent event, int column) {
    }

    protected MgrController.IMgrCommand[] makeTemplateCommands() {
        MgrController.IMgrCommand[] superCommands = super.makeTemplateCommands();
        MgrController.IMgrCommand[] devCommands = new MgrController.IMgrCommand[]{this.editTemplate};
        return MgrController.append((MgrController.IMgrCommand[])superCommands, (MgrController.IMgrCommand[])devCommands);
    }

    public void updateCommands() {
        super.updateCommands();
        BComponent[] sel = this.getSelectedComponentsWithoutFolders();
        boolean allSameTemplate = true;
        String tmplName = "";
        for (BComponent comp : sel) {
            BTemplateConfig tc = BTemplateConfig.getConfigForRoot((BComponent)comp);
            if (tc == null) {
                allSameTemplate = false;
                break;
            }
            if (tmplName.isEmpty()) {
                tmplName = tc.getTemplateName();
                continue;
            }
            if (tmplName.equals(tc.getTemplateName())) continue;
            allSameTemplate = false;
            break;
        }
        this.editTemplate.setEnabled(!tmplName.isEmpty() && allSameTemplate);
    }

    public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
        MgrColumn mgrCol = table.columnIndexToMgrColumn(col);
        if (mgrCol instanceof DeviceExtsColumn) {
            ((DeviceExtsColumn)mgrCol).cellDoubleClicked(table, event, row, col);
        } else if (event.isControlDown() && this.editTemplate.isEnabled()) {
            this.getManager().setMgrEditState(2);
            this.editTemplate.invoke();
            this.getManager().setMgrEditState(0);
        } else {
            super.cellDoubleClicked(table, event, row, col);
        }
    }

    protected CommandArtifact doEditTemplate(Object discovery, Context cx) throws Exception {
        return null;
    }

    public CommandArtifact doEditTemplate(Context cx) throws Exception {
        BComponent[] sel = this.getSelectedComponents();
        if (sel.length == 0) {
            return null;
        }
        DeviceTemplateEdit edit = new DeviceTemplateEdit(this.getManager(), this.editTemplate.getLabel());
        for (int i = 0; i < sel.length; ++i) {
            edit.addRow(sel[i]);
        }
        edit.setSelectAll(true);
        return edit.invoke(cx);
    }

    protected CommandArtifact doDeploy(Object template, Context cx) throws Exception {
        BWbDeployableNtplFile deployable;
        BNtplFile ntplFile = null;
        if (template instanceof BWbDeployableNtplFile) {
            deployable = (BWbDeployableNtplFile)template;
        } else if (template instanceof BNtplFile) {
            ntplFile = (BNtplFile)template;
            deployable = BWbDeployableNtplFile.make((BNtplFile)ntplFile);
        } else {
            TemplateManager.TemplateInfo templateInfo = (TemplateManager.TemplateInfo)template;
            ntplFile = templateInfo.getNtplFile();
            deployable = BWbDeployableNtplFile.make((BNtplFile)ntplFile);
        }
        String deployName = deployable.getDeployName();
        BTextField nameField = new BTextField(deployName);
        BTextField countField = new BTextField("1", 6);
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)new BLabel(this.lex.getText("template.deploy.name")));
        grid.add(null, (BValue)nameField);
        grid.add(null, (BValue)new BLabel(this.lex.getText("template.deploy.count")));
        grid.add(null, (BValue)countField);
        String title = this.lex.getText("template.deploy");
        int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
        if (r == 2) {
            return null;
        }
        int deployCount = Integer.parseInt(countField.getText());
        deployName = nameField.getText();
        BDevice[] addedDevices = new BDevice[deployCount];
        String[] addedNames = new String[deployCount];
        String[] deployNames = new String[deployCount];
        BWbDeployableNtplFile[] templates = new BWbDeployableNtplFile[deployCount];
        for (int i = 0; i < deployCount; ++i) {
            templates[i] = deployable;
            deployNames[i] = deployName;
        }
        Mark mark = new Mark((BObject[])templates, deployNames);
        BComponent target = this.getManager().getTarget();
        TransferArtifact art = new TransferArtifact((BWidget)this.getManager(), 16, mark, (BObject)target, null, DeployToComp.NoPostConfigEdit);
        art.redo();
        if (art.getResult() == null) {
            return null;
        }
        DeployToComp.DeployTransferResult transferResult = (DeployToComp.DeployTransferResult)art.getResult();
        DrUtil.wait((int)250);
        this.getTable().selectByName(transferResult.getInsertNames());
        return this.doEditTemplate(cx);
    }

    class EditTemplate
    extends MgrController.MgrCommand {
        EditTemplate(BWidget owner) {
            super(owner, DeviceController.this.lex, "editTemplate");
        }

        public CommandArtifact doInvoke() throws Exception {
            DeviceController.this.getManager().setMgrEditState(2);
            CommandArtifact artifact = DeviceController.this.doEditTemplate(DeviceController.this.getManager().getCurrentContext());
            DeviceController.this.getManager().setMgrEditState(0);
            return artifact;
        }

        public Command doMerge(Command c) {
            return this;
        }
    }
}

