/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platAceIpc;

import com.tridium.driver.util.DrUtil;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.platAceIpc.BAceIpcPlatformService;
import com.tridium.sys.Nre;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.Locale;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAceIpcPlatformServiceQnx
extends BAceIpcPlatformService {
    @Generated
    public static final Type TYPE = Sys.loadType(BAceIpcPlatformServiceQnx.class);
    private FileInputStream in;
    private FileOutputStream out;
    private static final String DEV_NULL = "/dev/null";
    private static final String ACE_HOME = Sys.getProtectedStationHome() + "/ace";
    private static final String ACE_ENABLE = ACE_HOME + "/enableAce";
    private static final String DEV_ACE = "/dev/ace";
    private static final String DEV_ACE_READ = "/dev/ace";
    private static final String DEV_ACE_WRITE = "/dev/ace";
    private static final String DEV_EDGE_IO = "/dev/edgeIo";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx) && Nre.getHostModel().toLowerCase(Locale.US).startsWith("edge");
    }

    protected synchronized boolean loadLibraries() {
        return true;
    }

    @Override
    public void init() throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initializing ACE IPC interface for '" + ACE_HOME + "'...");
            log.fine("Using device '/dev/ace' for ACE IPC read");
            log.fine("Using device '/dev/ace' for ACE IPC write");
        }
        File driverRead = new File("/dev/ace");
        File driverWrite = new File("/dev/ace");
        try {
            AccessController.doPrivileged(() -> {
                this.in = new FileInputStream(driverRead);
                this.out = new FileOutputStream(driverWrite);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            log.log(Level.SEVERE, "AceIpcPlatformService init() failed", e.getException());
            throw new BajaException("AceIpcPlatformService init() failed", (Throwable)e.getException());
        }
        log.fine("ACE IPC initialization complete");
    }

    @Override
    public void write(byte[] netBytes, int msgLen) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Writing " + msgLen + " bytes to ACE IPC write device");
        }
        this.out.write(netBytes, 0, msgLen);
    }

    @Override
    public int read(byte[] buf) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Reading " + buf.length + " bytes from ACE IPC read device (buffer provided)");
        }
        return this.in.read(buf);
    }

    @Override
    public int read(byte[] buf, int msgLen) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Reading " + msgLen + " bytes from ACE IPC read device (length provided)");
        }
        return this.in.read(buf, 0, msgLen);
    }

    @Override
    public void close() throws Exception {
        log.fine("Closing ACE IPC interface");
    }

    @Override
    public void removeAce() throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Removing ACE IPC directory '" + ACE_HOME + "'...");
        }
        AccessController.doPrivileged(() -> {
            File aceHome = new File(ACE_HOME);
            FileUtil.delete((File)aceHome);
            return null;
        });
    }

    @Override
    public void verifyEnable(boolean set) throws Exception {
        NiagaraBasicPermission acePermission = new NiagaraBasicPermission("MANAGE_ACE");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)acePermission);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Checking ACE IPC process, requested state = " + set);
        }
        try {
            AccessController.doPrivileged(() -> {
                File aceEnable = new File(ACE_ENABLE);
                File aceDevRead = new File("/dev/ace");
                if (!aceEnable.getParentFile().exists() && !aceEnable.getParentFile().mkdirs()) {
                    throw new Exception("Failed to create directory for '" + aceEnable + "'");
                }
                if (set) {
                    File edgeIo = new File(DEV_EDGE_IO);
                    if (edgeIo.exists()) {
                        log.fine("Found edgeGpiod process, slaying...");
                        this.slayProcess(edgeIo, "edgeGpiod");
                    }
                    if (!aceEnable.exists() && !aceEnable.createNewFile()) {
                        throw new Exception("Failed to create ace cookie '" + aceEnable + "'");
                    }
                    boolean aceIsRunning = false;
                    if (aceDevRead.exists()) {
                        return null;
                    }
                    if (aceIsRunning) return null;
                    log.info("Starting ace process at '" + ACE_HOME + "'...");
                    String[] args = new String[]{"/proc/boot/sushi", "start-ace.sh", ACE_HOME};
                    ProcessBuilder builder = new ProcessBuilder(args);
                    builder.directory(new File(ACE_HOME));
                    File nullFile = new File(DEV_NULL);
                    if (!nullFile.exists()) {
                        throw new Exception("Failed to start ace, failed to redirect ace output as DEV_NULL does not exist");
                    }
                    builder.redirectErrorStream(true);
                    builder.redirectOutput(nullFile);
                    Process proc = builder.start();
                    int cnt = 5;
                    while (!aceDevRead.exists() && cnt-- > 0) {
                        DrUtil.wait((int)400);
                    }
                    if (!aceDevRead.exists()) throw new Exception("Failed to start ace");
                    log.info("Started ace process");
                    return null;
                } else {
                    if (aceEnable.exists() && !aceEnable.delete()) {
                        log.severe("Failed to delete ace cookie '" + aceEnable + "'");
                    }
                    if (!aceDevRead.exists()) return null;
                    log.info("Stopping ace process at '" + ACE_HOME + "'...");
                    this.slayProcess(aceDevRead, "ace");
                    log.info("Stopped ace process");
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private void slayProcess(File devFile, String processName) throws Exception {
        String[] args = new String[]{"/proc/boot/slay", "-f", "-s", "SIGKILL", processName};
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.start();
    }
}

