/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platAceIpc;

import com.tridium.driver.util.DrUtil;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.platAceIpc.BAceIpcPlatformService;
import com.tridium.sys.Nre;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAceIpcPlatformServiceNpsdk
extends BAceIpcPlatformService {
    @Generated
    public static final Type TYPE = Sys.loadType(BAceIpcPlatformServiceNpsdk.class);
    private FileInputStream in;
    private FileOutputStream out;
    private boolean done;
    private Thread openThread;
    private OpenStream ostr = null;
    private static boolean nativesLoaded = false;
    private static final String DEV_NULL = "/dev/null";
    private static final String ACE_HOME = Sys.getProtectedStationHome() + "/ace";
    private static final String ACE_ENABLE = ACE_HOME + "/enableAce";
    private static final String DEV_ACE_READ = Sys.getProtectedStationHome() + "/ace/pipeRead";
    private static final String DEV_ACE_WRITE = Sys.getProtectedStationHome() + "/ace/pipeWrite";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        String lonlibPath = Nre.getNiagaraHome() + File.separator + "bin" + File.separator + "libacenpsdk.so";
        return AccessController.doPrivileged(() -> new File(lonlibPath).exists());
    }

    protected synchronized boolean loadLibraries() {
        if (nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading acenpsdk native library");
                System.loadLibrary("acenpsdk");
                nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load acenpsdk native library", e);
            }
            return nativesLoaded;
        });
    }

    @Override
    public void init() throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initializing ACE IPC interface for '" + ACE_HOME + "'...");
            log.fine("Using device '" + DEV_ACE_READ + "' for ACE IPC read");
            log.fine("Using device '" + DEV_ACE_WRITE + "' for ACE IPC write");
        }
        if (!this.done) {
            File driverRead = new File(DEV_ACE_READ);
            File driverWrite = new File(DEV_ACE_WRITE);
            try {
                AccessController.doPrivileged(() -> {
                    this.in = new FileInputStream(driverRead);
                    this.out = new FileOutputStream(driverWrite);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                log.log(Level.SEVERE, "AceIpcPlatformService init() failed", e.getException());
                throw new BajaException("AceIpcPlatformService init() failed", (Throwable)e.getException());
            }
        }
        log.fine("ACE IPC initialization complete");
    }

    @Override
    public void write(byte[] netBytes, int msgLen) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Writing " + msgLen + " bytes to ACE IPC write device");
        }
        this.out.write(netBytes, 0, msgLen);
    }

    @Override
    public int read(byte[] buf) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Reading " + buf.length + " bytes from ACE IPC read device (buffer provided)");
        }
        return this.in.read(buf);
    }

    @Override
    public int read(byte[] buf, int msgLen) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Reading " + msgLen + " bytes from ACE IPC read device (length provided)");
        }
        return this.in.read(buf, 0, msgLen - 1);
    }

    @Override
    public void close() throws Exception {
        log.fine("Closing ACE IPC interface");
        this.in.close();
        this.out.close();
    }

    @Override
    public void removeAce() throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Removing ACE IPC directory '" + ACE_HOME + "'...");
        }
        AccessController.doPrivileged(() -> {
            File aceHome = new File(ACE_HOME);
            FileUtil.delete((File)aceHome);
            return null;
        });
    }

    @Override
    public void verifyEnable(boolean set) throws Exception {
        NiagaraBasicPermission acePermission = new NiagaraBasicPermission("MANAGE_ACE");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)acePermission);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Checking ACE IPC process, requested state = " + set);
        }
        this.done = false;
        try {
            AccessController.doPrivileged(() -> {
                File aceEnable = new File(ACE_ENABLE);
                File aceDevRead = new File(DEV_ACE_READ);
                if (!aceEnable.getParentFile().exists() && !aceEnable.getParentFile().mkdirs()) {
                    throw new Exception("Failed to create directory for '" + aceEnable + "'");
                }
                if (set) {
                    if (!aceEnable.exists() && !aceEnable.createNewFile()) {
                        throw new Exception("Failed to create ace cookie '" + aceEnable + "'");
                    }
                    boolean aceIsRunning = false;
                    if (aceDevRead.exists()) {
                        this.ostr = new OpenStream();
                        this.openThread = new Thread(this.ostr);
                        this.openThread.start();
                        DrUtil.wait((int)500);
                        if (this.done) {
                            return null;
                        }
                    }
                    if (aceIsRunning) return null;
                    log.info("Starting ace process at '" + ACE_HOME + "'...");
                    if (!this.loadLibraries()) {
                        throw new RuntimeException("Failed to start ace, cannot load ace natives");
                    }
                    int ret = this.startAce0(ACE_HOME);
                    if (ret != 0) {
                        throw new Exception("Failed to start ace, rc = " + ret);
                    }
                    if (this.ostr == null) {
                        this.ostr = new OpenStream();
                        this.openThread = new Thread(this.ostr);
                        this.openThread.start();
                    }
                    int cnt = 5;
                    while (!this.done && cnt-- > 0) {
                        DrUtil.wait((int)400);
                    }
                    if (!this.done) throw new Exception("Failed to start ace");
                    log.info("Started ace process");
                    return null;
                } else {
                    if (aceEnable.exists() && !aceEnable.delete()) {
                        log.severe("Failed to delete ace cookie '" + aceEnable + "'");
                    }
                    if (aceDevRead.exists()) {
                        log.info("Stopping ace process at '" + ACE_HOME + "'...");
                        if (!this.loadLibraries()) {
                            throw new RuntimeException("Failed to stop ace, cannot load ace natives");
                        }
                        int ret = this.stopAce0();
                        if (ret != 0) {
                            throw new Exception("Failed to stop ace, rc = " + ret);
                        }
                        log.info("Stopped ace process");
                    }
                    this.ostr = null;
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private native int startAce0(String var1);

    private native int stopAce0();

    private class OpenStream
    implements Runnable {
        private OpenStream() {
        }

        @Override
        public void run() {
            try {
                this.tryFileOpen();
            }
            catch (Exception e) {
                BAceIpcPlatformService.log.log(Level.SEVERE, "Failed to start OpenStream in tryFileOpen", e);
            }
        }

        public void tryFileOpen() throws Exception {
            if (BAceIpcPlatformService.log.isLoggable(Level.FINE)) {
                BAceIpcPlatformService.log.fine("Opening ACE IPC interface for '" + ACE_HOME + "'...");
                BAceIpcPlatformService.log.fine("Using device '" + DEV_ACE_READ + "' for ACE IPC read");
                BAceIpcPlatformService.log.fine("Using device '" + DEV_ACE_WRITE + "' for ACE IPC write");
            }
            File driverRead = new File(DEV_ACE_READ);
            File driverWrite = new File(DEV_ACE_WRITE);
            for (int cnt = 3; !driverRead.exists() && cnt > 0; --cnt) {
                DrUtil.wait((int)500);
            }
            try {
                AccessController.doPrivileged(() -> {
                    BAceIpcPlatformServiceNpsdk.this.in = new FileInputStream(driverRead);
                    BAceIpcPlatformServiceNpsdk.this.out = new FileOutputStream(driverWrite);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                BAceIpcPlatformService.log.log(Level.SEVERE, "AceIpcPlatformService tryFileOpen() failed", e.getException());
                throw new BajaException("AceIpcPlatformService tryFileOpen() failed", (Throwable)e.getException());
            }
            BAceIpcPlatformServiceNpsdk.this.done = true;
            BAceIpcPlatformService.log.fine("ACE IPC open complete");
        }
    }
}

