/*
 * Decompiled with CFR 0.152.
 */
package obix.ui.views;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.View;

public class SessionsView
extends View {
    JTable table;
    Row[] rows;

    public SessionsView(Shell shell) {
        super(shell, "Sessions", null);
        UiSession[] sessions = UiSession.list();
        this.rows = new Row[sessions.length];
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i] = new Row(sessions[i]);
        }
        this.table = new JTable(new Model());
        this.table.addMouseListener(new Controller());
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    static class Row {
        UiSession session;

        Row(UiSession session) {
            this.session = session;
        }

        public Object get(int col) {
            switch (col) {
                case 0: {
                    return this.session.getAuthority();
                }
                case 1: {
                    return this.session.getLobbyUri();
                }
                case 2: {
                    return this.session.getUsername();
                }
            }
            return "?";
        }
    }

    class Controller
    extends MouseAdapter {
        Controller() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            int row;
            if (event.getClickCount() == 2 && (row = SessionsView.this.table.rowAtPoint(event.getPoint())) != -1) {
                SessionsView.this.shell.hyperlink("" + SessionsView.this.rows[row].session.getLobbyUri());
            }
        }
    }

    class Model
    extends AbstractTableModel {
        Model() {
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Authority";
                }
                case 1: {
                    return "Lobby";
                }
                case 2: {
                    return "Username";
                }
            }
            return "?";
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SessionsView.this.rows.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return SessionsView.this.rows[row].get(col);
        }
    }
}

