/*
 * Decompiled with CFR 0.152.
 */
package obix.ui.views;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import obix.Abstime;
import obix.Feed;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.io.ObixEncoder;
import obix.net.BatchIn;
import obix.ui.Command;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.View;

public class AlarmConsoleView
extends View {
    JTable table;
    Model model;
    List<Row> rows = new ArrayList<Row>();

    public AlarmConsoleView(Shell shell, UiSession.Response resp) throws Exception {
        super(shell, "AlarmConsole", resp);
        this.model = new Model();
        this.table = new JTable(this.model);
        this.table.setAutoResizeMode(0);
        this.table.setSelectionMode(1);
        this.table.addMouseListener(new Controller());
        this.add((Component)new JScrollPane(this.table), "Center");
        Feed feed = (Feed)resp.obj.get("feed");
        feed = (Feed)this.watch().add(feed.getNormalizedHref());
        Obj[] alarms = feed.list();
        for (int i = 0; i < alarms.length; ++i) {
            this.rows.add(new Row(alarms[i]));
        }
    }

    @Override
    public void changed(Obj obj) {
        Feed feed = (Feed)obj;
        Obj[] alarms = feed.list();
        for (int i = 0; i < alarms.length; ++i) {
            this.mergeIntoModel(alarms[i]);
        }
        int[] sel = this.table.getSelectedRows();
        this.model.fireTableDataChanged();
        if (sel != null && sel.length > 0) {
            this.table.getSelectionModel().setSelectionInterval(sel[0], sel[sel.length - 1]);
        }
    }

    public void mergeIntoModel(Obj alarm) {
        Uri href = alarm.getHref();
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = this.rows.get(i);
            Obj existing = row.alarm;
            if (!existing.getHref().equals((Object)href)) continue;
            row.alarm = alarm;
            return;
        }
        this.rows.add(new Row(alarm));
    }

    void doubleClicked(Obj alarm) {
        String xmlStr = ObixEncoder.toString((Obj)alarm);
        JTextArea textArea = new JTextArea(xmlStr, 20, 100);
        JOptionPane.showMessageDialog(this, new JScrollPane(textArea));
    }

    void popup(MouseEvent event) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new Ack());
        menu.show(event.getComponent(), event.getX(), event.getY());
    }

    void ackSelected() throws Exception {
        Obj[] alarms = this.getSelectedAlarms();
        BatchIn batch = this.session.makeBatch();
        for (int i = 0; i < alarms.length; ++i) {
            Op ack = (Op)alarms[i].get("ack");
            if (ack == null) continue;
            batch.invoke(ack, null);
        }
        if (batch.size() > 0) {
            batch.commit();
        }
    }

    Obj[] getSelectedAlarms() {
        int[] rows = this.table.getSelectedRows();
        Obj[] alarms = new Obj[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            alarms[i] = this.rows.get((int)rows[i]).alarm;
        }
        return alarms;
    }

    static class Row {
        Obj alarm;

        Row(Obj alarm) {
            this.alarm = alarm;
        }

        public Object format(int col) {
            Object obj = this.get(col);
            if (obj == null) {
                return "";
            }
            if (obj instanceof Abstime) {
                return ((Abstime)obj).format();
            }
            return obj.toString();
        }

        public Object get(int col) {
            switch (col) {
                case 0: {
                    return this.alarm.get("timestamp");
                }
                case 1: {
                    return this.alarm.get("source");
                }
                case 2: {
                    return this.alarm.get("normalTimestamp");
                }
                case 3: {
                    return this.alarm.get("ackTimestamp");
                }
                case 4: {
                    return this.alarm.get("ackUser");
                }
                case 5: {
                    return this.alarm.get("alarmValue");
                }
                case 6: {
                    return this.alarm.getIs();
                }
            }
            return "?";
        }
    }

    class Model
    extends AbstractTableModel {
        Model() {
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Timestamp";
                }
                case 1: {
                    return "Source";
                }
                case 2: {
                    return "Normal Timestamp";
                }
                case 3: {
                    return "Ack Timestamp";
                }
                case 4: {
                    return "Ack User";
                }
                case 5: {
                    return "Alarm Value";
                }
                case 6: {
                    return "Contracts";
                }
            }
            return "?";
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return AlarmConsoleView.this.rows.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return AlarmConsoleView.this.rows.get(row).format(col);
        }
    }

    public class Ack
    extends Command {
        Ack() {
            super(AlarmConsoleView.this.shell, "Ack", null, null);
        }

        @Override
        public void doInvoke() throws Exception {
            AlarmConsoleView.this.ackSelected();
        }
    }

    class Controller
    extends MouseAdapter {
        Controller() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                AlarmConsoleView.this.popup(event);
                return;
            }
            int row = AlarmConsoleView.this.table.rowAtPoint(event.getPoint());
            if (row != -1) {
                Obj alarm = AlarmConsoleView.this.rows.get((int)row).alarm;
                if (event.getClickCount() == 2) {
                    AlarmConsoleView.this.doubleClicked(alarm);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                AlarmConsoleView.this.popup(event);
            }
        }
    }
}

