/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb;

import com.tridium.systemDb.BInactiveSystemDb;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemDb.BSystemDbPingMonitor;
import com.tridium.systemDb.SystemDbConnection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.driver.ping.BIPingable;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.BFormat;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="health", type="BPingHealth", defaultValue="new BPingHealth()", flags=65), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="monitor", type="BPingMonitor", defaultValue="new BSystemDbPingMonitor()"), @NiagaraProperty(name="systemDatabaseTypeSelection", type="BTypeSpec", defaultValue="BTypeSpec.make(\"systemDb:InactiveSystemDb\")", facets={@Facet(name="BFacets.ALLOW_NULL", value="false"), @Facet(value="BFacets.make(\"showAbstract\", false)"), @Facet(value="BFacets.make(\"showInterface\", false)"), @Facet(name="BFacets.TARGET_TYPE", value="\"systemDb:SystemDb\"")}), @NiagaraProperty(name="systemDatabase", type="BSystemDb", defaultValue="new BInactiveSystemDb()")})
@NiagaraActions(value={@NiagaraAction(name="ping", flags=16), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
public final class BSystemDbService
extends BAbstractService
implements BIPingable,
BIRestrictedComponent,
IPropertyValidator {
    @Generated
    public static final Property health = BSystemDbService.newProperty((int)65, (BValue)new BPingHealth(), null);
    @Generated
    public static final Property alarmSourceInfo = BSystemDbService.newProperty((int)0, (BValue)BSystemDbService.initAlarmSourceInfo(), null);
    @Generated
    public static final Property monitor = BSystemDbService.newProperty((int)0, (BValue)new BSystemDbPingMonitor(), null);
    @Generated
    public static final Property systemDatabaseTypeSelection = BSystemDbService.newProperty((int)0, (BValue)BTypeSpec.make((String)"systemDb:InactiveSystemDb"), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"allowNull", (boolean)false), (BFacets)BFacets.make((String)"showAbstract", (boolean)false)), (BFacets)BFacets.make((String)"showInterface", (boolean)false)), (BFacets)BFacets.make((String)"targetType", (String)"systemDb:SystemDb")));
    @Generated
    public static final Property systemDatabase = BSystemDbService.newProperty((int)0, (BValue)new BInactiveSystemDb(), null);
    @Generated
    public static final Action ping = BSystemDbService.newAction((int)16, null);
    @Generated
    public static final Action ackAlarm = BSystemDbService.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemDbService.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.std((String)"planet.png");
    private static final Lexicon LEXICON = Lexicon.make(BSystemDbService.class);
    private static final String DISABLED = LEXICON.get("systemDb.error.disabled");
    private static final String UNLICENSED = LEXICON.get("systemDb.error.unlicensed");
    static final String START_FAIL = LEXICON.get("systemDb.error.startFail");
    private static final String PING_FAIL = LEXICON.get("systemDb.error.pingFail");
    static final String STOP_FAIL = LEXICON.get("systemDb.error.stopFail");
    private static final String INACTIVE_DB = LEXICON.get("systemDb.error.inactiveSystemDb");
    private static final String NO_CONNECTION = LEXICON.get("systemDb.error.noConnection");
    private static final Logger LOG = BSystemDb.LOGGER;
    private final AtomicBoolean notPinging = new AtomicBoolean(true);
    private final AlarmSupport alarmSupport = new AlarmSupport((BIAlarmSource)this, "");
    final Queue connectQueue = new CoalesceQueue();
    private Worker connectWorker;

    @Generated
    public BPingHealth getHealth() {
        return (BPingHealth)this.get(health);
    }

    @Generated
    public void setHealth(BPingHealth v) {
        this.set(health, (BValue)v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public BPingMonitor getMonitor() {
        return (BPingMonitor)this.get(monitor);
    }

    @Generated
    public void setMonitor(BPingMonitor v) {
        this.set(monitor, (BValue)v, null);
    }

    @Generated
    public BTypeSpec getSystemDatabaseTypeSelection() {
        return (BTypeSpec)this.get(systemDatabaseTypeSelection);
    }

    @Generated
    public void setSystemDatabaseTypeSelection(BTypeSpec v) {
        this.set(systemDatabaseTypeSelection, (BValue)v, null);
    }

    @Generated
    public BSystemDb getSystemDatabase() {
        return (BSystemDb)this.get(systemDatabase);
    }

    @Generated
    public void setSystemDatabase(BSystemDb v) {
        this.set(systemDatabase, (BValue)v, null);
    }

    @Generated
    public void ping() {
        this.invoke(ping, null, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() throws Exception {
        if (this.connectWorker == null && !this.isFatalFault()) {
            this.connectWorker = new Worker((Worker.ITodo)this.connectQueue);
            this.connectWorker.start("SystemDbService:ConnectWorker");
        }
        try {
            this.getSystemDatabaseTypeSelection().getResolvedType();
        }
        catch (Exception typeNotFound) {
            LOG.log(Level.SEVERE, "System Database Type Selection of '" + this.getSystemDatabaseTypeSelection() + "' cannot be resolved. Please check for an uninstalled module that contains this type. Reverting selection to the InactiveSystemDb.", typeNotFound);
            this.setSystemDatabaseTypeSelection(BTypeSpec.make((Type)BInactiveSystemDb.TYPE));
        }
        if (!this.getSystemDatabaseTypeSelection().getResolvedType().equals(this.getSystemDatabase().getType())) {
            this.setSystemDatabase((BSystemDb)this.getSystemDatabaseTypeSelection().getInstance());
        }
    }

    public void started() {
        try {
            this.doPing();
            if (this.getSystemDatabase().getType().is(BInactiveSystemDb.TYPE)) {
                LOG.warning(INACTIVE_DB);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Sys.isStationStarted() && !this.isFatalFault()) {
            try {
                BComponent searchService = BOrd.make((String)"service:search:SearchService").get((BObject)this).asComponent();
                searchService.invoke(searchService.getAction("updateDefaultScopeInfo"), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stationStarted() {
        if (this.isOperational()) {
            this.getSystemDatabase().purgeUnlicensedDatabaseRecords();
        }
    }

    public void serviceStopped() throws Exception {
        if (this.connectWorker != null) {
            this.connectWorker.stop();
        }
        if (!this.getSystemDatabase().isFatalFault()) {
            this.getSystemDatabase().doStopDatabase();
        }
    }

    protected void enabled() {
        if (!this.getSystemDatabase().isFatalFault()) {
            try {
                this.getSystemDatabase().initializeDbServer();
                this.setFaultCause("");
                this.getSystemDatabase().purgeUnlicensedDatabaseRecords();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to enable system database", e);
                this.handleDbFailure(e, START_FAIL, false);
            }
        }
    }

    protected void disabled() {
        if (!this.getSystemDatabase().isFatalFault()) {
            try {
                this.getSystemDatabase().shutdownDbServer();
                this.setFaultCause("");
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to disable system database", e);
                this.handleDbFailure(e, STOP_FAIL, false);
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(ping)) {
            if (!this.isFatalFault()) {
                this.connectQueue.enqueue((Object)new Invocation((BComponent)this, action, argument, cx));
            }
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void changed(Property property, Context context) {
        if (property.equals(systemDatabaseTypeSelection)) {
            BComponentSpace space = this.getComponentSpace();
            if (!(context == Context.decoding || space != null && space.isProxyComponentSpace())) {
                boolean isRunning = this.getSystemDatabase().isRunning();
                if (isRunning && !this.getSystemDatabase().isFatalFault()) {
                    try {
                        this.getSystemDatabase().doStopDatabase();
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Error during shutdown of the system database server", e);
                    }
                }
                BSystemDb newSystemDb = (BSystemDb)this.getSystemDatabaseTypeSelection().getInstance();
                if (this.getSystemDatabase().getType().is(BInactiveSystemDb.TYPE) && !newSystemDb.getType().is(BInactiveSystemDb.TYPE) || isRunning && this.getSystemDatabase().isFatalFault()) {
                    this.configOk();
                }
                this.setSystemDatabase(newSystemDb);
                if (isRunning) {
                    try {
                        this.doPing();
                        if (this.getSystemDatabase().getType().is(BInactiveSystemDb.TYPE)) {
                            LOG.warning(INACTIVE_DB);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        super.changed(property, context);
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        if (this.isRunning()) {
            return this;
        }
        return super.getPropertyValidator(properties, context);
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (this.isRunning()) {
            return this;
        }
        return super.getPropertyValidator(property, context);
    }

    public void validateSet(Validatable validatable, Context context) {
        if (this.isRunning()) {
            try {
                ((BTypeSpec)validatable.getProposedValue(systemDatabaseTypeSelection)).getResolvedType();
            }
            catch (Exception typeNotFound) {
                throw new LocalizableRuntimeException("systemDb", "systemDb.error.invalidSystemDbType");
            }
        }
    }

    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        if (this.isRunning() && property.equals(systemDatabaseTypeSelection)) {
            try {
                ((BTypeSpec)newValue).getResolvedType();
            }
            catch (Exception typeNotFound) {
                throw new LocalizableRuntimeException("systemDb", "systemDb.error.invalidSystemDbType");
            }
        }
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(driver:pingFail)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(driver:pingSuccess)%"));
        return asi;
    }

    public void pingOk() {
        this.getHealth().pingOk();
        this.setFaultCause("");
    }

    public void pingFail(String cause) {
        this.getHealth().pingFail(cause);
        this.setFaultCause(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPing() throws Exception {
        block28: {
            if (this.notPinging.compareAndSet(true, false)) {
                try {
                    if (this.getSystemDatabase().getType().is(BInactiveSystemDb.TYPE)) {
                        this.configFail(INACTIVE_DB);
                    }
                    if (this.getSystemDatabase().isFatalFault() || this.isFault() || this.isDisabled()) {
                        if (this.isFatalFault()) {
                            this.setFaultCause(UNLICENSED);
                        } else if (!this.isFault() && this.isDisabled()) {
                            this.setFaultCause(DISABLED);
                        }
                        break block28;
                    }
                    try {
                        this.getSystemDatabase().doStartDatabase();
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, START_FAIL, e);
                        this.handleDbFailure(e, START_FAIL, true);
                        this.notPinging.set(true);
                        return;
                    }
                    try (SystemDbConnection connection = this.getSystemDatabase().makeConnection(null);){
                        if (connection != null) {
                            this.pingOk();
                        } else {
                            this.setFaultCause(NO_CONNECTION);
                            this.pingFail(NO_CONNECTION);
                        }
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, PING_FAIL, e);
                        this.handleDbFailure(e, PING_FAIL, true);
                    }
                }
                finally {
                    this.notPinging.set(true);
                }
            }
        }
    }

    public void updateStatus() {
        super.updateStatus();
        this.setStatus(this.getStatus());
    }

    public void setStatus(BStatus v) {
        BComponentSpace space = this.getComponentSpace();
        if (space != null && space.getType().equals(BComponentSpace.TYPE)) {
            int oldStatus = this.getStatus().getBits();
            int newStatus = v.getBits();
            newStatus = this.getHealth().getDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
            if (oldStatus == newStatus) {
                return;
            }
            super.setStatus(BStatus.make((int)newStatus));
        } else {
            super.setStatus(v);
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        return this.getHealth().doAckAlarm(ackRequest);
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "systemDb");
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 502) {
            return this.alarmSupport;
        }
        return super.fw(x, a, b, c, d);
    }

    public BIcon getIcon() {
        return icon;
    }

    void handleDbFailure(Exception e, String message, boolean pingFailed) {
        Exception t = e.getCause() != null && (e.getCause() instanceof LocalizableRuntimeException || e.getCause() instanceof LocalizableException) ? e.getCause() : e;
        String prefix = !(t instanceof LocalizableRuntimeException) && !(t instanceof LocalizableException) && message != null && !message.isEmpty() ? message + " : " : "";
        String msg = prefix + (t.getMessage() == null ? t.toString() : t.getMessage());
        this.setFaultCause(msg);
        if (pingFailed) {
            this.pingFail(msg);
        }
    }
}

