/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.messages;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.datatypes.BAxisVideoPanTiltZoomSettings;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.enums.BVideoZoomEnum;

public class AxisVideoZoomRequest
extends NHttpRequest {
    BAxisVideoCamera camera;
    BVideoZoomEnum zoomAction;

    public AxisVideoZoomRequest(BIpAddress ipaddress, BAxisVideoCamera camera, BVideoZoomEnum zoomAction) {
        super(ipaddress);
        this.camera = camera;
        this.zoomAction = zoomAction;
    }

    public int getResponseTimeOut() {
        return 30000;
    }

    public int getRetryCount() {
        return 0;
    }

    public String getMethod() {
        return "GET";
    }

    public String getUri() {
        StringBuilder urlBuf = this.initUrlRequest();
        urlBuf.append(this.getZoomUrlParams());
        return urlBuf.toString();
    }

    private StringBuilder initUrlRequest() {
        StringBuilder buf = new StringBuilder("");
        buf.append("/axis-cgi/com/ptz.cgi?");
        return buf;
    }

    private String getZoomUrlParams() {
        BAxisVideoPanTiltZoomSettings ptzSettings = this.camera.getPanTiltZoomSettings();
        int zoomIndex = 0;
        if (this.zoomAction == BVideoZoomEnum.none) {
            zoomIndex = 0;
        } else if (this.zoomAction == BVideoZoomEnum.reset) {
            zoomIndex = 0;
        } else if (this.zoomAction == BVideoZoomEnum.zoomInFast) {
            zoomIndex = ptzSettings.getZoomIndexFast();
        } else if (this.zoomAction == BVideoZoomEnum.zoomInMedium) {
            zoomIndex = ptzSettings.getZoomIndexMedium();
        } else if (this.zoomAction == BVideoZoomEnum.zoomInSlow) {
            zoomIndex = ptzSettings.getZoomIndexSlow();
        } else if (this.zoomAction == BVideoZoomEnum.zoomOutFast) {
            zoomIndex = -ptzSettings.getZoomIndexFast();
        } else if (this.zoomAction == BVideoZoomEnum.zoomOutMedium) {
            zoomIndex = -ptzSettings.getZoomIndexMedium();
        } else if (this.zoomAction == BVideoZoomEnum.zoomOutSlow) {
            zoomIndex = -ptzSettings.getZoomIndexSlow();
        } else {
            throw new IllegalArgumentException("Unsupported zoomAction: " + this.zoomAction);
        }
        return "continuouszoommove=" + zoomIndex;
    }
}

