/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.messages;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.datatypes.BAxisVideoPanTiltZoomSettings;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;

public class AxisVideoPanTiltRequest
extends NHttpRequest {
    BAxisVideoCamera camera;
    BVideoPanTiltEnum panTiltAction;

    public AxisVideoPanTiltRequest(BIpAddress ipaddress, BAxisVideoCamera camera, BVideoPanTiltEnum panTiltAction) {
        super(ipaddress);
        this.camera = camera;
        this.panTiltAction = panTiltAction;
    }

    public int getResponseTimeOut() {
        return 30000;
    }

    public int getRetryCount() {
        return 0;
    }

    public String getMethod() {
        return "GET";
    }

    public String getUri() {
        StringBuilder urlBuf = this.initUrlRequest();
        urlBuf.append(this.getPanTiltUrlParams());
        return urlBuf.toString();
    }

    private StringBuilder initUrlRequest() {
        BAxisVideoCameraDeviceId camId = (BAxisVideoCameraDeviceId)this.camera.getVideoDeviceId();
        StringBuilder buf = new StringBuilder("");
        buf.append("/axis-cgi/com/ptz.cgi?");
        return buf;
    }

    private String getPanTiltUrlParams() {
        BAxisVideoPanTiltZoomSettings ptzSettings = this.camera.getPanTiltZoomSettings();
        int panDegrees = 0;
        int tiltDegrees = 0;
        if (this.panTiltAction == BVideoPanTiltEnum.panRightSlow) {
            panDegrees = ptzSettings.getPanDegreesSlow();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panRightMedium) {
            panDegrees = ptzSettings.getPanDegreesMedium();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panRightFast) {
            panDegrees = ptzSettings.getPanDegreesFast();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panRightTiltDownSlow) {
            panDegrees = ptzSettings.getPanDegreesSlow();
            tiltDegrees = -ptzSettings.getTiltDegreesSlow();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panRightTiltDownMedium) {
            panDegrees = ptzSettings.getPanDegreesMedium();
            tiltDegrees = -ptzSettings.getTiltDegreesMedium();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panRightTiltDownFast) {
            panDegrees = ptzSettings.getPanDegreesFast();
            tiltDegrees = -ptzSettings.getTiltDegreesFast();
        } else if (this.panTiltAction == BVideoPanTiltEnum.tiltDownSlow) {
            tiltDegrees = -ptzSettings.getTiltDegreesSlow();
        } else if (this.panTiltAction == BVideoPanTiltEnum.tiltDownMedium) {
            tiltDegrees = -ptzSettings.getTiltDegreesMedium();
        } else if (this.panTiltAction == BVideoPanTiltEnum.tiltDownFast) {
            tiltDegrees = -ptzSettings.getTiltDegreesFast();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panLeftTiltDownSlow) {
            panDegrees = -ptzSettings.getPanDegreesSlow();
            tiltDegrees = -ptzSettings.getTiltDegreesSlow();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panLeftTiltDownMedium) {
            panDegrees = -ptzSettings.getPanDegreesMedium();
            tiltDegrees = -ptzSettings.getTiltDegreesMedium();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panLeftTiltDownFast) {
            panDegrees = -ptzSettings.getPanDegreesFast();
            tiltDegrees = -ptzSettings.getTiltDegreesFast();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panLeftSlow) {
            panDegrees = -ptzSettings.getPanDegreesSlow();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panLeftMedium) {
            panDegrees = -ptzSettings.getPanDegreesMedium();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panLeftFast) {
            panDegrees = -ptzSettings.getPanDegreesFast();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panLeftTiltUpSlow) {
            panDegrees = -ptzSettings.getPanDegreesSlow();
            tiltDegrees = ptzSettings.getTiltDegreesSlow();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panLeftTiltUpMedium) {
            panDegrees = -ptzSettings.getPanDegreesMedium();
            tiltDegrees = ptzSettings.getTiltDegreesMedium();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panLeftTiltUpFast) {
            panDegrees = -ptzSettings.getPanDegreesFast();
            tiltDegrees = ptzSettings.getTiltDegreesFast();
        } else if (this.panTiltAction == BVideoPanTiltEnum.tiltUpSlow) {
            tiltDegrees = ptzSettings.getTiltDegreesSlow();
        } else if (this.panTiltAction == BVideoPanTiltEnum.tiltUpMedium) {
            tiltDegrees = ptzSettings.getTiltDegreesMedium();
        } else if (this.panTiltAction == BVideoPanTiltEnum.tiltUpFast) {
            tiltDegrees = ptzSettings.getTiltDegreesFast();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panRightTiltUpSlow) {
            panDegrees = ptzSettings.getPanDegreesSlow();
            tiltDegrees = ptzSettings.getTiltDegreesSlow();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panRightTiltUpMedium) {
            panDegrees = ptzSettings.getPanDegreesMedium();
            tiltDegrees = ptzSettings.getTiltDegreesMedium();
        } else if (this.panTiltAction == BVideoPanTiltEnum.panRightTiltUpFast) {
            panDegrees = ptzSettings.getPanDegreesFast();
            tiltDegrees = ptzSettings.getTiltDegreesFast();
        } else if (this.panTiltAction == BVideoPanTiltEnum.none) {
            panDegrees = 0;
            tiltDegrees = 0;
        } else {
            throw new IllegalArgumentException("Unsupported panTiltAction: " + this.panTiltAction);
        }
        return "continuouspantiltmove=" + panDegrees + "," + tiltDegrees;
    }
}

