/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.event.enableEvents;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.naxisVideo.messages.AxisVideoReadParameterGroupReq;
import com.tridium.naxisVideo.util.AxisHttpUtil;
import com.tridium.naxisVideo.util.BAxisUserNameAndPassword;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import javax.baja.security.BPassword;

public class AxisParameterUtil {
    public static String queryGroup(BAxisVideoCamera avCamera, String parameterKeyPattern, String queryParameterValue) throws ReadGroupException, ParameterNotFoundException {
        String strRsp = AxisParameterUtil.readGroup(avCamera, parameterKeyPattern);
        String key = AxisHttpUtil.inspectRightHtml(queryParameterValue, strRsp);
        if (key == null) {
            throw new ParameterNotFoundException(parameterKeyPattern, queryParameterValue);
        }
        return key;
    }

    public static String readGroup(BAxisVideoCamera avCamera, String groupPatternWithWildCards) throws ReadGroupException {
        AxisVideoReadParameterGroupReq readParameterReq = new AxisVideoReadParameterGroupReq(new BIpAddress(((BAxisVideoCameraDeviceId)avCamera.getVideoDeviceId()).getUrlAddress(), ((BAxisVideoCameraDeviceId)avCamera.getVideoDeviceId()).getWebPort()), avCamera, groupPatternWithWildCards);
        String passKey = avCamera.getUpdatedVideoKey();
        BAxisUserNameAndPassword usernameAndPassword = new BAxisUserNameAndPassword();
        usernameAndPassword.setUsername(avCamera.getCredentials().getUsername());
        usernameAndPassword.setPassword(BPassword.make((String)passKey));
        readParameterReq.setUsernamePassword(usernameAndPassword);
        readParameterReq.addBasicAuthorization(avCamera.getCredentials().getUsername(), passKey);
        readParameterReq.setRetryCount(5);
        readParameterReq.setResponseTimeOut(20000);
        byte[] rsp = null;
        try {
            rsp = avCamera.getAxisVideoNetwork().hcomm().sendRequest((NHttpRequest)readParameterReq).getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rsp == null) {
            throw new ReadGroupException(groupPatternWithWildCards);
        }
        return new String(rsp);
    }

    public static void updateParameter(BAxisVideoCamera avCamera, String key, String value) throws UnableToUpdateParameterException {
        AxisVideoReadParameterGroupReq updateParameterReq = new AxisVideoReadParameterGroupReq(new BIpAddress(((BAxisVideoCameraDeviceId)avCamera.getVideoDeviceId()).getUrlAddress(), ((BAxisVideoCameraDeviceId)avCamera.getVideoDeviceId()).getWebPort()), avCamera, "update", key + '=' + value, false);
        String passKey = avCamera.getUpdatedVideoKey();
        BAxisUserNameAndPassword usernameAndPassword = new BAxisUserNameAndPassword();
        usernameAndPassword.setUsername(avCamera.getCredentials().getUsername());
        usernameAndPassword.setPassword(BPassword.make((String)passKey));
        updateParameterReq.setUsernamePassword(usernameAndPassword);
        updateParameterReq.addBasicAuthorization(avCamera.getCredentials().getUsername(), passKey);
        updateParameterReq.setRetryCount(5);
        updateParameterReq.setResponseTimeOut(20000);
        byte[] rsp = null;
        try {
            rsp = avCamera.getAxisVideoNetwork().hcomm().sendRequest((NHttpRequest)updateParameterReq).getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rsp == null) {
            throw new UnableToUpdateParameterException(key + '=' + value);
        }
    }

    public static String addParameterGroup(BAxisVideoCamera avCamera, String addCmd) throws UnableToAddGroupException {
        addCmd = addCmd.replaceAll("\\s+", "+");
        AxisVideoReadParameterGroupReq addParameterGroupReq = new AxisVideoReadParameterGroupReq(new BIpAddress(((BAxisVideoCameraDeviceId)avCamera.getVideoDeviceId()).getUrlAddress(), ((BAxisVideoCameraDeviceId)avCamera.getVideoDeviceId()).getWebPort()), avCamera, "add", addCmd);
        String passKey = avCamera.getUpdatedVideoKey();
        BAxisUserNameAndPassword usernameAndPassword = new BAxisUserNameAndPassword();
        usernameAndPassword.setUsername(avCamera.getCredentials().getUsername());
        usernameAndPassword.setPassword(BPassword.make((String)passKey));
        addParameterGroupReq.setUsernamePassword(usernameAndPassword);
        addParameterGroupReq.addBasicAuthorization(avCamera.getCredentials().getUsername(), passKey);
        addParameterGroupReq.setRetryCount(5);
        addParameterGroupReq.setResponseTimeOut(20000);
        byte[] rsp = null;
        try {
            rsp = avCamera.getAxisVideoNetwork().hcomm().sendRequest((NHttpRequest)addParameterGroupReq).getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rsp == null) {
            throw new UnableToAddGroupException(addCmd);
        }
        String[] results = AxisHttpUtil.inspectHtml("(.*) OK", 1, new String(rsp));
        if (results == null) {
            throw new UnableToAddGroupException(addCmd);
        }
        return results[1];
    }

    public static class UnableToUpdateParameterException
    extends Exception {
        public String updateParameterCmd;

        public UnableToUpdateParameterException(String updateParameterCmd) {
            this.updateParameterCmd = updateParameterCmd;
        }

        @Override
        public String toString() {
            return "Unable to Update Parameter (" + this.updateParameterCmd + ')';
        }
    }

    public static class UnableToAddGroupException
    extends Exception {
        public String addGroupCmd;

        public UnableToAddGroupException(String addGroupCmd) {
            this.addGroupCmd = addGroupCmd;
        }

        @Override
        public String toString() {
            return "Unable to Add Parameter Group (" + this.addGroupCmd + ")\nThe maximum number of event server entries permitted by the camera may have been exceeded. Check the camera's 'Event' configuration page.";
        }
    }

    public static class ParameterNotFoundException
    extends Exception {
        public String groupPatternWithWildCards;
        public String queryForString;

        public ParameterNotFoundException(String groupPatternWithWildCards, String queryForString) {
            this.groupPatternWithWildCards = groupPatternWithWildCards;
            this.queryForString = queryForString;
        }

        @Override
        public String toString() {
            return "ParameterNotFound (" + this.groupPatternWithWildCards + '=' + this.queryForString + ')';
        }
    }

    public static class ReadGroupException
    extends Exception {
        public String description;

        public ReadGroupException(String description) {
            this.description = description;
        }

        @Override
        public String toString() {
            return "Unable to Read Parameter Group (" + this.description + ')';
        }
    }
}

