/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.discover.dns;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.net.DatagramPacket;

public class DnsHeader {
    private int id;
    private int flags;
    private int qdCount;
    private int anCount;
    private int nsCount;
    private int arCount;

    public static void main(String[] args) throws IOException {
        DnsHeader header = DnsHeader.makeMulticastDnsQueryHeader();
        System.out.println(header.getId());
        System.out.println(header.getFlags());
        System.out.println(header.getQuestionCount());
        System.out.println(header.getAnswerCount());
        System.out.println(header.getAuthorityCount());
        System.out.println(header.getAdditionalRecordCount());
    }

    public static DnsHeader makeMulticastDnsQueryHeader() throws IOException {
        byte[] header = new byte[]{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0};
        DnsHeader multicastHeader = new DnsHeader();
        multicastHeader.read(header);
        return multicastHeader;
    }

    public static DnsHeader readHeader(DataInput in) throws IOException {
        DnsHeader header = new DnsHeader();
        header.read(in);
        return header;
    }

    public void read(DataInput in) throws IOException {
        this.id = in.readUnsignedShort();
        this.flags = in.readUnsignedShort();
        this.qdCount = in.readUnsignedShort();
        this.anCount = in.readUnsignedShort();
        this.nsCount = in.readUnsignedShort();
        this.arCount = in.readUnsignedShort();
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.id);
        out.writeShort(this.flags);
        out.writeShort(this.qdCount);
        out.writeShort(this.anCount);
        out.writeShort(this.nsCount);
        out.writeShort(this.arCount);
    }

    public void read(ByteArrayInputStream in) throws IOException {
        this.read(new DataInputStream(in));
    }

    public void read(DatagramPacket packet) throws IOException {
        this.read(packet.getData());
    }

    public void read(byte[] data) throws IOException {
        if (data == null || data.length < 12) {
            return;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.read(bis);
    }

    public int getId() {
        return this.id;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getQueryFlag() {
        return (this.flags & 0x8000) >> 15;
    }

    public boolean isQuery() {
        return this.getQueryFlag() == 0;
    }

    public boolean isResponse() {
        return !this.isQuery();
    }

    public int getOpcode() {
        return (this.flags & 0x7800) >> 11;
    }

    public boolean isStandardQuery() {
        return this.getOpcode() == 0;
    }

    public boolean isInverseQuery() {
        return this.getOpcode() == 1;
    }

    public boolean isServerStatusRequest() {
        return this.getOpcode() == 2;
    }

    public int getAuthoritativeAnswerFlag() {
        return (this.flags & 0x400) >> 10;
    }

    public boolean isAuthoritativeAnswer() {
        return this.getAuthoritativeAnswerFlag() == 1;
    }

    public int getTruncationFlag() {
        return (this.flags & 0x200) >> 9;
    }

    public boolean isTruncated() {
        return this.getTruncationFlag() == 1;
    }

    public int getRecursionDesiredFlag() {
        return (this.flags & 0x100) >> 8;
    }

    public boolean isRecursionDesired() {
        return this.getRecursionDesiredFlag() == 1;
    }

    public int getRecusionAvailableFlag() {
        return (this.flags & 0x80) >> 7;
    }

    public boolean isRecursionAvailable() {
        return this.getRecusionAvailableFlag() == 1;
    }

    public int getReservedFlag() {
        return (this.flags & 0x70) >> 4;
    }

    public int getResponseCode() {
        return this.flags & 0xF;
    }

    public boolean isNoError() {
        return this.getResponseCode() == 0;
    }

    public boolean isFormatError() {
        return this.getResponseCode() == 1;
    }

    public boolean isServerFailure() {
        return this.getResponseCode() == 2;
    }

    public boolean isNameError() {
        return this.getResponseCode() == 3;
    }

    public boolean isNotImplemented() {
        return this.getResponseCode() == 4;
    }

    public boolean isOperationRefused() {
        return this.getResponseCode() == 5;
    }

    public int getQuestionCount() {
        return this.qdCount;
    }

    public int getAnswerCount() {
        return this.anCount;
    }

    public int getAuthorityCount() {
        return this.nsCount;
    }

    public int getAdditionalRecordCount() {
        return this.arCount;
    }
}

