/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.ui.terminal;

import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.ui.terminal.BInfinityVirtualTerminal;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.text.TextController;

public class InfinityVt100TextController
extends TextController {
    BInfinityVirtualTerminal manager;

    public InfinityVt100TextController(BInfinityVirtualTerminal manager) {
        this.manager = manager;
    }

    public void keyPressed(BKeyEvent event) {
        char keyChar = event.getKeyChar();
        if (event.isControlDown() && keyChar == '\u0014') {
            return;
        }
        event.consume();
    }

    public void keyReleased(BKeyEvent event) {
        int keyCode = event.getKeyCode();
        char keyChar = event.getKeyChar();
        if (keyChar == '\uffff') {
            if (keyCode == 112) {
                this.manager.exec("\u001bOP");
            }
            if (keyCode == 113) {
                this.manager.exec("\u001bOQ");
            }
            if (keyCode == 114) {
                this.manager.exec("\u001bOR");
            }
            if (keyCode == 115) {
                this.manager.exec("\u001bOS");
            }
            if (keyCode == 123) {
                this.manager.exec(Vt100Const.F12);
            } else if (keyCode == 34) {
                if (this.manager.net.getPageUpPageDown()) {
                    this.manager.exec(String.valueOf("\u001b[6~"));
                } else {
                    this.manager.exec(String.valueOf(Vt100Const.CURSOR_PAGE_DOWN));
                }
            } else if (keyCode == 33) {
                if (this.manager.net.getPageUpPageDown()) {
                    this.manager.exec(String.valueOf("\u001b[5~"));
                } else {
                    this.manager.exec(String.valueOf(Vt100Const.CURSOR_PAGE_UP));
                }
            } else if (keyCode == 37) {
                this.manager.exec("\u001b[D");
            } else if (keyCode == 38) {
                this.manager.exec("\u001b[A");
            } else if (keyCode == 39) {
                this.manager.exec("\u001b[C");
            } else if (keyCode == 40) {
                this.manager.exec("\u001b[B");
            } else if (keyCode == 9 && event.isShiftDown()) {
                this.manager.exec("\u001b\t");
            }
        }
        event.consume();
    }

    public void keyTyped(BKeyEvent event) {
        if (event.isAltDown()) {
            return;
        }
        char keyChar = event.getKeyChar();
        if (event.isControlDown()) {
            if (keyChar == '\u001a') {
                event.consume();
                this.manager.exec("\u001a");
                return;
            }
            if (keyChar == '\u0003' || keyChar == '\u0014') {
                super.keyTyped(event);
                return;
            }
        }
        if (event.isShiftDown() && keyChar == '\t') {
            this.manager.exec("\u001b\t");
            event.consume();
            return;
        }
        this.manager.exec(String.valueOf(keyChar));
        event.consume();
    }

    public void mouseEntered(BMouseEvent event) {
        this.getEditor().setMouseCursor(MouseCursor.normal);
    }

    public void mouseExited(BMouseEvent event) {
        this.getEditor().setMouseCursor(MouseCursor.normal);
    }

    public void mousePressed(BMouseEvent event) {
        this.getEditor().requestFocus();
        this.getEditor().moveCaretPosition(this.manager.getCaretPosition());
    }

    public void mouseDragged(BMouseEvent event) {
    }
}

