/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.ui;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.ui.terminal.BInfinityVirtualTerminal;
import com.tridium.workbench.nav.BComponentMenuAgent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.agent.BIAgent;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.space.BSpace;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;

@NiagaraType(agent={@AgentOn(types={"andoverInfinity:InfinityNetwork"}, requiredPermissions="W")})
@NiagaraSingleton
public class BInfinityBufferLoaderMenuAgent
extends BComponentMenuAgent
implements BIAgent {
    @Generated
    public static final BInfinityBufferLoaderMenuAgent INSTANCE = new BInfinityBufferLoaderMenuAgent();
    @Generated
    public static final Type TYPE = Sys.loadType(BInfinityBufferLoaderMenuAgent.class);
    SaveScreenBufferToFileCommand savecmd;
    LoadScreenBufferFromFileCommand loadcmd;
    BInfinityNetwork dev;
    BWidget owner;
    static BOrd backupDir = null;
    static BOrd backupFile = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        this.owner = owner;
        BMenu menu = super.doMakeMenu(owner, target, cx);
        if (!((BInfinityNetwork)target).isMounted()) {
            return menu;
        }
        if (((BComponent)target).getComponentSpace() != null) {
            this.savecmd = new SaveScreenBufferToFileCommand(owner, (BInfinityNetwork)target);
            menu.add("ScreenBufferToFileCmd", (Command)this.savecmd);
            this.loadcmd = new LoadScreenBufferFromFileCommand(owner, (BInfinityNetwork)target);
            menu.add("ScreenBufferFromFileCmd", (Command)this.loadcmd);
            menu.add(null, (BValue)new BSeparator());
        }
        return menu;
    }

    private static ByteBuffer readBytesFromRestore(BIFile restoreFile) throws IOException {
        try (InputStream restoreFileIn = restoreFile.getInputStream();){
            ByteBuffer testBytes = new ByteBuffer(restoreFileIn.available());
            testBytes.readToEnd(restoreFileIn);
            ByteBuffer byteBuffer = testBytes;
            return byteBuffer;
        }
    }

    public class LoadScreenBufferFromFileCommand
    extends Command {
        BInfinityNetwork target;

        public LoadScreenBufferFromFileCommand(BWidget owner, BInfinityNetwork target) {
            super(owner, BInfinityNetwork.TYPE.getModule().getLexicon(), "loadScreenBufferAgent");
            this.target = target;
        }

        public CommandArtifact doInvoke() {
            BOrd ord;
            BFileChooser chooser = BFileChooser.makeOpen((BWidget)this.getOwner());
            chooser.setCurrentDirectory(backupDir);
            chooser.setConfirmOverwrite(false);
            chooser.addFilter((IFileFilter)new ExtFileFilter("txt Files", new String[]{"txt", "TXT"}));
            BFileSystem space = BFileSystem.INSTANCE;
            if (space != null) {
                chooser.setSpaces(new BSpace[]{space});
            }
            if ((ord = chooser.show()) == null) {
                return null;
            }
            backupDir = chooser.getCurrentDirectory();
            backupFile = ord;
            try {
                this.target.getComponentSpace().sync();
                this.target.lease(2, 60000L);
                BIFile restoreFile = (BIFile)ord.resolve().get();
                ByteBuffer testBytes = BInfinityBufferLoaderMenuAgent.readBytesFromRestore(restoreFile);
                System.out.print(new String(testBytes.getBytes()));
                BBlob testBlob = BBlob.make((byte[])testBytes.getBytes());
                this.target.loadScreenBufferFromFile(testBlob);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public class SaveScreenBufferToFileCommand
    extends Command {
        BInfinityNetwork target;

        public SaveScreenBufferToFileCommand(BWidget owner, BInfinityNetwork target) {
            super(owner, BInfinityNetwork.TYPE.getModule().getLexicon(), "saveScreenBufferAgent");
            this.target = target;
        }

        public CommandArtifact doInvoke() {
            BOrd ord;
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setCurrentDirectory(backupDir);
            chooser.addFilter((IFileFilter)new ExtFileFilter("txt Files", new String[]{"txt", "TXT"}));
            BFileSystem space = BFileSystem.INSTANCE;
            if (space != null) {
                chooser.setSpaces(new BSpace[]{space});
            }
            if ((ord = chooser.show()) == null) {
                return null;
            }
            backupDir = chooser.getCurrentDirectory();
            backupFile = ord;
            BBlob results = this.target.saveScreenBufferToFile();
            if (results != null) {
                byte[] fileBytes = results.copyBytes();
                System.out.println(new String(fileBytes));
                BFileSystem fs = BFileSystem.INSTANCE;
                try {
                    BIFile tmpFile = fs.makeFile(BInfinityVirtualTerminal.toFilePath(ord));
                    OutputStream backupOutputStream = tmpFile.getOutputStream();
                    backupOutputStream.write(fileBytes);
                    backupOutputStream.close();
                    backupOutputStream = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

