/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nss.BSecurityService;
import com.tridium.nss.BSystemDashboardStationLinkMode;
import com.tridium.nss.dashboard.BDashboardData;
import com.tridium.nss.dashboard.BIStationSecurityDashboard;
import com.tridium.nss.dashboard.BSecurityDashboardDataImport;
import com.tridium.nss.dashboard.IRemoteDashboardDataRetriever;
import com.tridium.util.PxUtil;
import java.util.HashSet;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.driver.util.BDescriptorDeviceExt;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.security.dashboard.BISecurityDashboardItemProvider;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="dashboardData", type="BDashboardData", defaultValue="BDashboardData.DEFAULT", flags=7), @NiagaraProperty(name="dataImporter", type="BSecurityDashboardDataImport", defaultValue="new BSecurityDashboardDataImport()")})
public abstract class BAbstractSecurityDashboardDeviceExt
extends BDescriptorDeviceExt
implements BIMixIn,
BINiagaraDeviceExt,
BIRestrictedComponent,
BFoxClientConnection.Interest,
BIStationSecurityDashboard {
    @Generated
    public static final Property dashboardData = BAbstractSecurityDashboardDeviceExt.newProperty((int)7, (BValue)BDashboardData.DEFAULT, null);
    @Generated
    public static final Property dataImporter = BAbstractSecurityDashboardDeviceExt.newProperty((int)0, (BValue)new BSecurityDashboardDataImport(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractSecurityDashboardDeviceExt.class);
    private static final BIcon icon = BIcon.std((String)"shield.png");
    protected static final BOrd SECURITY_SERVICE_DASHBOARD_VIEW_ORD = BOrd.make((String)"station:|service:nss:SecurityService|view:nss:SecurityDashboardView?selectedMode=stationView");
    protected static final BOrd DASHBOARD_VIEW_ORD = BOrd.make((String)"view:nss:SecurityDashboardView?selectedMode=stationView");
    protected static final Logger LOGGER = Logger.getLogger("securityDashboard");
    protected Integer remoteHttpsPort;

    @Generated
    public BDashboardData getDashboardData() {
        return (BDashboardData)this.get(dashboardData);
    }

    @Generated
    public void setDashboardData(BDashboardData v) {
        this.set(dashboardData, (BValue)v, null);
    }

    @Generated
    public BSecurityDashboardDataImport getDataImporter() {
        return (BSecurityDashboardDataImport)this.get(dataImporter);
    }

    @Generated
    public void setDataImporter(BSecurityDashboardDataImport v) {
        this.set(dataImporter, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    abstract IRemoteDashboardDataRetriever getDataRetriever();

    public abstract String getStationName();

    protected abstract BStatus getStatus();

    protected abstract boolean isStationUnavailable();

    protected abstract Optional<String> getRemoteHostSecurityDashboardViewFoxOrd();

    protected abstract Optional<String> getRemoteHostSecurityDashboardViewHttpUri();

    protected abstract void refreshHttpsPort();

    protected abstract boolean shouldDisplayRemoteLink(BSystemDashboardStationLinkMode var1);

    protected void executeOk() {
    }

    protected void executeFail(Throwable reason) {
    }

    public final AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("nss:SecurityDashboardView");
        return PxUtil.movePxViewsToTop((AgentList)list);
    }

    public JSONObject getSystemDashboardData(String lastDataTimestamp, Context cx) {
        if (!this.isRunning() || BAbstractSecurityDashboardDeviceExt.isSystemSecurityDashboardUnoperational()) {
            return null;
        }
        if (!this.getPermissions(cx).hasAdminRead()) {
            throw new PermissionException(cx.getUser() + " does not have admin read permissions on the extension.");
        }
        if (this.getDataImporter().isDisabled() || this.getDataImporter().isFatalFault() || !this.getDataImporter().remoteStationSupported.get()) {
            return null;
        }
        BDashboardData currentDashboardData = this.getDashboardData();
        BStatus deviceStatus = this.getStatus();
        String refreshStatus = this.getRefreshStatus();
        if (this.isStationUnavailable()) {
            if (currentDashboardData.isNull()) {
                return this.makeStationStatusOnlyResponse(this.getDataImporter().getStatus(), cx);
            }
            return currentDashboardData.getTimestamp().equals(lastDataTimestamp) ? this.makeStatusOnlyResponse(deviceStatus, refreshStatus, cx) : this.makeDataResponse(deviceStatus, refreshStatus, currentDashboardData, cx);
        }
        if (lastDataTimestamp == null && !currentDashboardData.isNull()) {
            return this.makeDataResponse(deviceStatus, refreshStatus, currentDashboardData, cx);
        }
        if (this.getDataImporter().getState() != BDescriptorState.idle) {
            return this.makeStatusOnlyResponse(deviceStatus, "inProgress", cx);
        }
        if (currentDashboardData.isNull()) {
            this.refreshSystemDashboardData(cx);
            return this.makeStatusOnlyResponse(deviceStatus, "inProgress", cx);
        }
        return currentDashboardData.getTimestamp().equals(lastDataTimestamp) ? this.makeStatusOnlyResponse(deviceStatus, refreshStatus, cx) : this.makeDataResponse(deviceStatus, refreshStatus, currentDashboardData, cx);
    }

    public JSONObject refreshSystemDashboardData(Context cx) {
        if (!this.isRunning() || BAbstractSecurityDashboardDeviceExt.isSystemSecurityDashboardUnoperational()) {
            return null;
        }
        if (!this.getPermissions(cx).hasAdminRead()) {
            throw new PermissionException(cx.getUser() + " does not have admin read permissions on the extension.");
        }
        if (this.isStationUnavailable()) {
            return this.makeStationStatusOnlyResponse(this.getDataImporter().getStatus(), cx);
        }
        this.getDataImporter().execute();
        return this.makeRefreshInProgress(cx);
    }

    private JSONObject makeRefreshInProgress(Context cx) {
        JSONObject json = new JSONObject();
        json.put("refreshStatus", (Object)"inProgress");
        json.put("stationName", (Object)this.getStationName());
        this.getStationDashboardViewOrd(cx).ifPresent(ord -> json.put("ord", ord));
        return json;
    }

    private JSONObject makeStationStatusOnlyResponse(BStatus stationStatus, Context cx) {
        JSONObject json = new JSONObject();
        json.put("stationName", (Object)this.getStationName());
        this.getStationDashboardViewOrd(cx).ifPresent(ord -> json.put("ord", ord));
        json.put("stationStatus", (Object)BAbstractSecurityDashboardDeviceExt.statusToString(stationStatus));
        return json;
    }

    private JSONObject makeStatusOnlyResponse(BStatus stationStatus, String refreshStatus, Context cx) {
        JSONObject json = new JSONObject();
        json.put("stationName", (Object)this.getStationName());
        this.getStationDashboardViewOrd(cx).ifPresent(ord -> json.put("ord", ord));
        json.put("stationStatus", (Object)BAbstractSecurityDashboardDeviceExt.statusToString(stationStatus));
        json.put("refreshStatus", (Object)refreshStatus);
        return json;
    }

    private JSONObject makeDataResponse(BStatus stationStatus, String refreshStatus, BDashboardData dashboardData, Context cx) {
        JSONObject json = new JSONObject();
        json.put("stationName", (Object)this.getStationName());
        this.getStationDashboardViewOrd(cx).ifPresent(ord -> json.put("ord", ord));
        json.put("stationStatus", (Object)BAbstractSecurityDashboardDeviceExt.statusToString(stationStatus));
        json.put("refreshStatus", (Object)refreshStatus);
        JSONObject dashboardJSON = dashboardData.toJSON();
        json.put("stationDashboardData", (Object)dashboardJSON);
        BAbstractSecurityDashboardDeviceExt.getVersionStatuses(dashboardJSON).ifPresent(vs -> json.put("versionStatuses", vs));
        return json;
    }

    private Optional<String> getStationDashboardViewOrd(Context cx) {
        boolean workbenchBrowser = cx != null && cx.getFacets().getb("workbenchBrowser", false);
        boolean remoteLink = false;
        Optional service = Sys.findService((Type)BSecurityService.TYPE);
        if (service.isPresent() && this.shouldDisplayRemoteLink(((BSecurityService)service.get()).getStationLinkConfig())) {
            remoteLink = true;
        }
        if (remoteLink) {
            return workbenchBrowser ? this.getRemoteHostSecurityDashboardViewFoxOrd() : this.getRemoteHostSecurityDashboardViewHttpUri();
        }
        return this.getDeviceExtSecurityDashboardViewOrd();
    }

    private Optional<String> getDeviceExtSecurityDashboardViewOrd() {
        return Optional.of(BOrd.make((BOrd)this.getOrdInHost(), (BOrd)DASHBOARD_VIEW_ORD).toString());
    }

    protected Optional<Integer> getHttpsPort() {
        if (this.remoteHttpsPort == null) {
            this.refreshHttpsPort();
        }
        return Optional.ofNullable(this.remoteHttpsPort);
    }

    private static Optional<JSONObject> getVersionStatuses(JSONObject dashboardJSON) {
        if (!dashboardJSON.has("sections")) {
            return Optional.empty();
        }
        JSONArray remoteOutOfDate = new JSONArray();
        JSONArray supervisorOutOfDate = new JSONArray();
        JSONArray supervisorMissingType = new JSONArray();
        HashSet<String> typesChecked = new HashSet<String>();
        JSONArray sections = dashboardJSON.getJSONArray("sections");
        for (int i = 0; i < sections.length(); ++i) {
            JSONObject section = sections.getJSONObject(i);
            JSONArray subsections = section.getJSONArray("subsections");
            for (int j = 0; j < subsections.length(); ++j) {
                JSONObject subsection = subsections.getJSONObject(j);
                String type = JSONUtil.getString((JSONObject)subsection, (String)"subsectionProviderType");
                if (typesChecked.contains(type)) continue;
                typesChecked.add(type);
                try {
                    BObject typeInstance = BTypeSpec.make((String)type).getInstance();
                    if (typeInstance instanceof BISecurityDashboardItemProvider) {
                        int remoteVersion;
                        int supervisorVersion = ((BISecurityDashboardItemProvider)typeInstance).getSecurityDashboardItemsVersion();
                        if (supervisorVersion < (remoteVersion = subsection.getInt("subsectionVersion"))) {
                            supervisorOutOfDate.put((Object)type);
                            continue;
                        }
                        if (supervisorVersion <= remoteVersion) continue;
                        remoteOutOfDate.put((Object)type);
                        continue;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        String sectionHeaderLexiconKey = BAbstractSecurityDashboardDeviceExt.getHeaderLexiconKey(section);
                        LOGGER.fine("Security dashboard subsection within section " + sectionHeaderLexiconKey + " is of type " + type + " and is not an instance of BISecurityDashboardItemProvider on the supervisor.");
                    }
                    supervisorOutOfDate.put((Object)type);
                    continue;
                }
                catch (Exception e) {
                    supervisorMissingType.put((Object)type);
                }
            }
        }
        JSONObject versionStatuses = new JSONObject();
        if (remoteOutOfDate.length() > 0) {
            versionStatuses.put("remoteOutOfDate", (Object)remoteOutOfDate);
        }
        if (supervisorOutOfDate.length() > 0) {
            versionStatuses.put("supervisorOutOfDate", (Object)supervisorOutOfDate);
        }
        if (supervisorMissingType.length() > 0) {
            versionStatuses.put("supervisorMissingType", (Object)supervisorMissingType);
        }
        if (versionStatuses.length() > 0) {
            return Optional.of(versionStatuses);
        }
        return Optional.empty();
    }

    private static String getHeaderLexiconKey(JSONObject section) {
        String lexiconKey = "";
        try {
            lexiconKey = JSONUtil.getString((JSONObject)section.getJSONObject("sectionHeader"), (String)"lexiconKey");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lexiconKey;
    }

    private static String statusToString(BStatus status) {
        if (status.isDisabled()) {
            return status.getTag(1);
        }
        if (status.isFault()) {
            return status.getTag(2);
        }
        if (status.isDown()) {
            return status.getTag(4);
        }
        if (status.isStale()) {
            return status.getTag(16);
        }
        return status.getEmptyTag();
    }

    private String getRefreshStatus() {
        if (this.getDataImporter().getState().equals((Object)BDescriptorState.idle)) {
            if (!this.getDataImporter().getLastFailure().isNull() && this.getDataImporter().getLastFailure().isAfter(this.getDataImporter().getLastSuccess())) {
                return "failed";
            }
            return "success";
        }
        return "inProgress";
    }

    static boolean isSystemSecurityDashboardUnoperational() {
        try {
            if (BSecurityService.isSystemSecurityDashboardLicensed()) {
                BSecurityService securityService = (BSecurityService)Sys.getService((Type)Sys.getType((String)"nss:SecurityService"));
                return !securityService.isOperational();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getDevice();
    }

    protected BFoxClientConnection getClientConnection() {
        return this.getNiagaraStation().getClientConnection();
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("securityDashboardDeviceExt");
    }

    public void clientOpened() {
    }

    public void clientClosed() {
    }

    public void serverOpened() {
    }

    public void serverClosed() {
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        SlotCursor slots = parent.getProperties();
        while (slots.next(BAbstractSecurityDashboardDeviceExt.class)) {
            if (slots.get() == this) continue;
            throw new IllegalChildException("nss", "securityDashboardDeviceExt.duplicateDashboardExt", new Object[]{this.getType()});
        }
        this.doCheckParentForRestrictedComponent(parent, cx);
    }

    protected void doCheckParentForRestrictedComponent(BComponent parent, Context context) {
    }

    public void started() throws Exception {
        BSecurityService securityService;
        super.started();
        try {
            securityService = (BSecurityService)Sys.getService((Type)Sys.getType((String)"nss:SecurityService"));
        }
        catch (ServiceNotFoundException snfe) {
            throw new ServiceNotFoundException(Lexicon.make((String)"nss").get("securityDashboardDeviceExt.noSecurityService"), (Throwable)snfe);
        }
        Slot dashboardDataSlot = this.getSlot(this.getDashboardData().getName());
        int dashboardDataSlotFlags = this.getFlags(dashboardDataSlot);
        if (securityService.getSaveDashboardDataToBog()) {
            this.setFlags(dashboardDataSlot, dashboardDataSlotFlags & 0xFFFFFFFD, null);
        } else {
            this.setFlags(dashboardDataSlot, dashboardDataSlotFlags | 2, null);
        }
    }

    @Override
    public boolean isStationDashboardEnabled() {
        return !BAbstractSecurityDashboardDeviceExt.isSystemSecurityDashboardUnoperational() && !this.getDataImporter().isFatalFault() && !this.getDataImporter().isDisabled() && this.getDataImporter().remoteStationSupported.get();
    }

    @Override
    public JSONObject getStationDashboardData(Context cx) {
        JSONObject systemDashboardData = this.getSystemDashboardData(null, cx);
        if (systemDashboardData == null) {
            return null;
        }
        JSONObject stationDashboardData = systemDashboardData.optJSONObject("stationDashboardData");
        if (stationDashboardData == null) {
            return null;
        }
        JSONArray sections = (JSONArray)stationDashboardData.get("sections");
        for (int i = 0; i < sections.length(); ++i) {
            sections.getJSONObject(i).put("ord", (Object)BOrd.DEFAULT.toString(null));
        }
        return stationDashboardData;
    }

    public BIcon getIcon() {
        return icon;
    }
}

