/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss;

import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nss.BCertificateExpiryPoint;
import com.tridium.nss.BCertificateFolder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import java.util.function.Function;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alias", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")"), @Facet(value="BFacets.make(\"purposeId\", \"\")")}), @NiagaraProperty(name="expiry", type="BCertificateExpiryPoint", defaultValue="new BCertificateExpiryPoint()", flags=1), @NiagaraProperty(name="usedIn", type="BFolder", defaultValue="new BFolder()", flags=3)})
public class BCertificateInfo
extends BComponent {
    @Generated
    public static final Property alias = BCertificateInfo.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"purposeId", (String)"")));
    @Generated
    public static final Property expiry = BCertificateInfo.newProperty((int)1, (BValue)new BCertificateExpiryPoint(), null);
    @Generated
    public static final Property usedIn = BCertificateInfo.newProperty((int)3, (BValue)new BFolder(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateInfo.class);
    private Clock.Ticket updateTicket;
    private final Function<String, X509Certificate> certificateMapper;
    private static final Lexicon lex = Lexicon.make(BCertificateInfo.class);

    @Generated
    public String getAlias() {
        return this.getString(alias);
    }

    @Generated
    public void setAlias(String v) {
        this.setString(alias, v, null);
    }

    @Generated
    public BCertificateExpiryPoint getExpiry() {
        return (BCertificateExpiryPoint)this.get(expiry);
    }

    @Generated
    public void setExpiry(BCertificateExpiryPoint v) {
        this.set(expiry, (BValue)v, null);
    }

    @Generated
    public BFolder getUsedIn() {
        return (BFolder)this.get(usedIn);
    }

    @Generated
    public void setUsedIn(BFolder v) {
        this.set(usedIn, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCertificateInfo() {
        this(BCertificateInfo::getCertificateForAlias);
    }

    public BCertificateInfo(Function<String, X509Certificate> certificateMapper) {
        this.certificateMapper = certificateMapper;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BCertificateFolder;
    }

    public void changed(Property property, Context context) {
        if (context != Context.decoding && property == alias) {
            this.getExpiry().execute();
        }
        super.changed(property, context);
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.updateTicket = Clock.schedulePeriodically((BComponent)this.getExpiry(), (BRelTime)BRelTime.HOUR, (Action)BControlPoint.execute, null);
        if (this.getAlias() != null && !this.getAlias().isEmpty()) {
            this.getExpiry().execute();
        }
    }

    public void descendantsStopped() throws Exception {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
        }
        super.descendantsStopped();
    }

    public X509Certificate getCertificate() {
        return this.certificateMapper.apply(this.getAlias());
    }

    private static X509Certificate getCertificateForAlias(String alias) {
        X509Certificate certificate = null;
        try {
            certificate = AccessController.doPrivileged(() -> {
                CoreCryptoManager ccm = CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                return ccm.getKeyStore().getCertificate(alias);
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae.getException());
        }
        return certificate;
    }
}

