/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth;

import com.tridium.authn.ScramServerCallback;
import com.tridium.authn.UserKeyFactory;
import com.tridium.gauth.BGoogleAuthAuthenticator;
import com.tridium.gauth.BGoogleAuthenticationScheme;
import com.tridium.gauth.GoogleAuthCallbackHandler;
import com.tridium.gauth.GoogleAuthenticator;
import com.tridium.net.HttpUtil;
import com.tridium.nre.auth.NiagaraStationAlgorithmBundle;
import com.tridium.nre.auth.ScramAlgorithmBundle;
import com.tridium.nre.auth.ScramServer;
import com.tridium.web.session.WebSessionUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.web.authn.BWebCallbackHandler;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType(agent={@AgentOn(types={"gauth:GoogleAuthenticationScheme"})})
public class BWebGoogleAuthCallbackHandler
extends BWebCallbackHandler
implements GoogleAuthCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BWebGoogleAuthCallbackHandler.class);
    public static final String ACTION_CLIENT_FIRST_MESSAGE = "sendClientFirstMessage";
    public static final String ACTION_CLIENT_FINAL_MESSAGE = "sendClientFinalMessage";
    public static final String KEY_CLIENT_FIRST_MESSAGE = "clientFirstMessage";
    public static final String KEY_CLIENT_FINAL_MESSAGE = "clientFinalMessage";
    private ScramServer scramServer = null;
    private String username = null;
    private boolean finalRequest = false;
    private String token = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public int handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String[] pairs;
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.finalRequest) {
            return 0;
        }
        if (req.getContentType() == null || !req.getContentType().startsWith("application/x-niagara-login-support")) {
            return 3;
        }
        byte[] buf = new byte[req.getContentLength()];
        DataInputStream in = new DataInputStream((InputStream)req.getInputStream());
        in.readFully(buf);
        String contents = new String(buf);
        for (String pair : pairs = TextUtil.split((String)contents, (char)'&')) {
            int index = pair.indexOf(61);
            String key = pair.substring(0, index);
            String value = pair.substring(index + 1);
            params.put(HttpUtil.decodeUrl((String)key), BWebGoogleAuthCallbackHandler.decodeValue(key, value));
        }
        if (((String)params.get("action")).equals(ACTION_CLIENT_FIRST_MESSAGE)) {
            String clientFirstMessage = (String)params.get(KEY_CLIENT_FIRST_MESSAGE);
            this.scramServer = new ScramServer((ScramAlgorithmBundle)NiagaraStationAlgorithmBundle.getInstance(), (ScramServer.IUserKeyFactory)new UserKeyFactory(BGoogleAuthenticationScheme.TYPE));
            this.username = ScramServer.extractUsername((String)clientFirstMessage);
            String serverFirstMessage = this.scramServer.createServerFirstMessage(clientFirstMessage);
            WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true);
            resp.setStatus(200);
            resp.setContentType("text/plain");
            resp.getWriter().print(serverFirstMessage);
            resp.getWriter().flush();
            return 1;
        }
        if (((String)params.get("action")).equals(ACTION_CLIENT_FINAL_MESSAGE)) {
            String clientFinalMessage = (String)params.get(KEY_CLIENT_FINAL_MESSAGE);
            if (this.scramServer == null) {
                throw new AuthenticationException("CallbackHandler in incorrect state");
            }
            String serverFinalMessage = null;
            try {
                serverFinalMessage = this.scramServer.createServerFinalMessage(clientFinalMessage);
            }
            catch (Exception exception) {
                // empty catch block
            }
            resp.setStatus(200);
            resp.setContentType("text/plain");
            resp.getWriter().print(serverFinalMessage);
            resp.getWriter().flush();
            return 1;
        }
        if ("sendGoogleToken".equals(params.get("action"))) {
            this.token = (String)params.get("token");
            this.finalRequest = true;
            return 1;
        }
        resp.sendError(400);
        return 1;
    }

    public String getUsername() {
        return this.username;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof ScramServerCallback) {
                ((ScramServerCallback)callback).setServer(this.scramServer);
                ((ScramServerCallback)callback).setUsername(this.username);
                continue;
            }
            if (callback instanceof TextInputCallback) {
                ((TextInputCallback)callback).setText(this.token);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
        }
    }

    public boolean containsCredentialsResetInfo(HttpServletRequest request, String username) {
        BUser user = BUserService.getService().getUser(username);
        if (user == null || !(user.getAuthenticator() instanceof BGoogleAuthAuthenticator)) {
            return false;
        }
        BGoogleAuthAuthenticator authenticator = (BGoogleAuthAuthenticator)user.getAuthenticator();
        return request.getParameter("resetToken") != null && (request.getParameter("confirmToken") != null || !authenticator.getForceSecretKeyResetAtNextLogin());
    }

    public void handleCredentialsReset(HttpServletRequest request, String username) throws LocalizableException {
        BUser user = BUserService.getService().getUser(username);
        BAbstractAuthenticator auth = user.getAuthenticator();
        if (!(auth instanceof BGoogleAuthAuthenticator)) {
            throw new LocalizableException("gauth", "credentials.reset.invalidAuthenticator");
        }
        BGoogleAuthAuthenticator authenticator = (BGoogleAuthAuthenticator)auth;
        String resetToken = BWebGoogleAuthCallbackHandler.getAndDecodeParameter(request, "resetToken", false);
        String confirmToken = BWebGoogleAuthCallbackHandler.getAndDecodeParameter(request, "confirmToken", !authenticator.getForceSecretKeyResetAtNextLogin());
        if (authenticator.getPasswordConfig().getForceResetAtNextLogin() && resetToken.isEmpty()) {
            throw new LocalizableException("gauth", "credentials.reset.emptyPassword");
        }
        boolean updateSecretKey = false;
        String secretKey = (String)request.getSession().getAttribute("gauth.secretKey");
        if (authenticator.getForceSecretKeyResetAtNextLogin()) {
            if (confirmToken.isEmpty()) {
                throw new LocalizableException("gauth", "credentials.reset.emptyToken");
            }
            if (secretKey == null || secretKey.isEmpty()) {
                throw new LocalizableException("gauth", "credentials.reset.missingSecretKey");
            }
            try {
                GoogleAuthenticator googleAuthenticator = new GoogleAuthenticator(secretKey);
                if (!googleAuthenticator.checkToken(Long.parseLong(confirmToken))) {
                    throw new LocalizableException("gauth", "credentials.reset.invalidToken");
                }
                updateSecretKey = true;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new LocalizableException("gauth", "credentials.reset.cannotValidate", (Throwable)e);
            }
        }
        if (authenticator.getPasswordConfig().getForceResetAtNextLogin()) {
            if (((BPasswordCache)user.getAuthenticator()).validate(resetToken)) {
                throw new LocalizableException(Lexicon.make((String)"baja"), "user.strongPassword.alreadyUsed");
            }
            authenticator.set(BPasswordAuthenticator.password, (BValue)BPassword.make((String)resetToken), Context.forceValidate);
            authenticator.getPasswordConfig().setForceResetAtNextLogin(false);
        }
        if (updateSecretKey) {
            authenticator.setSecretKey(BPassword.make((String)secretKey));
            authenticator.setForceSecretKeyResetAtNextLogin(false);
        }
    }

    @Override
    public boolean supportsSecretKeyReset() {
        return true;
    }

    private static String decodeValue(String key, String value) {
        if (key.equals(KEY_CLIENT_FIRST_MESSAGE) || key.equals(KEY_CLIENT_FINAL_MESSAGE)) {
            return value;
        }
        return HttpUtil.decodeUrl((String)value);
    }

    private static String getAndDecodeParameter(HttpServletRequest request, String paramName, boolean allowBlank) throws LocalizableException {
        String decodedParameter;
        String rawParameter = request.getParameter(paramName);
        if (rawParameter == null && !allowBlank) {
            throw new LocalizableException("gauth", "credentials.reset.missingParam", new Object[]{paramName});
        }
        try {
            decodedParameter = rawParameter != null ? new String(Base64.getDecoder().decode(rawParameter), StandardCharsets.UTF_8) : "";
        }
        catch (Exception e) {
            throw new LocalizableException("gauth", "credentials.reset.invalidParam", new Object[]{paramName}, (Throwable)e);
        }
        return decodedParameter;
    }
}

