/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth;

import com.tridium.gauth.BGoogleAuthAuthenticator;
import com.tridium.gauth.BGoogleAuthenticationScheme;
import com.tridium.gauth.GoogleAuthenticator;
import com.tridium.user.BGlobalPasswordConfiguration;
import com.tridium.web.Template;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.web.authn.BILoginHTMLForm;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@NiagaraType(agent={@AgentOn(types={"gauth:GoogleAuthenticationScheme"})})
public class BGoogleAuthLoginHTMLForm
extends BStruct
implements BILoginHTMLForm {
    @Generated
    public static final Type TYPE = Sys.loadType(BGoogleAuthLoginHTMLForm.class);
    private BAuthenticationScheme authnScheme;
    private HttpSession session;
    public static final String ATTR_SECRET_KEY = "gauth.secretKey";
    private static final BOrd TEMPLATE_ORD = BOrd.make((String)"module://gauth/com/tridium/gauth/rc/googleAuthLoginFormN4.vm");
    private static final BOrd RESET_TEMPLATE_ORD = BOrd.make((String)"module://gauth/com/tridium/gauth/rc/googleAuthPasswordResetFormN4.vm");
    private static final BOrd RESET_MESSAGE_TEMPLATE_ORD = BOrd.make((String)"module://gauth/com/tridium/gauth/rc/googleAuthResetMessageN4.vm");
    private static final Logger LOGGER = Logger.getLogger("gauth");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void initialize(HttpServletRequest request, BAuthenticationScheme authnScheme, Context context) {
        this.authnScheme = authnScheme;
        this.session = request.getSession(false);
    }

    public String getLoginFormHTML(Context context, boolean passwordReset) throws IOException {
        if (context == null) {
            context = new BasicContext();
        }
        if (passwordReset) {
            return this.getPasswordResetForm(context);
        }
        return BGoogleAuthLoginHTMLForm.getLoginForm(context);
    }

    public String getResetMessageHTML(HttpServletRequest request, Context context) throws IOException {
        boolean forceTokenReset;
        if (!(this.authnScheme instanceof BGoogleAuthenticationScheme)) {
            LOGGER.warning("Authentication scheme mismatch, expected BGoogleAuthenticationScheme");
            return "";
        }
        BUser user = BUserService.getService().getUser(((BString)context.getFacet("initUsername")).getString());
        BAbstractAuthenticator authenticator = user.getAuthenticator();
        if (!(authenticator instanceof BGoogleAuthAuthenticator)) {
            LOGGER.warning("Authenticator scheme mismatch, expected BGoogleAuthAuthenticator");
            return "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        BGoogleAuthAuthenticator googleAuthenticator = (BGoogleAuthAuthenticator)authenticator;
        boolean forcePasswordReset = googleAuthenticator.getPasswordConfig().getForceResetAtNextLogin();
        map.put("passResetHidden", forcePasswordReset ? "" : "style=\"display:none\"");
        if (forcePasswordReset) {
            BGlobalPasswordConfiguration config = ((BPasswordAuthenticationScheme)this.authnScheme).getGlobalPasswordConfiguration();
            BPasswordStrength strength = config.getPasswordStrength();
            Lexicon lex = Lexicon.make((String)"web", (Locale)request.getLocale());
            Lexicon bajaLex = Lexicon.make((String)"baja", (Locale)request.getLocale());
            map.put("resetTitle", BGoogleAuthLoginHTMLForm.getLabel(context, "login.password.reset", lex));
            map.put("resetMessage", BGoogleAuthLoginHTMLForm.getLabel(context, "login.password.reset.details", lex));
            map.put("strength", BGoogleAuthLoginHTMLForm.getLabel(context, "user.password.notStrong", bajaLex));
            map.put("length", bajaLex.getHtmlSafeText("user.password.notLongEnough", new Object[]{String.valueOf(strength.getMinimumLength())}));
            map.put("digits", bajaLex.getHtmlSafeText("user.password.notEnoughDigits", new Object[]{String.valueOf(strength.getMinimumDigits())}));
            map.put("lower", bajaLex.getHtmlSafeText("user.password.notEnoughLowerCase", new Object[]{String.valueOf(strength.getMinimumLowerCase())}));
            map.put("upper", bajaLex.getHtmlSafeText("user.password.notEnoughUpperCase", new Object[]{String.valueOf(strength.getMinimumUpperCase())}));
            map.put("special", bajaLex.getHtmlSafeText("user.password.notEnoughSpecial", new Object[]{String.valueOf(strength.getMinimumSpecial())}));
            map.put("maxLength", bajaLex.getHtmlSafeText("user.password.notShortEnough", new Object[]{String.valueOf(strength.getMaximumLength())}));
        }
        map.put("tokenResetHidden", (forceTokenReset = googleAuthenticator.getForceSecretKeyResetAtNextLogin()) ? "" : "style=\"display:none\"");
        if (forceTokenReset) {
            Lexicon lex = Lexicon.make((String)"gauth", (Locale)request.getLocale());
            map.put("qrTitle", BGoogleAuthLoginHTMLForm.getLabel(context, "auth.qrInstructions.title", lex));
            map.put("qrInstructions", BGoogleAuthLoginHTMLForm.getLabel(context, "auth.qrInstructions.webReset", lex));
        }
        return Template.process(map, (BOrd)RESET_MESSAGE_TEMPLATE_ORD);
    }

    private static String getLabel(Context context, String key, Lexicon lex) {
        BString bString = (BString)context.getFacet(key);
        if (bString != null) {
            return bString.getString();
        }
        return lex.getHtmlSafe(key);
    }

    private static String getLoginForm(Context context) throws IOException {
        Lexicon webLex = Lexicon.make((String)"web", (Locale)new Locale(context.getLanguage()));
        Lexicon lex = Lexicon.make((String)"gauth", (Locale)new Locale(context.getLanguage()));
        BString initUsername = (BString)context.getFacet("initUsername");
        String username = BGoogleAuthLoginHTMLForm.getLabel(context, "login.username", webLex);
        String password = BGoogleAuthLoginHTMLForm.getLabel(context, "login.password", webLex);
        String token = BGoogleAuthLoginHTMLForm.getLabel(context, "auth.token", lex);
        String login = BGoogleAuthLoginHTMLForm.getLabel(context, "login", webLex);
        String changeUser = BGoogleAuthLoginHTMLForm.getLabel(context, "login.changeuser", webLex);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("login", login);
        map.put("userName", username);
        map.put("password", password);
        map.put("token", token);
        map.put("changeUser", changeUser);
        map.put("hideToken", "");
        map.put("initUsername", initUsername == null ? "" : initUsername.getString());
        if (initUsername != null) {
            BUser user = BUserService.getService().getUser(initUsername.getString());
            BGoogleAuthAuthenticator authenticator = (BGoogleAuthAuthenticator)user.getAuthenticator();
            map.put("hideToken", authenticator.isTokenCheckRequired() ? "" : "style=\"display:none\"");
        }
        String form = Template.process((BOrd)TEMPLATE_ORD, (boolean)true);
        return Template.process(map, (String)form);
    }

    private String getPasswordResetForm(Context context) throws IOException {
        boolean forceSecretKeyReset;
        Lexicon webLex = Lexicon.make((String)"web", (Locale)new Locale(context.getLanguage()));
        Lexicon lex = Lexicon.make((String)"gauth", (Locale)new Locale(context.getLanguage()));
        BString initUsername = (BString)context.getFacet("initUsername");
        HashMap<String, String> map = new HashMap<String, String>();
        String submit = BGoogleAuthLoginHTMLForm.getLabel(context, "auth.submit", lex);
        map.put("login", submit);
        BUser user = BUserService.getService().getUser(initUsername.getString());
        BGoogleAuthAuthenticator authenticator = (BGoogleAuthAuthenticator)user.getAuthenticator();
        boolean forcePasswordReset = authenticator.getPasswordConfig().getForceResetAtNextLogin();
        map.put("passwordHidden", forcePasswordReset ? "" : "style=\"display:none\"");
        if (forcePasswordReset) {
            String newPass = BGoogleAuthLoginHTMLForm.getLabel(context, "login.password.new", webLex);
            String confirm = BGoogleAuthLoginHTMLForm.getLabel(context, "login.password.new.retype", webLex);
            map.put("new", newPass);
            map.put("confirm", confirm);
        }
        map.put("qrHidden", (forceSecretKeyReset = authenticator.getForceSecretKeyResetAtNextLogin()) ? "" : "style=\"display:none\"");
        if (forceSecretKeyReset) {
            String token = BGoogleAuthLoginHTMLForm.getLabel(context, "auth.token", lex);
            String qrCode = BGoogleAuthLoginHTMLForm.getLabel(context, "auth.qrCode", lex);
            String secretKey = GoogleAuthenticator.createSecret();
            String stationName = BGoogleAuthLoginHTMLForm.getStationName(context);
            GoogleAuthenticator gauth = new GoogleAuthenticator(secretKey);
            String svg = gauth.getQRBarcodeSVG(initUsername.getString(), stationName);
            svg = svg.substring(svg.indexOf("<svg"));
            map.put("qrSvg", svg);
            map.put("qrCode", qrCode);
            map.put("qrKey", secretKey);
            map.put("qrAccount", initUsername.getString() + "@" + stationName);
            map.put("token", token);
            if (this.session != null) {
                this.session.setAttribute(ATTR_SECRET_KEY, (Object)secretKey);
            }
        }
        String form = Template.process((BOrd)RESET_TEMPLATE_ORD, (boolean)true);
        return Template.process(map, (String)form);
    }

    private static String getStationName(Context context) {
        return Sys.getStation().getStationDisplayName(context);
    }
}

