/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.util.FoxScramShaUtil;
import com.tridium.gauth.BGoogleAuthCredentials;
import com.tridium.gauth.BGoogleAuthenticationScheme;
import javax.baja.fox.authn.BFoxClientAuthnHandler;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.BUsernameCredential;
import javax.baja.sys.BIObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"gauth:GoogleAuthenticationScheme"})})
public class BFoxGoogleClientAuthnHandler
extends BFoxClientAuthnHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxGoogleClientAuthnHandler.class);
    private BUsernameCredential username = new BUsernameCredential();
    private static final String SCHEME_NAME = new BGoogleAuthenticationScheme().getSchemeName();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void handleAuthentication(FoxSession session, AuthenticationClient authenticationClient) throws Exception {
        BGoogleAuthCredentials seedCredential;
        BFoxSession realm = ((BFoxClientConnection)session.conn()).getFoxSession();
        BICredentials credentials = authenticationClient.requestInformation((AuthenticationRealm)realm, SCHEME_NAME, 0, (BIObject)(seedCredential = new BGoogleAuthCredentials(this.username.getUsername(), BPassword.DEFAULT)));
        if (credentials == null) {
            throw new FoxAuthenticationException("Cancelled", SCHEME_NAME, null, session);
        }
        if (!(credentials instanceof BGoogleAuthCredentials)) {
            throw new FoxAuthenticationException(Lexicon.make((String)"gauth").getText("authnHandler.unsupportedCredentials", new Object[]{credentials.getType()}), SCHEME_NAME, null, session);
        }
        BGoogleAuthCredentials cred = (BGoogleAuthCredentials)credentials;
        FoxScramShaUtil.handleClientAuthentication((FoxSession)session, (BUsernameAndPassword)cred, (String)SCHEME_NAME);
        FoxMessage out = new FoxMessage();
        out.add("authToken", cred.getToken());
        session.setState("client.tune send authToken");
        session.sendTuning("authToken", out);
    }

    public void setData(BIObject data) {
        if (!(data instanceof BUsernameCredential)) {
            throw new UnsupportedOperationException("Data type not supported.");
        }
        this.username = (BUsernameCredential)data;
    }
}

