/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.comm;

import com.tridium.driver.util.DrUtil;
import com.tridium.edgeIo.BEdgeIoNetwork;
import com.tridium.edgeIo.comm.EdgeIoListener;
import com.tridium.platEdgeIo.BEdgeIoPlatformService;
import java.util.logging.Level;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class EdgeIoReceive {
    public static final int INCOMING_BUFFER_SIZE = 1024;
    private ReceiveDriver rcvDriver;
    private Thread rcvThread = null;
    private boolean done = true;
    private BEdgeIoNetwork net;
    private BEdgeIoPlatformService service;
    private EdgeIoListener listener;

    public EdgeIoReceive(BEdgeIoNetwork n) {
        this.net = n;
    }

    public void start() throws Exception {
        this.done = false;
        this.service = (BEdgeIoPlatformService)Sys.getService((Type)BEdgeIoPlatformService.TYPE);
        this.listener = new EdgeIoListener(this.net);
        this.rcvDriver = new ReceiveDriver();
        this.rcvThread = new Thread((Runnable)this.rcvDriver, this.net.getNetworkName() + ".receive");
        this.rcvThread.start();
        this.rcvThread.setPriority(7);
    }

    public void stop() {
        this.done = true;
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
        }
        this.rcvDriver.finished();
        this.net = null;
        this.service = null;
        this.listener = null;
    }

    private class ReceiveDriver
    implements Runnable {
        boolean finished = false;

        private ReceiveDriver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] incoming = new byte[1024];
            while (!EdgeIoReceive.this.done) {
                try {
                    int len = EdgeIoReceive.this.service.read(incoming);
                    EdgeIoReceive.this.net.printMsgByteLog(incoming, len, true);
                    EdgeIoReceive.this.listener.receiveIncoming(incoming, len);
                }
                catch (ThreadDeath e) {
                    EdgeIoReceive.this.done = true;
                }
                catch (BajaRuntimeException rt) {
                    System.out.println("exiting ReceiveDriver:" + rt.getMessage());
                    return;
                }
                catch (Throwable e) {
                    EdgeIoReceive.this.net.setFaultCause(e.getMessage());
                    EdgeIoReceive.this.net.log().log(Level.SEVERE, "EdgeIoReceive thread error", e);
                    DrUtil.wait((int)200);
                }
            }
            ReceiveDriver receiveDriver = this;
            synchronized (receiveDriver) {
                this.finished = true;
                this.notifyAll();
            }
        }

        synchronized void finished() {
            int cnt = 0;
            while (!this.finished) {
                DrUtil.wait((int)500);
                if (++cnt <= 5) continue;
                return;
            }
        }
    }
}

