/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo;

import com.tridium.edgeIo.BEdgeIoNetwork;
import com.tridium.edgeIo.messages.UpdateAnalog;
import com.tridium.edgeIo.messages.UpdateCount;
import com.tridium.edgeIo.messages.UpdateDigital;
import com.tridium.edgeIo.point.BEdgeIoPointDeviceExt;
import com.tridium.edgeIo.point.BEdgeIoProxyExt;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.util.SfUtil;
import java.util.HashMap;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="points", type="BEdgeIoPointDeviceExt", defaultValue="new BEdgeIoPointDeviceExt()"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_READONLY)")}, override=true)})
public class BEdgeIoDevice
extends BNDevice {
    @Generated
    public static final Property points = BEdgeIoDevice.newProperty((int)0, (BValue)new BEdgeIoPointDeviceExt(), null);
    @Generated
    public static final Property status = BEdgeIoDevice.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    @Generated
    public static final Type TYPE = Sys.loadType(BEdgeIoDevice.class);
    private static final BIcon icon = BIcon.std((String)"deviceLocal.png");
    HashMap<Integer, BEdgeIoProxyExt> pointHash = new HashMap();

    @Generated
    public BEdgeIoPointDeviceExt getPoints() {
        return (BEdgeIoPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BEdgeIoPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BEdgeIoNetwork.TYPE;
    }

    public boolean isNavChild() {
        super.isNavChild();
        return false;
    }

    public void doPing() {
        this.pingOk();
    }

    public BIcon getIcon() {
        BValue dynamic = this.get("icon");
        if (dynamic instanceof BIcon) {
            return (BIcon)dynamic;
        }
        return icon;
    }

    public final BEdgeIoNetwork getEdgeIoNetwork() {
        return (BEdgeIoNetwork)this.getNetwork();
    }

    public void registerPoint(BEdgeIoProxyExt ext) {
        if (!ext.isDefined()) {
            return;
        }
        int pntId = ext.getPointId();
        BEdgeIoProxyExt orig = this.pointHash.putIfAbsent(pntId, ext);
        if (orig != null) {
            this.toFault(ext, "Duplicate point id " + pntId);
        }
    }

    public void unregisterPoint(BEdgeIoProxyExt ext) {
        int pntId = ext.getPointId();
        this.pointHash.remove(pntId);
    }

    public BEdgeIoProxyExt getPointExt(int pointId) {
        return this.pointHash.get(pointId);
    }

    private boolean okayToReceiveUpdate() {
        return this.isRunning() && Sys.isStationStarted() && !this.getStatus().isDisabled();
    }

    public void updateAnalog(UpdateAnalog msg) {
        if (!this.okayToReceiveUpdate()) {
            return;
        }
        BEdgeIoProxyExt ext = this.pointHash.get(msg.pointId);
        if (ext == null) {
            this.getLogger().warning("Received analog update from unknown point id - " + Integer.toHexString(msg.pointId));
            return;
        }
        if (ext.getStatus().isDisabled()) {
            return;
        }
        if (!ext.isNumeric()) {
            this.getLogger().warning("Received analog update for invalid point type " + ext.getParent().getDisplayName(null));
            return;
        }
        ext.receiveUpdate(msg);
    }

    public void updateDigital(UpdateDigital msg) {
        if (!this.okayToReceiveUpdate()) {
            return;
        }
        BEdgeIoProxyExt ext = this.pointHash.get(msg.pointId);
        if (ext == null) {
            this.getLogger().warning("Received digital update from unknown point id - " + Integer.toHexString(msg.pointId));
            return;
        }
        if (ext.getStatus().isDisabled()) {
            return;
        }
        if (!ext.isBoolean()) {
            this.getLogger().warning("Received digital update for invalid point type " + ext.getParent().getDisplayName(null));
            return;
        }
        ext.receiveUpdate(msg);
    }

    public void updateCount(UpdateCount msg) {
        if (!this.okayToReceiveUpdate()) {
            return;
        }
        BEdgeIoProxyExt ext = this.pointHash.get(msg.pointId);
        if (ext == null) {
            this.getLogger().warning("Received pulse input update from unknown point id - " + Integer.toHexString(msg.pointId));
            return;
        }
        if (ext.getStatus().isDisabled()) {
            return;
        }
        if (!ext.isPulseInput()) {
            this.getLogger().warning("Received pulse input update for invalid point type " + ext.getParent().getDisplayName(null));
            return;
        }
        ext.receiveUpdate(msg);
    }

    public void receiveHeartBeat() {
    }

    private void toFault(BEdgeIoProxyExt ext, String cause) {
        ext.setStatus(BStatus.fault);
        ext.setFaultCause(cause);
    }
}

