/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.util;

import com.vykon.vykonPro.util.BBroadcastMessage;
import com.vykon.vykonPro.util.BSingleCastMessage;
import com.vykon.vykonPro.util.BWbMessengerNotification;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BWbMessenger
extends BComponent {
    public static final Action sendBroadcast = BWbMessenger.newAction((int)0, (BValue)new BBroadcastMessage(), null);
    public static final Action sendToSingleUser = BWbMessenger.newAction((int)0, (BValue)new BSingleCastMessage(), null);
    public static final Type TYPE = Sys.loadType(BWbMessenger.class);
    private static final BIcon icon = BIcon.std((String)"note.png");

    public void sendBroadcast(BBroadcastMessage message) {
        this.invoke(sendBroadcast, (BValue)message, null);
    }

    public void sendToSingleUser(BSingleCastMessage message) {
        this.invoke(sendToSingleUser, (BValue)message, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == sendToSingleUser) {
            return this.getDefaultSingleCastMessage();
        }
        return super.getActionParameterDefault(action);
    }

    public BSingleCastMessage getDefaultSingleCastMessage() {
        BOrd queryOrd = BOrd.make((String)"service:fox:FoxService|bql:select user.name from fox:FoxServerConnection");
        BITable res = (BITable)queryOrd.resolve((BObject)this).get();
        Array nameArray = new Array(String.class);
        Column userCol = res.getColumns().get(0);
        try (TableCursor c = res.cursor();){
            while (c.next()) {
                if (nameArray.contains((Object)c.cell(userCol).toString())) continue;
                nameArray.add((Object)c.cell(userCol).toString());
            }
        }
        String[] names = (String[])nameArray.trim();
        BEnumRange range = BEnumRange.make((String[])names);
        BDynamicEnum user = BDynamicEnum.make((int)0, (BEnumRange)range);
        return new BSingleCastMessage(user, "", false);
    }

    public void doSendBroadcast(BBroadcastMessage msg, Context cx) {
        BWbMessengerNotification n = new BWbMessengerNotification();
        n.setTargetUser("all");
        n.setSourceUser(cx.getUser().getName());
        n.setMsg(msg.getMessage());
        n.setEchoMessage(msg.getEchoMessage());
        n.raise(true);
    }

    public void doSendToSingleUser(BSingleCastMessage msg, Context cx) {
        BWbMessengerNotification n = new BWbMessengerNotification();
        n.setTargetUser(msg.getUser().getTag());
        n.setSourceUser(cx.getUser().getName());
        n.setMsg(msg.getMessage());
        n.setEchoMessage(msg.getEchoMessage());
        n.raise(true);
    }

    public BIcon getIcon() {
        return icon;
    }
}

