/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.util;

import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHyperlinkList
extends BComponent {
    public static final Property numberOfHyperlinks = BHyperlinkList.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Type TYPE = Sys.loadType(BHyperlinkList.class);
    private static final BIcon icon = BIcon.std((String)"hyperlink.png");

    public int getNumberOfHyperlinks() {
        return this.getInt(numberOfHyperlinks);
    }

    public void setNumberOfHyperlinks(int v) {
        this.setInt(numberOfHyperlinks, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkOrds();
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(numberOfHyperlinks)) {
            this.initHyperlinks();
        } else if (prop.getName().startsWith("hyperlinkOrd")) {
            this.checkOrds();
        }
    }

    public void initHyperlinks() {
        block3: {
            int numSlots;
            int numLinks;
            block2: {
                numLinks = this.getNumberOfHyperlinks();
                if (numLinks <= (numSlots = ((BOrd[])this.getChildren(BOrd.class)).length)) break block2;
                for (int i = 1; i <= numLinks; ++i) {
                    if (i <= numSlots) continue;
                    this.add("hyperlinkOrd" + i, (BValue)BHyperlinkList.makeDefaultOrd());
                    this.add("hyperlinkDisplay" + i, BHyperlinkList.makeDefaultString());
                    this.add("external" + i, BHyperlinkList.makeDefaultBoolean(), 1);
                }
                break block3;
            }
            if (numLinks >= numSlots) break block3;
            for (int i = 1; i <= numSlots; ++i) {
                if (i <= numLinks) continue;
                this.remove("hyperlinkOrd" + i);
                this.remove("hyperlinkDisplay" + i);
                this.remove("external" + i);
            }
        }
    }

    private void checkOrds() {
        int numLinks = this.getNumberOfHyperlinks();
        BOrd[] ords = (BOrd[])this.getChildren(BOrd.class);
        for (int i = 1; i <= numLinks; ++i) {
            OrdQuery[] queries;
            if (this.get("external" + i) == null) {
                this.add("external" + i, BHyperlinkList.makeDefaultBoolean(), 1);
            }
            if (ords[i - 1].equals((Object)BOrd.DEFAULT) || (queries = ords[i - 1].parse()).length <= 0) continue;
            String scheme = queries[0].getScheme().toLowerCase();
            if (scheme.equals("ip") || scheme.equals("http") || scheme.equals("https")) {
                this.set("external" + i, (BValue)BBoolean.make((boolean)true));
                continue;
            }
            this.set("external" + i, (BValue)BBoolean.make((boolean)false));
        }
    }

    private static BOrd makeDefaultOrd() {
        BOrd o = BOrd.NULL;
        return o;
    }

    private static BValue makeDefaultString() {
        BString s = BString.make((String)"");
        return s;
    }

    private static BValue makeDefaultBoolean() {
        BBoolean b = BBoolean.make((boolean)false);
        return b;
    }

    public BIcon getIcon() {
        return icon;
    }
}

