/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.timer;

import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public class BWeeklyTrigger
extends BComponent {
    public static final Property triggerTime = BWeeklyTrigger.newProperty((int)256, (BValue)BTime.DEFAULT, null);
    public static final Property triggerDayOfWeek = BWeeklyTrigger.newProperty((int)256, (BValue)BWeekday.make((int)1), null);
    public static final Property triggerWeekInterval = BWeeklyTrigger.newProperty((int)256, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)BInteger.MAX.getInt()));
    public static final Property lastTrigger = BWeeklyTrigger.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property nextTrigger = BWeeklyTrigger.newProperty((int)1, (BValue)BAbsTime.END_OF_TIME, null);
    public static final Action presetNextTrigger = BWeeklyTrigger.newAction((int)256, (BValue)BAbsTime.make(), null);
    public static final Action ticketExpired = BWeeklyTrigger.newAction((int)4, null);
    public static final Topic trigger = BWeeklyTrigger.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BWeeklyTrigger.class);
    private static final BIcon icon = BIcon.std((String)"control/trigger.png");
    Clock.Ticket ticket = null;

    public BTime getTriggerTime() {
        return (BTime)this.get(triggerTime);
    }

    public void setTriggerTime(BTime v) {
        this.set(triggerTime, (BValue)v, null);
    }

    public BWeekday getTriggerDayOfWeek() {
        return (BWeekday)this.get(triggerDayOfWeek);
    }

    public void setTriggerDayOfWeek(BWeekday v) {
        this.set(triggerDayOfWeek, (BValue)v, null);
    }

    public int getTriggerWeekInterval() {
        return this.getInt(triggerWeekInterval);
    }

    public void setTriggerWeekInterval(int v) {
        this.setInt(triggerWeekInterval, v, null);
    }

    public BAbsTime getLastTrigger() {
        return (BAbsTime)this.get(lastTrigger);
    }

    public void setLastTrigger(BAbsTime v) {
        this.set(lastTrigger, (BValue)v, null);
    }

    public BAbsTime getNextTrigger() {
        return (BAbsTime)this.get(nextTrigger);
    }

    public void setNextTrigger(BAbsTime v) {
        this.set(nextTrigger, (BValue)v, null);
    }

    public void presetNextTrigger(BAbsTime date) {
        this.invoke(presetNextTrigger, (BValue)date, null);
    }

    public void ticketExpired() {
        this.invoke(ticketExpired, null, null);
    }

    public void fireTrigger(BValue event) {
        this.fire(trigger, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void atSteadyState() {
        if (this.isRunning()) {
            this.init();
        }
    }

    public void started() {
        if (Sys.atSteadyState()) {
            this.init();
        }
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(triggerDayOfWeek) || p.equals(triggerTime) || p.equals(triggerWeekInterval)) {
            this.setNextTrigger(BAbsTime.NULL);
            this.init();
        }
    }

    public void clockChanged(BRelTime shift) {
        this.init();
    }

    public void init() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        BAbsTime current = Clock.time();
        int weekday = current.getWeekday().getOrdinal();
        int nextWeekday = this.getTriggerDayOfWeek().getOrdinal();
        if (this.getTriggerWeekInterval() < 1 || nextWeekday < 0) {
            return;
        }
        if (this.getNextTrigger() == BAbsTime.NULL || this.getNextTrigger() == BAbsTime.END_OF_TIME) {
            if (this.getLastTrigger() == BAbsTime.NULL) {
                if (weekday == nextWeekday && this.getTriggerTime().getTimeOfDayMillis() > current.getTimeOfDayMillis()) {
                    this.setNextTrigger(BAbsTime.make((BAbsTime)current, (BTime)this.getTriggerTime()));
                } else {
                    BAbsTime nextDay = current;
                    for (int i = 0; i < 7 && (nextDay = nextDay.nextDay()).getWeekday().getOrdinal() != nextWeekday; ++i) {
                    }
                    this.setNextTrigger(BAbsTime.make((BAbsTime)nextDay, (BTime)this.getTriggerTime()));
                }
            } else {
                BAbsTime last = this.getLastTrigger();
                if (last.getWeekday().getOrdinal() != nextWeekday) {
                    for (int j = 0; j < 7 && (last = last.nextDay()).getWeekday().getOrdinal() != nextWeekday; ++j) {
                    }
                }
                last = this.findNextWeek(last);
                while (last.isBefore(current)) {
                    last = this.findNextWeek(last);
                }
                this.setNextTrigger(BAbsTime.make((BAbsTime)last, (BTime)this.getTriggerTime()));
            }
        } else if (current.isAfter(this.getNextTrigger())) {
            this.ticketExpired();
        } else {
            this.ticket = Clock.schedule((BComponent)this, (BAbsTime)this.getNextTrigger(), (Action)ticketExpired, null);
        }
    }

    private BAbsTime findNextWeek(BAbsTime last) {
        for (int k = 0; k < this.getTriggerWeekInterval(); ++k) {
            last = last.next(this.getTriggerDayOfWeek());
        }
        return last;
    }

    public void doTicketExpired() {
        if (!this.isRunning()) {
            return;
        }
        BAbsTime current = Clock.time();
        BAbsTime next = this.getNextTrigger();
        if (current.isAfter(this.getNextTrigger())) {
            this.fireTrigger(null);
            for (int i = 0; i < this.getTriggerWeekInterval(); ++i) {
                next = next.next(this.getTriggerDayOfWeek());
            }
            this.setLastTrigger(this.getNextTrigger());
            this.setNextTrigger(next);
        }
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BAbsTime)next, (Action)ticketExpired, null);
    }

    public void doPresetNextTrigger(BAbsTime date) {
        this.setNextTrigger(date);
        this.init();
    }

    public BIcon getIcon() {
        return icon;
    }
}

