/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.timer;

import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBooleanDelayWithTimer
extends BComponent {
    public static final Property updateTime = BBooleanDelayWithTimer.newProperty((int)0, (BValue)BRelTime.make((long)500L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)500L)));
    public static final Property timeFacets = BBooleanDelayWithTimer.newProperty((int)256, (BValue)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)false)), null);
    public static final Property timeRemaining = BBooleanDelayWithTimer.newProperty((int)11, (BValue)BRelTime.make((long)0L), null);
    public static final Property outFacets = BBooleanDelayWithTimer.newProperty((int)0, (BValue)BFacets.makeBoolean(), null);
    public static final Property in = BBooleanDelayWithTimer.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    public static final Property onDelay = BBooleanDelayWithTimer.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)500L)));
    public static final Property offDelay = BBooleanDelayWithTimer.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)500L)));
    public static final Property onDelayActive = BBooleanDelayWithTimer.newProperty((int)3, (boolean)false, null);
    public static final Property offDelayActive = BBooleanDelayWithTimer.newProperty((int)3, (boolean)false, null);
    public static final Property out = BBooleanDelayWithTimer.newProperty((int)75, (BValue)new BStatusBoolean(false), null);
    public static final Property outNot = BBooleanDelayWithTimer.newProperty((int)75, (BValue)new BStatusBoolean(true), null);
    public static final Property lastIn = BBooleanDelayWithTimer.newProperty((int)7, (boolean)false, null);
    public static final Action onTimerExpired = BBooleanDelayWithTimer.newAction((int)4, null);
    public static final Action offTimerExpired = BBooleanDelayWithTimer.newAction((int)4, null);
    public static final Action timerExpired = BBooleanDelayWithTimer.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BBooleanDelayWithTimer.class);
    private static final BIcon icon = BIcon.std((String)"control/trigger.png");
    BAbsTime now;
    BAbsTime delayExpiration;
    long timerStartTicks;
    long activeDelayExpirationTicks;
    Clock.Ticket ticket;
    boolean lastInput = false;
    Clock.Ticket onTicket;
    Clock.Ticket offTicket;

    public BRelTime getUpdateTime() {
        return (BRelTime)this.get(updateTime);
    }

    public void setUpdateTime(BRelTime v) {
        this.set(updateTime, (BValue)v, null);
    }

    public BFacets getTimeFacets() {
        return (BFacets)this.get(timeFacets);
    }

    public void setTimeFacets(BFacets v) {
        this.set(timeFacets, (BValue)v, null);
    }

    public BRelTime getTimeRemaining() {
        return (BRelTime)this.get(timeRemaining);
    }

    public void setTimeRemaining(BRelTime v) {
        this.set(timeRemaining, (BValue)v, null);
    }

    public BFacets getOutFacets() {
        return (BFacets)this.get(outFacets);
    }

    public void setOutFacets(BFacets v) {
        this.set(outFacets, (BValue)v, null);
    }

    public BStatusBoolean getIn() {
        return (BStatusBoolean)this.get(in);
    }

    public void setIn(BStatusBoolean v) {
        this.set(in, (BValue)v, null);
    }

    public BRelTime getOnDelay() {
        return (BRelTime)this.get(onDelay);
    }

    public void setOnDelay(BRelTime v) {
        this.set(onDelay, (BValue)v, null);
    }

    public BRelTime getOffDelay() {
        return (BRelTime)this.get(offDelay);
    }

    public void setOffDelay(BRelTime v) {
        this.set(offDelay, (BValue)v, null);
    }

    public boolean getOnDelayActive() {
        return this.getBoolean(onDelayActive);
    }

    public void setOnDelayActive(boolean v) {
        this.setBoolean(onDelayActive, v, null);
    }

    public boolean getOffDelayActive() {
        return this.getBoolean(offDelayActive);
    }

    public void setOffDelayActive(boolean v) {
        this.setBoolean(offDelayActive, v, null);
    }

    public BStatusBoolean getOut() {
        return (BStatusBoolean)this.get(out);
    }

    public void setOut(BStatusBoolean v) {
        this.set(out, (BValue)v, null);
    }

    public BStatusBoolean getOutNot() {
        return (BStatusBoolean)this.get(outNot);
    }

    public void setOutNot(BStatusBoolean v) {
        this.set(outNot, (BValue)v, null);
    }

    public boolean getLastIn() {
        return this.getBoolean(lastIn);
    }

    public void setLastIn(boolean v) {
        this.setBoolean(lastIn, v, null);
    }

    public void onTimerExpired() {
        this.invoke(onTimerExpired, null, null);
    }

    public void offTimerExpired() {
        this.invoke(offTimerExpired, null, null);
    }

    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.getIn().getValue() && !this.getOut().getValue()) {
            this.startOnTimer();
        } else if (!this.getIn().getValue() && this.getOut().getValue()) {
            this.startOffTimer();
        }
        this.setLastIn(this.getIn().getValue());
        this.lastInput = this.getIn().getValue();
    }

    public void atSteadyState() {
        this.calculate();
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.onTicket != null) {
            this.onTicket.cancel();
        }
        if (this.offTicket != null) {
            this.offTicket.cancel();
        }
    }

    protected void initTimer() {
        BRelTime period;
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if ((period = this.getUpdateTime()).getMillis() < 500L) {
            period = BRelTime.make((long)500L);
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)period, (Action)timerExpired, null);
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(updateTime)) {
            if (this.getOnDelayActive() || this.getOffDelayActive()) {
                this.initTimer();
            }
        } else if (p.equals(in)) {
            this.calculate();
        }
    }

    public void calculate() {
        if (!this.getIn().getStatus().isValid()) {
            return;
        }
        boolean input = this.getIn().getValue();
        this.lastInput = this.getLastIn();
        if (input && !this.lastInput) {
            if (this.getOnDelay().getMillis() == 0L) {
                this.onTimerExpired();
            } else if (this.getOut().getValue()) {
                this.onTimerExpired();
            } else {
                this.startOnTimer();
            }
        } else if (!input && this.lastInput) {
            if (this.getOffDelay().getMillis() == 0L) {
                this.offTimerExpired();
            } else if (!this.getOut().getValue()) {
                this.offTimerExpired();
            } else {
                this.startOffTimer();
            }
        } else if (input && this.lastInput) {
            if (!this.getOut().getValue() && !this.getOnDelayActive()) {
                this.startOnTimer();
            }
        } else if (!input && !this.lastInput && this.getOut().getValue() && !this.getOffDelayActive()) {
            this.startOffTimer();
        }
        this.setLastIn(input);
    }

    private void setOutput(boolean value) {
        this.getOut().setValue(value);
        this.getOutNot().setValue(!value);
    }

    public void doOnTimerExpired() {
        this.setOutput(true);
        this.setOnDelayActive(false);
        this.setOffDelayActive(false);
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.onTicket != null) {
            this.onTicket.cancel();
        }
        if (this.offTicket != null) {
            this.offTicket.cancel();
        }
        this.setTimeRemaining(BRelTime.make((long)0L));
    }

    public void doOffTimerExpired() {
        this.setOutput(false);
        this.setOnDelayActive(false);
        this.setOffDelayActive(false);
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.offTicket != null) {
            this.offTicket.cancel();
        }
        if (this.onTicket != null) {
            this.onTicket.cancel();
        }
        this.setTimeRemaining(BRelTime.make((long)0L));
    }

    void startOnTimer() {
        if (this.offTicket != null) {
            this.offTicket.cancel();
        }
        if (this.onTicket != null) {
            this.onTicket.cancel();
        }
        this.onTicket = Clock.schedule((BComponent)this, (BRelTime)this.getOnDelay(), (Action)onTimerExpired, null);
        this.setOnDelayActive(true);
        this.setOffDelayActive(false);
        this.timerStartTicks = Clock.ticks();
        this.activeDelayExpirationTicks = this.timerStartTicks + this.getOnDelay().getMillis();
        this.initTimer();
    }

    void startOffTimer() {
        if (this.onTicket != null) {
            this.onTicket.cancel();
        }
        if (this.offTicket != null) {
            this.offTicket.cancel();
        }
        this.offTicket = Clock.schedule((BComponent)this, (BRelTime)this.getOffDelay(), (Action)offTimerExpired, null);
        this.setOffDelayActive(true);
        this.setOnDelayActive(false);
        this.timerStartTicks = Clock.ticks();
        this.activeDelayExpirationTicks = this.timerStartTicks + this.getOffDelay().getMillis();
        this.initTimer();
    }

    public void doTimerExpired() {
        long remaining = this.activeDelayExpirationTicks - Clock.ticks();
        if (remaining >= 0L) {
            this.setTimeRemaining(BRelTime.make((long)remaining));
        } else if (this.getOnDelayActive()) {
            this.onTimerExpired();
        } else if (this.getOffDelayActive()) {
            this.offTimerExpired();
        } else {
            this.setTimeRemaining(BRelTime.make((long)0L));
        }
    }

    public String toString(Context cx) {
        return this.getOut().toString(cx);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == out) {
            return this.getOutFacets();
        }
        if (slot == timeRemaining) {
            return this.getTimeFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }
}

