/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.hvac.BMinMaxAvgBql;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSatisfiedZoneBql
extends BMinMaxAvgBql {
    public static final Property upperLimit = BSatisfiedZoneBql.newProperty((int)256, (BValue)new BStatusNumeric(80.0), null);
    public static final Property lowerLimit = BSatisfiedZoneBql.newProperty((int)256, (BValue)new BStatusNumeric(60.0), null);
    public static final Property satisfiedZones = BSatisfiedZoneBql.newProperty((int)3, (int)0, null);
    public static final Type TYPE = Sys.loadType(BSatisfiedZoneBql.class);

    public BStatusNumeric getUpperLimit() {
        return (BStatusNumeric)this.get(upperLimit);
    }

    public void setUpperLimit(BStatusNumeric v) {
        this.set(upperLimit, (BValue)v, null);
    }

    public BStatusNumeric getLowerLimit() {
        return (BStatusNumeric)this.get(lowerLimit);
    }

    public void setLowerLimit(BStatusNumeric v) {
        this.set(lowerLimit, (BValue)v, null);
    }

    public int getSatisfiedZones() {
        return this.getInt(satisfiedZones);
    }

    public void setSatisfiedZones(int v) {
        this.setInt(satisfiedZones, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)upperLimit) || slot.equals((Object)lowerLimit)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public void doCalculate() throws Exception {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                return;
            }
        }
        if (this.getPointQuery().isNull()) {
            this.initCalcTicket();
            return;
        }
        if (this.result == null) {
            this.initCalcTicket();
            return;
        }
        int num = 0;
        double avg = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        String minZ = "";
        String maxZ = "";
        int satisfied = 0;
        double upper = this.getUpperLimit().getValue();
        double lower = this.getLowerLimit().getValue();
        this.initCalcTicket();
        for (int i = 0; i < this.myComps.size(); ++i) {
            BStatusNumeric n;
            BComponent comp = (BComponent)this.myComps.get(i);
            if (comp.get("out") == null || !comp.get("out").getType().is(BStatusNumeric.TYPE)) continue;
            if (!comp.isSubscribed()) {
                this.sub.subscribe(comp);
            }
            if (!(n = (BStatusNumeric)comp.get("out")).getStatus().isValid() || BDouble.make((double)n.getValue()) == BDouble.NaN) continue;
            double nValue = n.getValue();
            if (nValue < min) {
                min = nValue;
                minZ = this.getZoneIdentifierFormat().format((Object)comp);
            }
            if (nValue > max) {
                max = nValue;
                maxZ = this.getZoneIdentifierFormat().format((Object)comp);
            }
            avg += nValue;
            ++num;
            if (!(nValue > lower) || !(nValue < upper)) continue;
            ++satisfied;
        }
        this.getMinZoneIdentifier().setValue(minZ);
        this.getMaxZoneIdentifier().setValue(maxZ);
        if (min == Double.POSITIVE_INFINITY) {
            min = Double.NaN;
        }
        if (max == Double.NEGATIVE_INFINITY) {
            min = Double.NaN;
        }
        if (num != 0) {
            this.getSum().setValue(avg);
            this.getAvg().setValue(avg / (double)num);
            if (this.getAvg().getStatus().isNull()) {
                this.getAvg().setStatus(BStatus.ok);
            }
            if (this.getSum().getStatus().isNull()) {
                this.getSum().setStatus(BStatus.ok);
            }
        } else {
            this.getSum().setStatus(64);
            this.getAvg().setStatus(64);
        }
        this.setCount(num);
        this.getMin().setValue(min);
        this.getMax().setValue(max);
        this.setSatisfiedZones(satisfied);
    }
}

