/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.enums.BMasterModeEnum;
import com.vykon.vykonPro.hvac.BRollingAvg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="noValidInput", type="boolean", defaultValue="false", flags=267), @NiagaraProperty(name="deviationFacets", type="BFacets", defaultValue="BFacets.makeNumeric(BUnit.DEFAULT, 1)"), @NiagaraProperty(name="maximumDeviation", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=267), @NiagaraProperty(name="maximumDeviationInput", type="String", defaultValue="", flags=267), @NiagaraProperty(name="configStatus", type="BStatus", defaultValue="BStatus.DEFAULT", flags=1), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=1), @NiagaraProperty(name="selectFault", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="inputFault", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="mode", type="BDynamicEnum", defaultValue="BDynamicEnum.make(0)", flags=256), @NiagaraProperty(name="propagateFlags", type="BStatus", defaultValue="BStatus.ok"), @NiagaraProperty(name="numberOfInputs", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="BInteger.make(0)"), @Facet(name="BFacets.MAX", value="BInteger.make(50)")}), @NiagaraProperty(name="inputSlotName", type="String", defaultValue="input"), @NiagaraProperty(name="singleInputSelect", type="BDynamicEnum", defaultValue="BDynamicEnum.make(1)", flags=257), @NiagaraProperty(name="multipleInputSelect", type="BEnumRange", defaultValue="BEnumRange.DEFAULT", flags=257, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"alarm:EnumAlarmRangeFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"alarm:EnumAlarmRangeEditor\"")}), @NiagaraProperty(name="ignoreInFault", type="boolean", defaultValue="true"), @NiagaraProperty(name="ignoreInAlarm", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="setSingleInput", parameterType="BDynamicEnum", defaultValue="BDynamicEnum.make(1)", flags=256), @NiagaraAction(name="setMultipleInput", parameterType="BEnumRange", defaultValue="BEnumRange.DEFAULT", flags=256, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"alarm:EnumAlarmRangeFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"alarm:EnumAlarmRangeEditor\"")})})
public class BRollingAvgMaster
extends BNumericPoint {
    public static final Property noValidInput = BRollingAvgMaster.newProperty((int)267, (boolean)false, null);
    public static final Property deviationFacets = BRollingAvgMaster.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)1), null);
    public static final Property maximumDeviation = BRollingAvgMaster.newProperty((int)267, (BValue)new BStatusNumeric(), null);
    public static final Property maximumDeviationInput = BRollingAvgMaster.newProperty((int)267, (String)"", null);
    public static final Property configStatus = BRollingAvgMaster.newProperty((int)1, (BValue)BStatus.DEFAULT, null);
    public static final Property faultCause = BRollingAvgMaster.newProperty((int)1, (String)"", null);
    public static final Property selectFault = BRollingAvgMaster.newProperty((int)5, (boolean)false, null);
    public static final Property inputFault = BRollingAvgMaster.newProperty((int)5, (boolean)false, null);
    public static final Property mode = BRollingAvgMaster.newProperty((int)256, (BValue)BDynamicEnum.make((int)0), null);
    public static final Property propagateFlags = BRollingAvgMaster.newProperty((int)0, (BValue)BStatus.ok, null);
    public static final Property numberOfInputs = BRollingAvgMaster.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)50))));
    public static final Property inputSlotName = BRollingAvgMaster.newProperty((int)0, (String)"input", null);
    public static final Property singleInputSelect = BRollingAvgMaster.newProperty((int)257, (BValue)BDynamicEnum.make((int)1), null);
    public static final Property multipleInputSelect = BRollingAvgMaster.newProperty((int)257, (BValue)BEnumRange.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"alarm:EnumAlarmRangeFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"alarm:EnumAlarmRangeEditor")));
    public static final Property ignoreInFault = BRollingAvgMaster.newProperty((int)0, (boolean)true, null);
    public static final Property ignoreInAlarm = BRollingAvgMaster.newProperty((int)0, (boolean)false, null);
    public static final Action setSingleInput = BRollingAvgMaster.newAction((int)256, (BValue)BDynamicEnum.make((int)1), null);
    public static final Action setMultipleInput = BRollingAvgMaster.newAction((int)256, (BValue)BEnumRange.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"alarm:EnumAlarmRangeFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"alarm:EnumAlarmRangeEditor")));
    public static final Type TYPE = Sys.loadType(BRollingAvgMaster.class);
    private String lastInputName;
    private BStatusNumeric averageOutput = new BStatusNumeric();
    private MySubscriber inputSub;
    private BRollingAvg[] comps;
    private BDynamicEnum[] inUse;
    private int fallback = -1;
    private static final BFacets PROPAGATE_FACETS = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"kitControl:PropagateFlagsFE"));
    private static final BFacets ACTION_FACETS = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:EnumAlarmRangeFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:EnumAlarmRangeEditor"));

    public boolean getNoValidInput() {
        return this.getBoolean(noValidInput);
    }

    public void setNoValidInput(boolean v) {
        this.setBoolean(noValidInput, v, null);
    }

    public BFacets getDeviationFacets() {
        return (BFacets)this.get(deviationFacets);
    }

    public void setDeviationFacets(BFacets v) {
        this.set(deviationFacets, (BValue)v, null);
    }

    public BStatusNumeric getMaximumDeviation() {
        return (BStatusNumeric)this.get(maximumDeviation);
    }

    public void setMaximumDeviation(BStatusNumeric v) {
        this.set(maximumDeviation, (BValue)v, null);
    }

    public String getMaximumDeviationInput() {
        return this.getString(maximumDeviationInput);
    }

    public void setMaximumDeviationInput(String v) {
        this.setString(maximumDeviationInput, v, null);
    }

    public BStatus getConfigStatus() {
        return (BStatus)this.get(configStatus);
    }

    public void setConfigStatus(BStatus v) {
        this.set(configStatus, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getSelectFault() {
        return this.getBoolean(selectFault);
    }

    public void setSelectFault(boolean v) {
        this.setBoolean(selectFault, v, null);
    }

    public boolean getInputFault() {
        return this.getBoolean(inputFault);
    }

    public void setInputFault(boolean v) {
        this.setBoolean(inputFault, v, null);
    }

    public BDynamicEnum getMode() {
        return (BDynamicEnum)this.get(mode);
    }

    public void setMode(BDynamicEnum v) {
        this.set(mode, (BValue)v, null);
    }

    public BStatus getPropagateFlags() {
        return (BStatus)this.get(propagateFlags);
    }

    public void setPropagateFlags(BStatus v) {
        this.set(propagateFlags, (BValue)v, null);
    }

    public int getNumberOfInputs() {
        return this.getInt(numberOfInputs);
    }

    public void setNumberOfInputs(int v) {
        this.setInt(numberOfInputs, v, null);
    }

    public String getInputSlotName() {
        return this.getString(inputSlotName);
    }

    public void setInputSlotName(String v) {
        this.setString(inputSlotName, v, null);
    }

    public BDynamicEnum getSingleInputSelect() {
        return (BDynamicEnum)this.get(singleInputSelect);
    }

    public void setSingleInputSelect(BDynamicEnum v) {
        this.set(singleInputSelect, (BValue)v, null);
    }

    public BEnumRange getMultipleInputSelect() {
        return (BEnumRange)this.get(multipleInputSelect);
    }

    public void setMultipleInputSelect(BEnumRange v) {
        this.set(multipleInputSelect, (BValue)v, null);
    }

    public boolean getIgnoreInFault() {
        return this.getBoolean(ignoreInFault);
    }

    public void setIgnoreInFault(boolean v) {
        this.setBoolean(ignoreInFault, v, null);
    }

    public boolean getIgnoreInAlarm() {
        return this.getBoolean(ignoreInAlarm);
    }

    public void setIgnoreInAlarm(boolean v) {
        this.setBoolean(ignoreInAlarm, v, null);
    }

    public void setSingleInput(BDynamicEnum parameter) {
        this.invoke(setSingleInput, (BValue)parameter, null);
    }

    public void setMultipleInput(BEnumRange parameter) {
        this.invoke(setMultipleInput, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.lastInputName = this.getInputSlotName();
        this.inputSub = new MySubscriber();
        this.initArray();
    }

    public void stopped() {
        if (this.inputSub != null) {
            this.inputSub.unsubscribeAll();
            this.inputSub = null;
        }
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(numberOfInputs)) {
            this.initSlots();
        } else if (prop.equals(inputSlotName)) {
            this.updateSlots();
        } else if (prop.equals(mode) || prop.equals(singleInputSelect)) {
            this.initArray();
            this.calculate();
        } else if (prop.equals(multipleInputSelect)) {
            this.checkConfig();
            this.initArray();
            this.calculate();
        } else if (prop.getName().startsWith(SlotPath.escape((String)this.getInputSlotName()))) {
            this.checkInput(prop.getName());
            this.initArray();
        }
    }

    private void initArray() {
        this.comps = new BRollingAvg[this.getNumberOfInputs()];
        this.inUse = new BDynamicEnum[this.getNumberOfInputs()];
        if (this.inputSub != null) {
            this.inputSub.unsubscribeAll();
        }
        int[] selectedOrdinals = this.getMultipleInputSelect().getOrdinals();
        int singleSelected = this.getSingleInputSelect().getOrdinal();
        int mode = this.getMode().getOrdinal();
        for (int i = 1; i <= this.getNumberOfInputs(); ++i) {
            boolean selected = false;
            String slotName = SlotPath.escape((String)this.getInputSlotName()) + i;
            BOrd objOrd = (BOrd)this.get(slotName);
            if (objOrd == BOrd.DEFAULT) continue;
            BObject object = objOrd.resolve().get();
            if (object instanceof BRollingAvg) {
                BRollingAvg comp;
                this.comps[i - 1] = comp = (BRollingAvg)object;
                this.inputSub.subscribe((BComponent)this.comps[i - 1]);
                if (mode == 0) {
                    if (i == singleSelected) {
                        selected = true;
                    }
                } else if (mode == 1) {
                    for (int j = 0; j < selectedOrdinals.length; ++j) {
                        if (selectedOrdinals[j] != i) continue;
                        selected = true;
                        break;
                    }
                } else {
                    selected = true;
                }
                comp.setMasterSelected(selected);
                continue;
            }
            this.comps[i - 1] = null;
        }
    }

    private BEnumRange makeRange() {
        int numSlots = this.getNumberOfInputs();
        if (numSlots > 0) {
            String[] tags = new String[numSlots];
            int[] ordinals = new int[numSlots];
            for (int i = 0; i < numSlots; ++i) {
                Slot s = this.getSlot(SlotPath.escape((String)(this.getInputSlotName() + (i + 1))));
                tags[i] = SlotPath.escape((String)this.getDisplayName(s, null));
                ordinals[i] = i + 1;
            }
            return BEnumRange.make((int[])ordinals, (String[])tags);
        }
        return BEnumRange.DEFAULT;
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        BStatus fault = BStatus.makeFault((BStatus)BStatus.DEFAULT, (this.getInputFault() || this.getSelectFault() ? 1 : 0) != 0);
        this.setConfigStatus(fault);
        out.setStatus(this.averageOutput.getStatus());
        ((BStatusNumeric)out).setValue(this.averageOutput.getValue());
    }

    public void calculate() {
        int i;
        int mode = this.getMode().getOrdinal();
        boolean success = false;
        for (int i2 = 0; i2 < this.getNumberOfInputs(); ++i2) {
            this.inUse[i2] = BDynamicEnum.make((int)0);
        }
        if (mode == 0) {
            this.getMaximumDeviation().setValue(Double.NaN);
            this.setMaximumDeviationInput("");
            int selected = this.getSingleInputSelect().getOrdinal() - 1;
            if (this.comps[selected] != null && this.checkInputValid(selected)) {
                this.averageOutput.setValue(this.comps[selected].getOut().getValue());
                this.averageOutput.setStatus(this.propagate(this.comps[selected].getStatus()));
                this.fallback = -1;
                success = true;
                this.inUse[selected] = BDynamicEnum.make((int)1);
            } else if (this.fallback != -1 && this.comps[this.fallback] != null && this.checkInputValid(this.fallback)) {
                this.averageOutput.setValue(this.comps[this.fallback].getOut().getValue());
                this.averageOutput.setStatus(this.propagate(this.comps[this.fallback].getStatus()));
                success = true;
                this.inUse[this.fallback] = BDynamicEnum.make((int)1);
            } else {
                double min = Double.POSITIVE_INFINITY;
                boolean fallbackChanged = false;
                for (i = 0; i < this.getNumberOfInputs(); ++i) {
                    if (i == selected || i == this.fallback) continue;
                    if (this.comps[i] != null && this.checkInputValid(i) && this.comps[i].getOut().getValue() < min) {
                        min = this.comps[i].getOut().getValue();
                        this.fallback = i;
                        fallbackChanged = true;
                    }
                    if (!fallbackChanged) continue;
                    this.averageOutput.setValue(this.comps[this.fallback].getOut().getValue());
                    this.averageOutput.setStatus(this.propagate(this.comps[this.fallback].getStatus()));
                    success = true;
                    this.inUse[this.fallback] = BDynamicEnum.make((int)1);
                }
            }
        } else if (mode == 1) {
            int lookup;
            int i3;
            int[] selectedInputs = this.getMultipleInputSelect().getOrdinals();
            double total = 0.0;
            double validCount = 0.0;
            double average = 0.0;
            BStatus mergedStatus = BStatus.ok;
            double maxDeviation = Double.NEGATIVE_INFINITY;
            int maxLookup = -1;
            for (i3 = 0; i3 < selectedInputs.length; ++i3) {
                lookup = selectedInputs[i3] - 1;
                if (this.comps[lookup] == null || !this.checkInputValid(lookup)) continue;
                total += this.comps[lookup].getOut().getValue();
                validCount += 1.0;
                this.inUse[lookup] = BDynamicEnum.make((int)1);
            }
            if (validCount > 0.0) {
                if (validCount > 2.0) {
                    average = total / validCount;
                    for (i3 = 0; i3 < selectedInputs.length; ++i3) {
                        double value;
                        lookup = selectedInputs[i3] - 1;
                        if (this.comps[lookup] == null || !this.checkInputValid(lookup) || !(Math.abs((value = this.comps[lookup].getOut().getValue()) - average) > maxDeviation)) continue;
                        maxDeviation = Math.abs(value - average);
                        maxLookup = lookup;
                    }
                }
                for (i3 = 0; i3 < selectedInputs.length; ++i3) {
                    lookup = selectedInputs[i3] - 1;
                    if (this.comps[lookup] == null || !this.checkInputValid(lookup)) continue;
                    if (lookup == maxLookup) {
                        total -= this.comps[lookup].getOut().getValue();
                        validCount -= 1.0;
                        this.inUse[lookup] = BDynamicEnum.make((int)3);
                        continue;
                    }
                    mergedStatus = BStatus.make((int)(mergedStatus.getBits() | this.comps[lookup].getStatus().getBits()));
                }
                this.averageOutput.setValue(total / validCount);
                this.averageOutput.setStatus(this.propagate(mergedStatus));
                success = true;
                if (maxLookup != -1) {
                    this.getMaximumDeviation().setValue(Math.abs(total / validCount - this.comps[maxLookup].getOut().getValue()));
                    this.setMaximumDeviationInput(this.comps[maxLookup].getDisplayName(null));
                } else {
                    this.getMaximumDeviation().setValue(Double.NaN);
                    this.setMaximumDeviationInput("");
                }
            } else {
                this.getMaximumDeviation().setValue(Double.NaN);
                this.setMaximumDeviationInput("");
            }
        } else {
            double total = 0.0;
            int validCount = 0;
            BStatus mergedStatus = BStatus.ok;
            this.getMaximumDeviation().setValue(Double.NaN);
            this.setMaximumDeviationInput("");
            for (i = 0; i < this.getNumberOfInputs(); ++i) {
                if (this.comps[i] == null || !this.checkInputValid(i)) continue;
                total += this.comps[i].getOut().getValue();
                ++validCount;
                this.inUse[i] = BDynamicEnum.make((int)1);
                mergedStatus = BStatus.make((int)(mergedStatus.getBits() | this.comps[i].getStatus().getBits()));
            }
            if (validCount > 0) {
                this.averageOutput.setValue(total / (double)validCount);
                this.averageOutput.setStatus(this.propagate(mergedStatus));
                success = true;
            }
        }
        this.setNoValidInput(!success);
        for (int i4 = 0; i4 < this.getNumberOfInputs(); ++i4) {
            this.comps[i4].setMasterInUse(this.inUse[i4]);
        }
        this.doExecute();
    }

    public void doSetSingleInput(BDynamicEnum value) {
        this.setSingleInputSelect(value);
    }

    public void doSetMultipleInput(BEnumRange value) {
        this.setMultipleInputSelect(value);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == setSingleInput) {
            return BDynamicEnum.make((int)this.getSingleInputSelect().getOrdinal(), (BEnumRange)this.makeActionRange());
        }
        if (action == setMultipleInput) {
            return this.getMultipleInputSelect();
        }
        return super.getActionParameterDefault(action);
    }

    private BEnumRange makeActionRange() {
        int numSlots = this.getNumberOfInputs();
        ArrayList<Integer> ordinals = new ArrayList<Integer>();
        ArrayList<String> tags = new ArrayList<String>();
        if (numSlots > 0) {
            for (int i2 = 0; i2 < numSlots; ++i2) {
                BRollingAvg input;
                BObject obj;
                BOrd ord = (BOrd)this.get(SlotPath.escape((String)(this.getInputSlotName() + (i2 + 1))));
                if (ord == BOrd.DEFAULT || (obj = ord.resolve((BObject)this).get()) == null || !(obj instanceof BRollingAvg) || !(input = (BRollingAvg)obj).getInService().getValue() || Double.isNaN(input.getOut().getValue()) || this.getIgnoreInAlarm() && input.getStatus().isAlarm() || this.getIgnoreInFault() && input.getStatus().isFault()) continue;
                Slot s = this.getSlot(SlotPath.escape((String)(this.getInputSlotName() + (i2 + 1))));
                tags.add(SlotPath.escape((String)this.getDisplayName(s, null)));
                ordinals.add(i2 + 1);
            }
            String[] tag = new String[tags.size()];
            tag = tags.toArray(tag);
            int[] ordinal = ordinals.stream().mapToInt(i -> i).toArray();
            BEnumRange range = BEnumRange.make((int[])ordinal, (String[])tags.toArray(tag));
            BFacets actionFacets = BFacets.make((BFacets)ACTION_FACETS, (BFacets)BFacets.makeEnum((BEnumRange)range));
            this.setFacets(this.getSlot("setMultipleInput"), actionFacets);
            return range;
        }
        return BEnumRange.DEFAULT;
    }

    public BStatus propagate(BStatus s) {
        return BStatus.make((int)(s.getBits() & this.getPropagateFlags().getBits()));
    }

    private boolean checkInputValid(int ordinal) {
        boolean valid;
        BRollingAvg input = this.comps[ordinal];
        boolean bl = valid = !(!input.getInService().getValue() || Double.isNaN(input.getOut().getValue()) || this.getIgnoreInAlarm() && input.getStatus().isAlarm() || this.getIgnoreInFault() && input.getStatus().isFault());
        if (!valid) {
            this.inUse[ordinal] = BDynamicEnum.make((int)2);
        }
        return valid;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)singleInputSelect)) {
            return BFacets.makeEnum((BEnumRange)this.makeRange());
        }
        if (slot.equals((Object)multipleInputSelect)) {
            return BFacets.make((BFacets)BFacets.makeEnum((BEnumRange)this.makeRange()), (BFacets)super.getSlotFacets(slot));
        }
        if (slot.equals((Object)mode)) {
            return BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BMasterModeEnum.TYPE));
        }
        if (slot.equals((Object)propagateFlags)) {
            return PROPAGATE_FACETS;
        }
        if (slot.equals((Object)maximumDeviation)) {
            return this.getDeviationFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void initSlots() {
        int numSlots;
        int numOrds = this.getNumberOfInputs();
        if (numOrds > (numSlots = ((BOrd[])this.getChildren(BOrd.class)).length)) {
            for (int i = 1; i <= numOrds; ++i) {
                if (i <= numSlots) continue;
                String slotName = SlotPath.escape((String)this.getInputSlotName()) + i;
                this.add(slotName, (BValue)BRollingAvgMaster.makeDefaultOrd());
            }
        } else if (numOrds < numSlots) {
            HashMap<String, BFormat> map = new HashMap<String, BFormat>();
            for (int i = 1; i <= numSlots; ++i) {
                if (i <= numOrds) continue;
                String slotName = SlotPath.escape((String)this.getInputSlotName()) + i;
                this.remove(slotName);
                map.put(slotName, BFormat.make((String)slotName));
            }
            this.updateDisplayNames(map, false);
        }
        this.initArray();
    }

    public void updateSlots() {
        BNameMap currentMap = BNameMap.DEFAULT;
        boolean existingMap = false;
        String[] keys = new String[]{};
        if (this.get("displayNames") != null) {
            existingMap = true;
            currentMap = (BNameMap)this.get("displayNames");
            keys = currentMap.list();
        }
        for (int i = 1; i <= this.getNumberOfInputs(); ++i) {
            String slotName = SlotPath.escape((String)this.getInputSlotName()) + i;
            String oldSlotName = this.lastInputName + i;
            this.rename(this.getProperty(oldSlotName), slotName);
            if (!existingMap) continue;
            for (int j = 0; j < keys.length; ++j) {
                if (!keys[j].equals(oldSlotName)) continue;
                BFormat format = currentMap.get(oldSlotName);
                currentMap = BNameMap.remove((BNameMap)currentMap, (String)oldSlotName);
                currentMap = BNameMap.make((BNameMap)currentMap, (String)slotName, (BFormat)format);
            }
        }
        if (existingMap) {
            this.set("displayNames", (BValue)currentMap);
        }
        this.lastInputName = SlotPath.escape((String)this.getInputSlotName());
    }

    private void updateDisplayNames(HashMap map, boolean add) {
        if (this.get("displayNames") != null) {
            BNameMap current = (BNameMap)this.get("displayNames");
            if (!add) {
                Iterator cursor = map.keySet().iterator();
                while (cursor.hasNext()) {
                    current = BNameMap.remove((BNameMap)current, (String)cursor.next().toString());
                }
                this.set("displayNames", (BValue)current);
            }
        }
    }

    private static BOrd makeDefaultOrd() {
        BOrd o = BOrd.NULL;
        return o;
    }

    private void checkConfig() {
        boolean validSelected = false;
        int[] selectedOrdinals = this.getMultipleInputSelect().getOrdinals();
        if (selectedOrdinals.length == 0) {
            this.setFaultCause("Multiple Input Selection must have at least one input selected.");
            this.setSelectFault(true);
            this.doExecute();
            return;
        }
        for (int i = 0; i < selectedOrdinals.length; ++i) {
            BOrd checkOrd = (BOrd)this.get(SlotPath.escape((String)this.getInputSlotName()) + selectedOrdinals[i]);
            if (checkOrd.equals((Object)BOrd.DEFAULT)) {
                this.setFaultCause(SlotPath.escape((String)this.getInputSlotName()) + selectedOrdinals[i] + " ord is not configured");
                this.setSelectFault(true);
                this.doExecute();
                return;
            }
            BObject comp = checkOrd.resolve().get();
            if (comp != null && comp instanceof BRollingAvg) continue;
            this.setFaultCause(SlotPath.escape((String)this.getInputSlotName()) + selectedOrdinals[i] + " ord does not resolve to a RollingAvg component.");
            this.setSelectFault(true);
            this.doExecute();
            return;
        }
        this.setFaultCause("");
        this.setSelectFault(false);
        this.doExecute();
    }

    private void checkInput(String input) {
        BOrd checkOrd = (BOrd)this.get(input);
        if (checkOrd == BOrd.DEFAULT) {
            this.setFaultCause(input + " ord is not configured");
            this.setInputFault(true);
            this.doExecute();
            return;
        }
        BObject comp = checkOrd.resolve().get();
        if (comp == null || !(comp instanceof BRollingAvg)) {
            this.setFaultCause(input + " ord does not resolve to a RolllingAvg component");
            this.setInputFault(true);
            this.doExecute();
            return;
        }
        for (int i = 1; i <= this.getNumberOfInputs(); ++i) {
            BOrd inputOrd;
            String slotName = SlotPath.escape((String)this.getInputSlotName()) + i;
            if (slotName.equals(input) || !(inputOrd = (BOrd)this.get(slotName)).equals((Object)checkOrd)) continue;
            this.setFaultCause(input + " ord is configured the same as " + slotName);
            this.setInputFault(true);
            this.doExecute();
            return;
        }
        this.setFaultCause("");
        this.setInputFault(false);
        this.doExecute();
    }

    public class MySubscriber
    extends Subscriber {
        public void event(BComponentEvent event) {
            if (event.getId() == 0 && event.getSlotName().equals("out")) {
                BRollingAvgMaster.this.calculate();
            }
        }
    }
}

