/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.util.BVykonProService;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BMinMaxAvgBql
extends BComponent {
    public static final Property status = BMinMaxAvgBql.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BMinMaxAvgBql.newProperty((int)3, (String)"", null);
    public static final Property enabled = BMinMaxAvgBql.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property pointQuery = BMinMaxAvgBql.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property numberOfPoints = BMinMaxAvgBql.newProperty((int)11, (int)0, null);
    public static final Property facets = BMinMaxAvgBql.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property count = BMinMaxAvgBql.newProperty((int)11, (int)0, null);
    public static final Property avg = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property sum = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property min = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property minZoneIdentifier = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusString(), null);
    public static final Property max = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property maxZoneIdentifier = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusString(), null);
    public static final Property zoneIdentifierFormat = BMinMaxAvgBql.newProperty((int)0, (BValue)BFormat.make((String)"%name%"), null);
    public static final Property updateValuesInterval = BMinMaxAvgBql.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property refreshQueryInterval = BMinMaxAvgBql.newProperty((int)0, (BValue)BRelTime.makeHours((int)12), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1)));
    public static final Property startDelay = BMinMaxAvgBql.newProperty((int)256, (BValue)BRelTime.makeMinutes((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property nextRefreshTime = BMinMaxAvgBql.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    public static final Action calculate = BMinMaxAvgBql.newAction((int)4, null);
    public static final Action initializeList = BMinMaxAvgBql.newAction((int)0, null);
    public static final Action refreshQuery = BMinMaxAvgBql.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BMinMaxAvgBql.class);
    private static final BIcon icon = BIcon.std((String)"control/numericPoint.png");
    Clock.Ticket ticket;
    Clock.Ticket calcTicket;
    Clock.Ticket startTicket;
    BITable result = null;
    boolean refreshChanged = false;
    MySub sub = null;
    ArrayList myComps = null;
    private static BRelTime DEF_TIME = BRelTime.makeSeconds((int)15);

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BOrd getPointQuery() {
        return (BOrd)this.get(pointQuery);
    }

    public void setPointQuery(BOrd v) {
        this.set(pointQuery, (BValue)v, null);
    }

    public int getNumberOfPoints() {
        return this.getInt(numberOfPoints);
    }

    public void setNumberOfPoints(int v) {
        this.setInt(numberOfPoints, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public int getCount() {
        return this.getInt(count);
    }

    public void setCount(int v) {
        this.setInt(count, v, null);
    }

    public BStatusNumeric getAvg() {
        return (BStatusNumeric)this.get(avg);
    }

    public void setAvg(BStatusNumeric v) {
        this.set(avg, (BValue)v, null);
    }

    public BStatusNumeric getSum() {
        return (BStatusNumeric)this.get(sum);
    }

    public void setSum(BStatusNumeric v) {
        this.set(sum, (BValue)v, null);
    }

    public BStatusNumeric getMin() {
        return (BStatusNumeric)this.get(min);
    }

    public void setMin(BStatusNumeric v) {
        this.set(min, (BValue)v, null);
    }

    public BStatusString getMinZoneIdentifier() {
        return (BStatusString)this.get(minZoneIdentifier);
    }

    public void setMinZoneIdentifier(BStatusString v) {
        this.set(minZoneIdentifier, (BValue)v, null);
    }

    public BStatusNumeric getMax() {
        return (BStatusNumeric)this.get(max);
    }

    public void setMax(BStatusNumeric v) {
        this.set(max, (BValue)v, null);
    }

    public BStatusString getMaxZoneIdentifier() {
        return (BStatusString)this.get(maxZoneIdentifier);
    }

    public void setMaxZoneIdentifier(BStatusString v) {
        this.set(maxZoneIdentifier, (BValue)v, null);
    }

    public BFormat getZoneIdentifierFormat() {
        return (BFormat)this.get(zoneIdentifierFormat);
    }

    public void setZoneIdentifierFormat(BFormat v) {
        this.set(zoneIdentifierFormat, (BValue)v, null);
    }

    public BRelTime getUpdateValuesInterval() {
        return (BRelTime)this.get(updateValuesInterval);
    }

    public void setUpdateValuesInterval(BRelTime v) {
        this.set(updateValuesInterval, (BValue)v, null);
    }

    public BRelTime getRefreshQueryInterval() {
        return (BRelTime)this.get(refreshQueryInterval);
    }

    public void setRefreshQueryInterval(BRelTime v) {
        this.set(refreshQueryInterval, (BValue)v, null);
    }

    public BRelTime getStartDelay() {
        return (BRelTime)this.get(startDelay);
    }

    public void setStartDelay(BRelTime v) {
        this.set(startDelay, (BValue)v, null);
    }

    public BAbsTime getNextRefreshTime() {
        return (BAbsTime)this.get(nextRefreshTime);
    }

    public void setNextRefreshTime(BAbsTime v) {
        this.set(nextRefreshTime, (BValue)v, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void initializeList() {
        this.invoke(initializeList, null, null);
    }

    public void refreshQuery() {
        this.invoke(refreshQuery, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.checkForService();
        if (this.getEnabled()) {
            this.initStartTicket();
            this.initCalcTicket();
            this.initClockTicket();
        }
        this.sub = new MySub();
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.calcTicket != null) {
            this.calcTicket.cancel();
        }
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
        if (this.sub != null) {
            this.sub.unsubscribeAll();
            this.sub = null;
        }
    }

    protected final void checkForService() {
        if (BVykonProService.getInstance() == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("This component requires the VykonPro service in the station");
        } else if (BVykonProService.getInstance().isDisabled()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("The vykonPro service is disabled");
        } else {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)avg) || slot.equals((Object)min) || slot.equals((Object)max) || slot.equals((Object)sum)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void clockChanged(BRelTime value) {
        if (this.getEnabled()) {
            this.initClockTicket();
            this.initCalcTicket();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (this.getEnabled()) {
            if (property.equals(refreshQueryInterval)) {
                this.refreshChanged = true;
                this.initClockTicket();
            } else if (property.equals(updateValuesInterval)) {
                this.initCalcTicket();
            }
        }
        if (property.equals(zoneIdentifierFormat)) {
            this.calculate();
        } else if (property.equals(pointQuery)) {
            this.initializeList();
        } else if (property.equals(enabled)) {
            if (this.getEnabled()) {
                this.doInitializeList();
                this.initCalcTicket();
                this.initClockTicket();
            } else {
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                if (this.calcTicket != null) {
                    this.calcTicket.cancel();
                }
            }
        }
    }

    private void initStartTicket() {
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
        this.startTicket = Clock.schedule((BComponent)this, (BRelTime)this.getStartDelay(), (Action)initializeList, null);
    }

    void initClockTicket() {
        BAbsTime next = this.getNextRefreshTime();
        if (this.refreshChanged) {
            this.refreshChanged = false;
            next = BAbsTime.NULL;
        }
        BAbsTime current = Clock.time();
        BRelTime refreshPeriod = this.getRefreshQueryInterval();
        if (refreshPeriod.getMillis() < 60000L) {
            refreshPeriod = BRelTime.MINUTE;
        }
        if (next == BAbsTime.NULL) {
            this.setNextRefreshTime(current.add(refreshPeriod));
            next = this.getNextRefreshTime();
        } else if (current.isAfter(next)) {
            while (next.isBefore(current)) {
                next = next.add(refreshPeriod);
            }
            this.setNextRefreshTime(next);
        } else if (current.add(refreshPeriod).isBefore(this.getNextRefreshTime())) {
            this.setNextRefreshTime(current.add(refreshPeriod));
        }
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)next, (BRelTime)refreshPeriod, (Action)refreshQuery, null);
    }

    void initCalcTicket() {
        if (this.calcTicket != null) {
            this.calcTicket.cancel();
        }
        BRelTime interval = this.getUpdateValuesInterval().getMillis() >= 1000L ? this.getUpdateValuesInterval() : DEF_TIME;
        this.calcTicket = Clock.schedule((BComponent)this, (BRelTime)interval, (Action)calculate, null);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == refreshQuery) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    public void doInitializeList() {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                return;
            }
        }
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
        if (this.getPointQuery().isNull()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("must specify a point query");
            return;
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.refreshQuery();
    }

    public void doCalculate() throws Exception {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                return;
            }
        }
        if (this.getPointQuery().isNull()) {
            this.initCalcTicket();
            return;
        }
        if (this.result == null) {
            this.initCalcTicket();
            BAbsTime current = Clock.time();
            if (this.ticket == null || this.getNextRefreshTime().isBefore(current)) {
                this.refreshQuery();
                this.initClockTicket();
            }
            return;
        }
        int num = 0;
        double avg = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        String minZ = "";
        String maxZ = "";
        this.initCalcTicket();
        for (int i = 0; i < this.myComps.size(); ++i) {
            BStatusNumeric n;
            BComponent comp = (BComponent)this.myComps.get(i);
            if (comp.get("out") == null || !comp.get("out").getType().is(BStatusNumeric.TYPE)) continue;
            if (!comp.isSubscribed()) {
                this.sub.subscribe(comp);
            }
            if (!(n = (BStatusNumeric)comp.get("out")).getStatus().isValid() || BDouble.make((double)n.getValue()) == BDouble.NaN) continue;
            double nValue = n.getValue();
            if (nValue < min) {
                min = nValue;
                minZ = this.getZoneIdentifierFormat().format((Object)comp);
            }
            if (nValue > max) {
                max = nValue;
                maxZ = this.getZoneIdentifierFormat().format((Object)comp);
            }
            avg += nValue;
            ++num;
        }
        this.getMinZoneIdentifier().setValue(minZ);
        this.getMaxZoneIdentifier().setValue(maxZ);
        if (min == Double.POSITIVE_INFINITY) {
            min = Double.NaN;
        }
        if (max == Double.NEGATIVE_INFINITY) {
            min = Double.NaN;
        }
        if (num != 0) {
            this.getSum().setValue(avg);
            this.getAvg().setValue(avg / (double)num);
            if (this.getAvg().getStatus().isNull()) {
                this.getAvg().setStatus(BStatus.ok);
            }
            if (this.getSum().getStatus().isNull()) {
                this.getSum().setStatus(BStatus.ok);
            }
        } else {
            this.getSum().setStatus(64);
            this.getAvg().setStatus(64);
        }
        this.setCount(num);
        this.getMin().setValue(min);
        this.getMax().setValue(max);
    }

    public void doRefreshQuery() {
        this.result = (BITable)this.getPointQuery().resolve((BObject)this).get();
        this.myComps = new ArrayList();
        this.setNextRefreshTime(this.getNextRefreshTime().add(this.getRefreshQueryInterval()));
        int count = 0;
        try (TableCursor c = this.result.cursor();){
            while (c.next()) {
                ++count;
                this.myComps.add((BComponent)c.get());
            }
        }
        catch (Exception e) {
            System.out.println(this.getSlotPath() + " - error trying to refresh the query");
            System.out.println(e);
        }
        this.setNumberOfPoints(count);
    }

    public BIcon getIcon() {
        return icon;
    }

    protected class MySub
    extends Subscriber {
        protected MySub() {
        }

        public void event(BComponentEvent event) {
        }
    }
}

