/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.enums.BSequencerOutputEnum;
import com.vykon.vykonPro.hvac.BManualSequencerCmd;
import com.vykon.vykonPro.hvac.BRotationOrder;
import com.vykon.vykonPro.util.BDisabledLoadsBitString;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLoadSequencer
extends BComponent {
    public static final Property status = BLoadSequencer.newProperty((int)65, (BValue)BStatus.ok, null);
    public static final Property faultCause = BLoadSequencer.newProperty((int)65, (String)"", null);
    public static final Property facets = BLoadSequencer.newProperty((int)256, (BValue)BFacets.makeBoolean(), null);
    public static final Property actionFacets = BLoadSequencer.newProperty((int)256, (BValue)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Property schedule = BLoadSequencer.newProperty((int)264, (BValue)new BStatusBoolean(), null);
    public static final Property loadFailed = BLoadSequencer.newProperty((int)9, (BValue)new BStatusBoolean(), null);
    public static final Property numberOutputs = BLoadSequencer.newProperty((int)256, (int)2, (BFacets)BFacets.makeInt(null, (int)2, (int)10));
    public static final Property requiredLoads = BLoadSequencer.newProperty((int)256, (int)1, (BFacets)BFacets.makeInt(null, (int)0, (int)10));
    public static final Property rotationOrder = BLoadSequencer.newProperty((int)257, (BValue)new BRotationOrder(), null);
    public static final Property lastActiveLoad = BLoadSequencer.newProperty((int)3, (String)"", null);
    public static final Property feedbackDelay = BLoadSequencer.newProperty((int)256, (BValue)BRelTime.make((long)30000L), null);
    public static final Property outA = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outB = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outC = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outD = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outE = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outF = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outG = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outH = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outI = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outJ = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackA = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackB = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackC = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackD = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackE = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackF = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackG = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackH = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackI = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackJ = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property disabledLoads = BLoadSequencer.newProperty((int)69, (BValue)new BDisabledLoadsBitString(0), null);
    public static final Property debug = BLoadSequencer.newProperty((int)4, (boolean)false, null);
    public static final Action startupTimerExpired = BLoadSequencer.newAction((int)4, null);
    public static final Action feedbackTimerExpired = BLoadSequencer.newAction((int)4, null);
    public static final Action disableOutput = BLoadSequencer.newAction((int)0, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Action enableOutput = BLoadSequencer.newAction((int)0, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Action manualCmd = BLoadSequencer.newAction((int)0, (BValue)new BManualSequencerCmd(), null);
    public static final Action loadsChanged = BLoadSequencer.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BLoadSequencer.class);
    private static final BIcon icon = BIcon.std((String)"reorder.png");
    int numOutputs;
    int startedLoads;
    int runningLoads;
    boolean feedbackTimerActive = false;
    boolean currentIn;
    boolean wasOn = false;
    boolean isFirst = false;
    Clock.Ticket feedbackTicket;
    Clock.Ticket startupTicket;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BFacets getActionFacets() {
        return (BFacets)this.get(actionFacets);
    }

    public void setActionFacets(BFacets v) {
        this.set(actionFacets, (BValue)v, null);
    }

    public BStatusBoolean getSchedule() {
        return (BStatusBoolean)this.get(schedule);
    }

    public void setSchedule(BStatusBoolean v) {
        this.set(schedule, (BValue)v, null);
    }

    public BStatusBoolean getLoadFailed() {
        return (BStatusBoolean)this.get(loadFailed);
    }

    public void setLoadFailed(BStatusBoolean v) {
        this.set(loadFailed, (BValue)v, null);
    }

    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    public void setNumberOutputs(int v) {
        this.setInt(numberOutputs, v, null);
    }

    public int getRequiredLoads() {
        return this.getInt(requiredLoads);
    }

    public void setRequiredLoads(int v) {
        this.setInt(requiredLoads, v, null);
    }

    public BRotationOrder getRotationOrder() {
        return (BRotationOrder)this.get(rotationOrder);
    }

    public void setRotationOrder(BRotationOrder v) {
        this.set(rotationOrder, (BValue)v, null);
    }

    public String getLastActiveLoad() {
        return this.getString(lastActiveLoad);
    }

    public void setLastActiveLoad(String v) {
        this.setString(lastActiveLoad, v, null);
    }

    public BRelTime getFeedbackDelay() {
        return (BRelTime)this.get(feedbackDelay);
    }

    public void setFeedbackDelay(BRelTime v) {
        this.set(feedbackDelay, (BValue)v, null);
    }

    public BStatusBoolean getOutA() {
        return (BStatusBoolean)this.get(outA);
    }

    public void setOutA(BStatusBoolean v) {
        this.set(outA, (BValue)v, null);
    }

    public BStatusBoolean getOutB() {
        return (BStatusBoolean)this.get(outB);
    }

    public void setOutB(BStatusBoolean v) {
        this.set(outB, (BValue)v, null);
    }

    public BStatusBoolean getOutC() {
        return (BStatusBoolean)this.get(outC);
    }

    public void setOutC(BStatusBoolean v) {
        this.set(outC, (BValue)v, null);
    }

    public BStatusBoolean getOutD() {
        return (BStatusBoolean)this.get(outD);
    }

    public void setOutD(BStatusBoolean v) {
        this.set(outD, (BValue)v, null);
    }

    public BStatusBoolean getOutE() {
        return (BStatusBoolean)this.get(outE);
    }

    public void setOutE(BStatusBoolean v) {
        this.set(outE, (BValue)v, null);
    }

    public BStatusBoolean getOutF() {
        return (BStatusBoolean)this.get(outF);
    }

    public void setOutF(BStatusBoolean v) {
        this.set(outF, (BValue)v, null);
    }

    public BStatusBoolean getOutG() {
        return (BStatusBoolean)this.get(outG);
    }

    public void setOutG(BStatusBoolean v) {
        this.set(outG, (BValue)v, null);
    }

    public BStatusBoolean getOutH() {
        return (BStatusBoolean)this.get(outH);
    }

    public void setOutH(BStatusBoolean v) {
        this.set(outH, (BValue)v, null);
    }

    public BStatusBoolean getOutI() {
        return (BStatusBoolean)this.get(outI);
    }

    public void setOutI(BStatusBoolean v) {
        this.set(outI, (BValue)v, null);
    }

    public BStatusBoolean getOutJ() {
        return (BStatusBoolean)this.get(outJ);
    }

    public void setOutJ(BStatusBoolean v) {
        this.set(outJ, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackA() {
        return (BStatusBoolean)this.get(feedbackA);
    }

    public void setFeedbackA(BStatusBoolean v) {
        this.set(feedbackA, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackB() {
        return (BStatusBoolean)this.get(feedbackB);
    }

    public void setFeedbackB(BStatusBoolean v) {
        this.set(feedbackB, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackC() {
        return (BStatusBoolean)this.get(feedbackC);
    }

    public void setFeedbackC(BStatusBoolean v) {
        this.set(feedbackC, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackD() {
        return (BStatusBoolean)this.get(feedbackD);
    }

    public void setFeedbackD(BStatusBoolean v) {
        this.set(feedbackD, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackE() {
        return (BStatusBoolean)this.get(feedbackE);
    }

    public void setFeedbackE(BStatusBoolean v) {
        this.set(feedbackE, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackF() {
        return (BStatusBoolean)this.get(feedbackF);
    }

    public void setFeedbackF(BStatusBoolean v) {
        this.set(feedbackF, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackG() {
        return (BStatusBoolean)this.get(feedbackG);
    }

    public void setFeedbackG(BStatusBoolean v) {
        this.set(feedbackG, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackH() {
        return (BStatusBoolean)this.get(feedbackH);
    }

    public void setFeedbackH(BStatusBoolean v) {
        this.set(feedbackH, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackI() {
        return (BStatusBoolean)this.get(feedbackI);
    }

    public void setFeedbackI(BStatusBoolean v) {
        this.set(feedbackI, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackJ() {
        return (BStatusBoolean)this.get(feedbackJ);
    }

    public void setFeedbackJ(BStatusBoolean v) {
        this.set(feedbackJ, (BValue)v, null);
    }

    public BDisabledLoadsBitString getDisabledLoads() {
        return (BDisabledLoadsBitString)this.get(disabledLoads);
    }

    public void setDisabledLoads(BDisabledLoadsBitString v) {
        this.set(disabledLoads, (BValue)v, null);
    }

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean v) {
        this.setBoolean(debug, v, null);
    }

    public void startupTimerExpired() {
        this.invoke(startupTimerExpired, null, null);
    }

    public void feedbackTimerExpired() {
        this.invoke(feedbackTimerExpired, null, null);
    }

    public void disableOutput(BEnum output) {
        this.invoke(disableOutput, (BValue)output, null);
    }

    public void enableOutput(BEnum output) {
        this.invoke(enableOutput, (BValue)output, null);
    }

    public void manualCmd(BManualSequencerCmd manCmd) {
        this.invoke(manualCmd, (BValue)manCmd, null);
    }

    public void loadsChanged() {
        this.invoke(loadsChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        this.startupTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)30), (Action)startupTimerExpired, null);
        this.numOutputs = this.getNumberOutputs();
        this.initNumberOutputs();
    }

    public void stopped() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (p == numberOutputs) {
            this.initNumberOutputs();
        } else if (p == schedule) {
            this.calculate();
        } else if (p == requiredLoads) {
            if (this.getSchedule().getValue()) {
                this.startOutput();
            }
        } else if (p == feedbackA || p == feedbackB || p == feedbackC || p == feedbackD || p == feedbackE || p == feedbackF || p == feedbackG || p == feedbackH || p == feedbackI || p == feedbackJ) {
            if (!this.currentIn) {
                return;
            }
            if (this.feedbackTimerActive) {
                return;
            }
            this.checkRunningStatus();
        }
    }

    public void initNumberOutputs() {
        this.numOutputs = this.getNumberOutputs();
        boolean used = false;
        for (int i = 0; i < 10; ++i) {
            int setFlags;
            if (i >= this.numOutputs) {
                setFlags = 6;
                used = false;
            } else {
                setFlags = 10;
                used = true;
            }
            switch (i) {
                case 0: {
                    this.initSlot("outA", setFlags | 1);
                    this.initSlot("feedbackA", setFlags);
                    this.initLoads("outA", used, 1);
                    break;
                }
                case 1: {
                    this.initSlot("outB", setFlags | 1);
                    this.initSlot("feedbackB", setFlags);
                    this.initLoads("outB", used, 2);
                    break;
                }
                case 2: {
                    this.initSlot("outC", setFlags | 1);
                    this.initSlot("feedbackC", setFlags);
                    this.initLoads("outC", used, 3);
                    break;
                }
                case 3: {
                    this.initSlot("outD", setFlags | 1);
                    this.initSlot("feedbackD", setFlags);
                    this.initLoads("outD", used, 4);
                    break;
                }
                case 4: {
                    this.initSlot("outE", setFlags | 1);
                    this.initSlot("feedbackE", setFlags);
                    this.initLoads("outE", used, 5);
                    break;
                }
                case 5: {
                    this.initSlot("outF", setFlags | 1);
                    this.initSlot("feedbackF", setFlags);
                    this.initLoads("outF", used, 6);
                    break;
                }
                case 6: {
                    this.initSlot("outG", setFlags | 1);
                    this.initSlot("feedbackG", setFlags);
                    this.initLoads("outG", used, 7);
                    break;
                }
                case 7: {
                    this.initSlot("outH", setFlags | 1);
                    this.initSlot("feedbackH", setFlags);
                    this.initLoads("outH", used, 8);
                    break;
                }
                case 8: {
                    this.initSlot("outI", setFlags | 1);
                    this.initSlot("feedbackI", setFlags);
                    this.initLoads("outI", used, 9);
                    break;
                }
                case 9: {
                    this.initSlot("outJ", setFlags | 1);
                    this.initSlot("feedbackJ", setFlags);
                    this.initLoads("outJ", used, 10);
                }
            }
            int[] disabledLoads = this.getDisabledLoads().getOrdinals();
            for (int k = 0; k < disabledLoads.length; ++k) {
                if (!this.getDisabledLoads().getBit(disabledLoads[k])) continue;
                String loadName = this.getDisabledLoads().getTag(disabledLoads[k]);
                ((BStatusBoolean)this.get(loadName)).setStatusDisabled(true);
            }
        }
    }

    void initSlot(String slot, int flags) {
        try {
            this.setFlags(this.getSlot(slot), flags, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void initLoads(String name, boolean used, int value) {
        int setFlags = 5;
        BRotationOrder ro = this.getRotationOrder();
        if (used) {
            if (ro.get(name) == null) {
                ro.add(name, (BValue)BInteger.make((int)value));
                ro.setFlags(ro.getSlot(name), setFlags);
            }
        } else if (ro.get(name) != null) {
            ro.remove(name);
        }
    }

    public void doStartupTimerExpired() {
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        this.calculate();
    }

    public void doFeedbackTimerExpired() {
        this.feedbackTimerActive = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doDisableOutput(BEnum output) {
        int outNmbr = output.getEnum().getOrdinal();
        this.getStatusOutput(outNmbr).setStatusDisabled(true);
        int loadBit = this.getLoadBit(outNmbr);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | loadBit));
        this.startOutput();
    }

    public void doEnableOutput(BEnum output) {
        int outNmbr = output.getEnum().getOrdinal();
        this.getStatusOutput(outNmbr).setStatusDisabled(false);
        int loadBit = this.getLoadBit(outNmbr);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~loadBit));
        this.startOutput();
    }

    public void doManualCmd(BManualSequencerCmd manCmd) {
        int outNmbr = manCmd.getOutput().getOrdinal();
        if (manCmd.getCommand()) {
            this.getStatusOutput(outNmbr).setStatusDisabled(true);
            int loadBit = this.getLoadBit(outNmbr);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | loadBit));
        } else {
            this.getStatusOutput(outNmbr).setStatusDisabled(false);
            int loadBit = this.getLoadBit(outNmbr);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~loadBit));
        }
        this.startOutput();
    }

    public void doLoadsChanged() {
        this.startOutput();
    }

    void calculate() {
        this.currentIn = this.getSchedule().getValue();
        if (this.currentIn) {
            if (!this.wasOn) {
                this.startOutput();
                this.wasOn = true;
            }
        } else {
            if (this.wasOn) {
                if (this.feedbackTicket != null) {
                    this.feedbackTicket.cancel();
                }
                this.wasOn = false;
            }
            this.stopOutput();
        }
    }

    boolean getOutValue(int index) {
        switch (index) {
            case 1: {
                return this.getOutA().getValue();
            }
            case 2: {
                return this.getOutB().getValue();
            }
            case 3: {
                return this.getOutC().getValue();
            }
            case 4: {
                return this.getOutD().getValue();
            }
            case 5: {
                return this.getOutE().getValue();
            }
            case 6: {
                return this.getOutF().getValue();
            }
            case 7: {
                return this.getOutG().getValue();
            }
            case 8: {
                return this.getOutH().getValue();
            }
            case 9: {
                return this.getOutI().getValue();
            }
            case 10: {
                return this.getOutJ().getValue();
            }
        }
        return false;
    }

    boolean getOutStatus(int index) {
        switch (index) {
            case 1: {
                return this.getOutA().getStatus().isOk();
            }
            case 2: {
                return this.getOutB().getStatus().isOk();
            }
            case 3: {
                return this.getOutC().getStatus().isOk();
            }
            case 4: {
                return this.getOutD().getStatus().isOk();
            }
            case 5: {
                return this.getOutE().getStatus().isOk();
            }
            case 6: {
                return this.getOutF().getStatus().isOk();
            }
            case 7: {
                return this.getOutG().getStatus().isOk();
            }
            case 8: {
                return this.getOutH().getStatus().isOk();
            }
            case 9: {
                return this.getOutI().getStatus().isOk();
            }
            case 10: {
                return this.getOutJ().getStatus().isOk();
            }
        }
        return false;
    }

    boolean getFeedbackValue(int index) {
        switch (index) {
            case 1: {
                return this.getFeedbackA().getValue();
            }
            case 2: {
                return this.getFeedbackB().getValue();
            }
            case 3: {
                return this.getFeedbackC().getValue();
            }
            case 4: {
                return this.getFeedbackD().getValue();
            }
            case 5: {
                return this.getFeedbackE().getValue();
            }
            case 6: {
                return this.getFeedbackF().getValue();
            }
            case 7: {
                return this.getFeedbackG().getValue();
            }
            case 8: {
                return this.getFeedbackH().getValue();
            }
            case 9: {
                return this.getFeedbackI().getValue();
            }
            case 10: {
                return this.getFeedbackJ().getValue();
            }
        }
        return false;
    }

    void startOutput() {
        if (this.getDebug()) {
            System.out.println(this.getSlotPath() + " - running start output");
        }
        if (!this.getSchedule().getValue()) {
            return;
        }
        String load = "";
        int req = this.getRequiredLoads();
        int started = 0;
        boolean outputChanged = false;
        BRotationOrder ro = this.getRotationOrder();
        String current = ro.getOrder();
        String[] loads = TextUtil.splitAndTrim((String)current, (char)',');
        for (int k = 0; k < loads.length; ++k) {
            if (ro.get("out" + loads[k]) == null) continue;
            int id = ((BInteger)ro.get("out" + loads[k])).getInt();
            if (started < req && this.getStatusOutput(id).getStatus().isOk()) {
                if (!this.getStatusOutput(id).getValue()) {
                    this.getStatusOutput(id).setValue(true);
                    outputChanged = true;
                }
                ++started;
                load = "out" + loads[k];
                if (!this.getDebug()) continue;
                System.out.println("checked load " + id + " , started " + started);
                continue;
            }
            if (started != req) continue;
            this.getStatusOutput(id).setValue(false);
            if (!this.getDebug()) continue;
            System.out.println("checking " + loads[k] + " , enough loads already started");
        }
        if (started < req) {
            if (this.getDebug()) {
                System.out.println("didn't start the required number of loads");
            }
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)true));
            this.setFaultCause("Not enough loads available to start the required number!");
        } else {
            if (this.getDebug()) {
                System.out.println("started the required number of loads");
            }
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
            if (!this.getStatus().isFault()) {
                this.setFaultCause("");
            }
        }
        if (outputChanged) {
            this.startFeedbackTimer();
        }
        this.setLastActiveLoad(load);
    }

    BStatusBoolean getStatusOutput(int index) {
        switch (index) {
            case 1: {
                return this.getOutA();
            }
            case 2: {
                return this.getOutB();
            }
            case 3: {
                return this.getOutC();
            }
            case 4: {
                return this.getOutD();
            }
            case 5: {
                return this.getOutE();
            }
            case 6: {
                return this.getOutF();
            }
            case 7: {
                return this.getOutG();
            }
            case 8: {
                return this.getOutH();
            }
            case 9: {
                return this.getOutI();
            }
            case 10: {
                return this.getOutJ();
            }
        }
        if (index < 1) {
            return this.getOutA();
        }
        return this.getOutJ();
    }

    void stopOutput() {
        for (int i = 1; i <= this.numOutputs; ++i) {
            this.getStatusOutput(i).setValue(false);
        }
        this.checkRunningStatus();
        this.setLastActiveLoad("");
    }

    void startFeedbackTimer() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        this.feedbackTimerActive = true;
        this.feedbackTicket = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpired, null);
    }

    void checkRunningStatus() {
        if (this.getDebug()) {
            System.out.println(this.getSlotPath() + "checking running status");
        }
        this.startedLoads = 0;
        this.runningLoads = 0;
        boolean isFailed = false;
        for (int i = 1; i <= this.numOutputs; ++i) {
            BStatusBoolean out = this.getStatusOutput(i);
            boolean feedback = this.getFeedbackValue(i);
            if (this.getDebug()) {
                System.out.println("load " + i + " out - " + out.getValue() + " | feedback - " + feedback);
            }
            if (out.getValue() && !feedback) {
                out.setStatusInAlarm(true);
                isFailed = true;
                ++this.startedLoads;
                continue;
            }
            if (out.getValue() && feedback) {
                out.setStatusInAlarm(false);
                ++this.startedLoads;
                ++this.runningLoads;
                continue;
            }
            if (!out.getValue() && feedback) continue;
            out.setStatusInAlarm(false);
        }
        if (isFailed || this.startedLoads > this.getRequiredLoads()) {
            if (this.getDebug()) {
                System.out.println(this.startedLoads + " loads started, " + this.getRequiredLoads() + " loads required, or a load is failed");
            }
            this.getLoadFailed().setValue(true);
            this.startOutput();
        } else {
            this.getLoadFailed().setValue(false);
        }
    }

    private int getLoadBit(int ordinal) {
        int loadBit = 0;
        switch (ordinal) {
            case 1: {
                loadBit = 1;
                break;
            }
            case 2: {
                loadBit = 2;
                break;
            }
            case 3: {
                loadBit = 4;
                break;
            }
            case 4: {
                loadBit = 8;
                break;
            }
            case 5: {
                loadBit = 16;
                break;
            }
            case 6: {
                loadBit = 32;
                break;
            }
            case 7: {
                loadBit = 48;
                break;
            }
            case 8: {
                loadBit = 64;
                break;
            }
            case 9: {
                loadBit = 128;
                break;
            }
            case 10: {
                loadBit = 512;
            }
        }
        return loadBit;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        if (slot.getName() == "enableOutput" || slot.getName() == "disableOutput") {
            return this.getActionFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }
}

