/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.util.BVykonProService;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BBooleanBql
extends BComponent {
    public static final Property status = BBooleanBql.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBooleanBql.newProperty((int)3, (String)"", null);
    public static final Property enabled = BBooleanBql.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property pointQuery = BBooleanBql.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property numberOfPoints = BBooleanBql.newProperty((int)11, (int)0, null);
    public static final Property count = BBooleanBql.newProperty((int)11, (int)0, null);
    public static final Property numberOfPointsTrue = BBooleanBql.newProperty((int)11, (int)0, null);
    public static final Property facets = BBooleanBql.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property orOut = BBooleanBql.newProperty((int)11, (BValue)new BStatusBoolean(false), null);
    public static final Property andOut = BBooleanBql.newProperty((int)11, (BValue)new BStatusBoolean(false), null);
    public static final Property updateValuesInterval = BBooleanBql.newProperty((int)256, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property refreshQueryInterval = BBooleanBql.newProperty((int)256, (BValue)BRelTime.makeHours((int)12), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1)));
    public static final Property startDelay = BBooleanBql.newProperty((int)256, (BValue)BRelTime.makeMinutes((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property nextRefreshTime = BBooleanBql.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    public static final Action calculate = BBooleanBql.newAction((int)4, null);
    public static final Action initializeList = BBooleanBql.newAction((int)0, null);
    public static final Action refreshQuery = BBooleanBql.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BBooleanBql.class);
    private static final BIcon icon = BIcon.std((String)"control/booleanPoint.png");
    Clock.Ticket ticket;
    Clock.Ticket calcTicket;
    Clock.Ticket startTicket;
    BITable result = null;
    BComponent[] comps;
    boolean refreshChanged = false;
    MySub sub = null;
    ArrayList myComps = null;
    private static BRelTime DEF_TIME = BRelTime.makeSeconds((int)15);

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BOrd getPointQuery() {
        return (BOrd)this.get(pointQuery);
    }

    public void setPointQuery(BOrd v) {
        this.set(pointQuery, (BValue)v, null);
    }

    public int getNumberOfPoints() {
        return this.getInt(numberOfPoints);
    }

    public void setNumberOfPoints(int v) {
        this.setInt(numberOfPoints, v, null);
    }

    public int getCount() {
        return this.getInt(count);
    }

    public void setCount(int v) {
        this.setInt(count, v, null);
    }

    public int getNumberOfPointsTrue() {
        return this.getInt(numberOfPointsTrue);
    }

    public void setNumberOfPointsTrue(int v) {
        this.setInt(numberOfPointsTrue, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BStatusBoolean getOrOut() {
        return (BStatusBoolean)this.get(orOut);
    }

    public void setOrOut(BStatusBoolean v) {
        this.set(orOut, (BValue)v, null);
    }

    public BStatusBoolean getAndOut() {
        return (BStatusBoolean)this.get(andOut);
    }

    public void setAndOut(BStatusBoolean v) {
        this.set(andOut, (BValue)v, null);
    }

    public BRelTime getUpdateValuesInterval() {
        return (BRelTime)this.get(updateValuesInterval);
    }

    public void setUpdateValuesInterval(BRelTime v) {
        this.set(updateValuesInterval, (BValue)v, null);
    }

    public BRelTime getRefreshQueryInterval() {
        return (BRelTime)this.get(refreshQueryInterval);
    }

    public void setRefreshQueryInterval(BRelTime v) {
        this.set(refreshQueryInterval, (BValue)v, null);
    }

    public BRelTime getStartDelay() {
        return (BRelTime)this.get(startDelay);
    }

    public void setStartDelay(BRelTime v) {
        this.set(startDelay, (BValue)v, null);
    }

    public BAbsTime getNextRefreshTime() {
        return (BAbsTime)this.get(nextRefreshTime);
    }

    public void setNextRefreshTime(BAbsTime v) {
        this.set(nextRefreshTime, (BValue)v, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void initializeList() {
        this.invoke(initializeList, null, null);
    }

    public void refreshQuery() {
        this.invoke(refreshQuery, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.checkForService();
        if (this.getEnabled() && this.getStatus().isOk()) {
            this.initStartTicket();
            this.initClockTicket();
            this.initCalcTicket();
        }
        this.sub = new MySub();
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.calcTicket != null) {
            this.calcTicket.cancel();
        }
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
        if (this.sub != null) {
            this.sub.unsubscribeAll();
            this.sub = null;
        }
    }

    private final void checkForService() {
        if (BVykonProService.getInstance() == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("This component requires the VykonPro service in the station");
        } else if (BVykonProService.getInstance().isDisabled()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("The vykonPro service is disabled");
        } else {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)orOut) || slot.equals((Object)andOut)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void clockChanged(BRelTime value) {
        if (this.getEnabled()) {
            this.initClockTicket();
            this.initCalcTicket();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(pointQuery)) {
            this.initializeList();
        }
        if (this.getEnabled()) {
            if (property.equals(refreshQueryInterval)) {
                this.refreshChanged = true;
                this.initClockTicket();
            } else if (property.equals(updateValuesInterval)) {
                this.initCalcTicket();
            }
        }
        if (property.equals(enabled)) {
            if (this.getEnabled()) {
                this.initializeList();
                this.calculate();
                this.initClockTicket();
            } else {
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                if (this.calcTicket != null) {
                    this.calcTicket.cancel();
                }
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == refreshQuery) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    public void doInitializeList() {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                return;
            }
        }
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
        if (this.getPointQuery().isNull()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("must specify a point query");
            return;
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.refreshQuery();
    }

    private void initStartTicket() {
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
        this.startTicket = Clock.schedule((BComponent)this, (BRelTime)this.getStartDelay(), (Action)initializeList, null);
    }

    void initClockTicket() {
        BAbsTime next = this.getNextRefreshTime();
        if (this.refreshChanged) {
            this.refreshChanged = false;
            next = BAbsTime.NULL;
        }
        BAbsTime current = Clock.time();
        BRelTime refreshPeriod = this.getRefreshQueryInterval();
        if (refreshPeriod.getMillis() < 60000L) {
            refreshPeriod = BRelTime.MINUTE;
        }
        if (next == BAbsTime.NULL) {
            this.setNextRefreshTime(current.add(refreshPeriod));
            next = this.getNextRefreshTime();
        } else if (current.isAfter(next)) {
            while (next.isBefore(current)) {
                next = next.add(refreshPeriod);
            }
            this.setNextRefreshTime(next);
        } else if (current.add(refreshPeriod).isBefore(this.getNextRefreshTime())) {
            this.setNextRefreshTime(current.add(refreshPeriod));
        }
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)next, (BRelTime)refreshPeriod, (Action)refreshQuery, null);
    }

    void initCalcTicket() {
        if (this.calcTicket != null) {
            this.calcTicket.cancel();
        }
        BRelTime interval = this.getUpdateValuesInterval().getMillis() >= 1000L ? this.getUpdateValuesInterval() : DEF_TIME;
        this.calcTicket = Clock.schedule((BComponent)this, (BRelTime)interval, (Action)calculate, null);
    }

    public void doCalculate() throws Exception {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                return;
            }
        }
        if (this.getPointQuery().isNull()) {
            this.initCalcTicket();
            return;
        }
        if (this.result == null) {
            this.initCalcTicket();
            BAbsTime current = Clock.time();
            if (this.ticket == null || this.getNextRefreshTime().isBefore(current)) {
                this.refreshQuery();
                this.initClockTicket();
            }
            return;
        }
        int totalTrue = 0;
        int num = 0;
        this.initCalcTicket();
        for (int i = 0; i < this.myComps.size(); ++i) {
            BStatusBoolean b;
            BComponent comp = (BComponent)this.myComps.get(i);
            if (comp.get("out") == null || !comp.get("out").getType().is(BStatusBoolean.TYPE)) continue;
            if (!comp.isSubscribed()) {
                this.sub.subscribe(comp);
            }
            if (!(b = (BStatusBoolean)comp.get("out")).getStatus().isValid()) continue;
            ++num;
            if (!b.getValue()) continue;
            ++totalTrue;
        }
        this.setNumberOfPointsTrue(totalTrue);
        this.setCount(num);
        if (totalTrue > 0) {
            this.getOrOut().setValue(true);
        } else {
            this.getOrOut().setValue(false);
        }
        if (totalTrue == num) {
            this.getAndOut().setValue(true);
        } else {
            this.getAndOut().setValue(false);
        }
    }

    public void doRefreshQuery() {
        this.result = (BITable)this.getPointQuery().resolve((BObject)this).get();
        this.myComps = new ArrayList();
        this.setNextRefreshTime(this.getNextRefreshTime().add(this.getRefreshQueryInterval()));
        int count = 0;
        try (TableCursor c = this.result.cursor();){
            while (c.next()) {
                ++count;
                this.myComps.add((BComponent)c.get());
            }
        }
        catch (Exception e) {
            System.out.println(this.getSlotPath() + " - error trying to refresh the query");
            System.out.println(e);
        }
        this.setNumberOfPoints(count);
    }

    public BIcon getIcon() {
        return icon;
    }

    private class MySub
    extends Subscriber {
        private MySub() {
        }

        public void event(BComponentEvent event) {
        }
    }
}

