/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.bql;

import com.tridium.bql.util.BDynamicTimeRange;
import com.vykon.vykonPro.enums.BBaseLineRangeEnum;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRangeShifter
extends BComponent {
    public static final Property timeRangeIn = BRangeShifter.newProperty((int)8, (BValue)BDynamicTimeRange.make((String)"today"), null);
    public static final Property timeRangeOut = BRangeShifter.newProperty((int)9, (BValue)BDynamicTimeRange.make((String)"today"), null);
    public static final Property baseLinePeriod = BRangeShifter.newProperty((int)0, (BValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBaseLineRangeEnum.TYPE))), null);
    public static final Property shift = BRangeShifter.newProperty((int)9, (BValue)BRelTime.make((long)0L), null);
    public static final Property updatePeriod = BRangeShifter.newProperty((int)4, (BValue)BRelTime.makeMinutes((int)15), null);
    public static final Action timerExpired = BRangeShifter.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BRangeShifter.class);
    private static final BIcon icon = BIcon.std((String)"clock.png");
    Clock.Ticket updateTicket;

    public BDynamicTimeRange getTimeRangeIn() {
        return (BDynamicTimeRange)this.get(timeRangeIn);
    }

    public void setTimeRangeIn(BDynamicTimeRange v) {
        this.set(timeRangeIn, (BValue)v, null);
    }

    public BDynamicTimeRange getTimeRangeOut() {
        return (BDynamicTimeRange)this.get(timeRangeOut);
    }

    public void setTimeRangeOut(BDynamicTimeRange v) {
        this.set(timeRangeOut, (BValue)v, null);
    }

    public BStatusEnum getBaseLinePeriod() {
        return (BStatusEnum)this.get(baseLinePeriod);
    }

    public void setBaseLinePeriod(BStatusEnum v) {
        this.set(baseLinePeriod, (BValue)v, null);
    }

    public BRelTime getShift() {
        return (BRelTime)this.get(shift);
    }

    public void setShift(BRelTime v) {
        this.set(shift, (BValue)v, null);
    }

    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    public void setUpdatePeriod(BRelTime v) {
        this.set(updatePeriod, (BValue)v, null);
    }

    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!this.isRunning()) {
            return;
        }
        this.calculate();
        this.initTimer();
    }

    public void stopped() {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(timeRangeIn)) {
            this.calculate();
            this.initTimer();
        } else if (p.equals(baseLinePeriod)) {
            if (this.getBaseLinePeriod().getEnum().getOrdinal() == 4) {
                Slot s = this.getSlot("timeRangeOut");
                if (Flags.isReadonly((BComplex)this, (Slot)s)) {
                    this.setFlags(s, this.getFlags(s) & 0xFFFFFFFE);
                }
            } else {
                Slot s = this.getSlot("timeRangeOut");
                if (!Flags.isReadonly((BComplex)this, (Slot)s)) {
                    this.setFlags(s, this.getFlags(s) | 1);
                }
            }
            this.calculate();
            this.initTimer();
        } else if (p.equals(timeRangeOut)) {
            Slot s = this.getSlot("timeRangeOut");
            if (!Flags.isReadonly((BComplex)this, (Slot)s)) {
                this.calculate();
                this.initTimer();
            }
        } else if (p.equals(updatePeriod)) {
            this.initTimer();
        }
    }

    public void clockChanged(BRelTime shift) {
        this.initTimer();
    }

    public void doTimerExpired() {
        this.calculate();
        this.initTimer();
    }

    private void calculate() {
        BAbsTime current = Clock.time();
        BRelTime difference = BRelTime.make((long)0L);
        BAbsTime start = this.getTimeRangeIn().getStartTime(current);
        BAbsTime stop = this.getTimeRangeIn().getEndTime(current);
        BAbsTime previousStart = BAbsTime.NULL;
        BAbsTime previousStop = BAbsTime.NULL;
        switch (this.getBaseLinePeriod().getEnum().getOrdinal()) {
            case 0: {
                this.setTimeRangeOut((BDynamicTimeRange)this.getTimeRangeIn().newCopy());
                break;
            }
            case 1: {
                previousStart = start.prev(start.getWeekday());
                previousStop = stop.prev(stop.getWeekday());
                break;
            }
            case 2: {
                previousStart = start.prevMonth();
                previousStop = stop.prevMonth();
                break;
            }
            case 3: {
                previousStart = start.prevYear();
                previousStop = stop.prevYear();
                break;
            }
        }
        if (previousStart != BAbsTime.NULL) {
            difference = start.delta(previousStart);
            this.setTimeRangeOut(BDynamicTimeRange.make((BAbsTime)previousStart, (BAbsTime)previousStop));
        } else {
            difference = start.delta(this.getTimeRangeOut().getStartTime(current));
        }
        this.setShift(BRelTime.make((long)(difference.getMillis() * -1L)));
    }

    private void initTimer() {
        if (!this.isRunning()) {
            return;
        }
        int ordinal = this.getTimeRangeIn().getRangeType().getOrdinal();
        BAbsTime current = Clock.time();
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
        }
        switch (ordinal) {
            case 0: {
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                BAbsTime future = BAbsTime.make((BAbsTime)current.nextDay(), (BTime)BTime.MIDNIGHT);
                this.updateTicket = Clock.schedule((BComponent)this, (BAbsTime)future, (Action)timerExpired, null);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                this.updateTicket = Clock.schedule((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)timerExpired, null);
                break;
            }
            case 5: {
                BAbsTime future = current.next(BWeekday.sunday);
                this.updateTicket = Clock.schedule((BComponent)this, (BAbsTime)future, (Action)timerExpired, null);
                break;
            }
            case 8: {
                BAbsTime future = BAbsTime.make((int)current.getYear(), (BMonth)current.getMonth(), (int)1).nextMonth();
                this.updateTicket = Clock.schedule((BComponent)this, (BAbsTime)future, (Action)timerExpired, null);
                break;
            }
            case 10: {
                BAbsTime future = BAbsTime.make((int)(current.getYear() + 1), (BMonth)BMonth.make((int)0), (int)1);
                this.updateTicket = Clock.schedule((BComponent)this, (BAbsTime)future, (Action)timerExpired, null);
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

