/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.alarm;

import com.vykon.vykonPro.util.BVykonProService;
import java.util.ArrayList;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmClassFolder;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BCompositeTopic;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BAlarmEmailRecipFilter
extends BComponent {
    public static final Property filterNotes = BAlarmEmailRecipFilter.newProperty((int)256, (boolean)false, null);
    public static final Property filterEscalation = BAlarmEmailRecipFilter.newProperty((int)256, (boolean)false, null);
    public static final Action filterAlarm = BAlarmEmailRecipFilter.newAction((int)24, (BValue)new BAlarmRecord(), null);
    public static final Topic route = BAlarmEmailRecipFilter.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BAlarmEmailRecipFilter.class);
    String[] aclasses = null;
    private boolean acceptEscalation = false;
    private boolean acceptNotes = false;

    public boolean getFilterNotes() {
        return this.getBoolean(filterNotes);
    }

    public void setFilterNotes(boolean v) {
        this.setBoolean(filterNotes, v, null);
    }

    public boolean getFilterEscalation() {
        return this.getBoolean(filterEscalation);
    }

    public void setFilterEscalation(boolean v) {
        this.setBoolean(filterEscalation, v, null);
    }

    public void filterAlarm(BAlarmRecord alarm) {
        this.invoke(filterAlarm, (BValue)alarm, null);
    }

    public void fireRoute(BAlarmRecord event) {
        this.fire(route, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == filterAlarm) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    public void doFilterAlarm(BAlarmRecord alarm) {
        if (this.accept(alarm)) {
            this.fireRoute(alarm);
        }
    }

    public boolean accept(BAlarmRecord alarm) {
        if (this.getFilterEscalation()) {
            this.acceptEscalation = false;
            String escLevel = alarm.getAlarmFacet("escalated").toString();
            if (escLevel == null || escLevel.length() == 0) {
                this.aclasses = this.getSubscribedAlarmClasses("alarm");
            } else {
                int level = Integer.parseInt(escLevel.substring(escLevel.length() - 1));
                this.aclasses = this.getSubscribedEscalatedAlarmClasses(level);
            }
            for (int i = 0; i < this.aclasses.length; ++i) {
                if (!alarm.getAlarmClass().equals(this.aclasses[i])) continue;
                this.acceptEscalation = true;
            }
        } else {
            this.acceptEscalation = true;
        }
        if (this.getFilterNotes()) {
            this.acceptNotes = false;
            if (alarm.getAlarmFacet("notes") != null) {
                String note = alarm.getAlarmFacet("notes").toString();
                BFacets f = BFacets.make((String)"SHOW_SECONDS", (BIDataValue)BBoolean.make((boolean)false));
                String timestamp = alarm.getLastUpdate().toString((Context)f);
                if (note.indexOf(timestamp) == -1) {
                    this.acceptNotes = true;
                }
            } else {
                this.acceptNotes = true;
            }
        } else {
            this.acceptNotes = true;
        }
        return this.acceptNotes && this.acceptEscalation;
    }

    public String[] getSubscribedEscalatedAlarmClasses(int level) {
        if (level < 1 || level > 3) {
            return new String[0];
        }
        return this.getSubscribedAlarmClasses("escalatedAlarm" + level);
    }

    private String[] getSubscribedAlarmClasses(String sourceSlotName) {
        ArrayList<String> classes = new ArrayList<String>();
        SlotCursor c = this.getProperties();
        while (c.next(BLink.class)) {
            try {
                BComponent srcComp;
                BLink link = (BLink)c.get();
                if (!link.isActive()) {
                    link.activate();
                }
                if ((srcComp = link.getSourceComponent()) instanceof BAlarmClass && link.getSourceSlotName().equals(sourceSlotName)) {
                    classes.add(srcComp.getName());
                    continue;
                }
                while (srcComp instanceof BIAlarmClassFolder) {
                    BAlarmClassFolder folder = (BAlarmClassFolder)srcComp;
                    String folderSlotName = link.getSourceSlotName();
                    link = ((BCompositeTopic)folder.get((String)folderSlotName)).getMirror().link;
                    srcComp = link.getSourceComponent();
                    if (!(srcComp instanceof BAlarmClass) || !link.getSourceSlotName().equals(sourceSlotName)) continue;
                    classes.add(srcComp.getName());
                }
            }
            catch (Exception e) {
                System.out.println(this.getSlotPath() + " - " + e.getMessage());
            }
        }
        String[] array = new String[classes.size()];
        return classes.toArray(array);
    }
}

