/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.orion.BIMappable;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.naming.BModuleScheme;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Type;

public class MapHelper {
    private static final AgentFilter filter = AgentFilter.is((Type)BIMappable.TYPE);
    private static final NoSuchAgentException NO_SUCH_AGENT_EXCEPTION_INSTANCE = new NoSuchAgentException("There is no BIMappable orion object registered as an agent for Type");
    private static boolean USE_SINGLE_EXCEPTION;

    public BIOrionObject mapForRead(BObject object) {
        return this.map(object, true);
    }

    public BIOrionObject mapForUpdate(BObject object) {
        return this.map(object, false);
    }

    public BIOrionObject mapForInsert(BObject object) {
        return this.map(object, false);
    }

    public BIOrionObject mapForDelete(BObject object) {
        return this.map(object, false);
    }

    public static BIOrionObject getOrionObjectInstance(BObject object) throws NoSuchAgentException, OrionException {
        AgentList agentList = object.getAgents().filter(filter);
        if (agentList.size() != 1) {
            if (agentList.size() == 0) {
                throw USE_SINGLE_EXCEPTION ? NO_SUCH_AGENT_EXCEPTION_INSTANCE : new NoSuchAgentException("There is no BIMappable orion object registered as an agent for objects of type: " + object.getType());
            }
            throw new OrionException("There can only be one BIMappable orion object registered on a BObject. Type " + object.getType() + " has " + agentList.size() + " agents registered.");
        }
        return (BIOrionObject)agentList.get(0).getInstance();
    }

    private BIOrionObject map(BObject source, boolean keysOnly) {
        Property[] persistentProperties;
        BIOrionObject orionObject = MapHelper.getOrionObjectInstance(source);
        OrionType orionType = (OrionType)orionObject.getType();
        ((BIMappable)((Object)orionObject)).mapFrom(source);
        for (Property persistentProperty : persistentProperties = orionType.getPersistentProperties()) {
            orionObject.setModified(persistentProperty, !keysOnly && !BOrionObject.isKey(persistentProperty) && !BOrionObject.isDbSourced(persistentProperty));
        }
        return orionObject;
    }

    static {
        NO_SUCH_AGENT_EXCEPTION_INSTANCE.setStackTrace(new StackTraceElement[]{new StackTraceElement("com.tridium.orion.priv.util.MapHelper", "getOrionObjectInstance", "MapHelper.java", -1)});
        USE_SINGLE_EXCEPTION = !BModuleScheme.isModuleDevEnabled();
    }
}

