/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.query;

import com.tridium.data.BDataTable;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import javax.baja.collection.BITable;
import javax.baja.naming.SlotPath;
import javax.baja.query.BQuery;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;

public class QueryTableModel {
    private BQuery query;
    private Property[] cols = new Property[0];
    private BIOrionObject[] rows = new BIOrionObject[0];

    public QueryTableModel(OrionSession session, BQuery query) {
        this.query = query;
        this.load(session);
    }

    protected void load(OrionSession session) {
        try (OrionCursor cursor = null;){
            cursor = session.select(this.query);
            this.cols = cursor.getOrionType().getPersistentProperties();
            this.rows = cursor.toArray();
        }
    }

    public Object getSubject(int row) {
        return this.rows[row];
    }

    public int getColumnCount() {
        return this.cols.length;
    }

    public String getColumnName(int index) {
        return this.cols[index].getName();
    }

    public int getRowCount() {
        return this.rows.length;
    }

    public Object getValueAt(int row, int col) {
        BIOrionObject obj = this.rows[row];
        return obj.get(this.cols[col]);
    }

    public BITable<?> export() {
        int colCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        BDataTable t = new BDataTable();
        for (int c = 0; c < colCount; ++c) {
            String displayName = this.getColumnName(c);
            String name = SlotPath.escape((String)displayName);
            t.addColumn(name, displayName, this.cols[c].getType().getInstance().toDataValue().getType(), 0, BFacets.NULL);
        }
        t.startRows();
        for (int r = 0; r < rowCount; ++r) {
            t.startRow();
            for (int c = 0; c < colCount; ++c) {
                BSimple v = (BSimple)this.getValueAt(r, c);
                t.set(v.toDataValue(), BFacets.NULL);
            }
            t.endRow();
        }
        t.endRows();
        return t;
    }
}

