/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.model;

import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionModel;
import com.tridium.orion.OrionType;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.baja.nre.util.Array;
import javax.baja.sys.Property;

public class LocalOrionModel
implements OrionModel {
    private BOrionSpace space;
    Array<OrionType> typeList = new Array(OrionType.class);
    HashMap<BOrionTypeId, OrionType> idMap = new HashMap();
    private boolean committed = false;

    public LocalOrionModel(BOrionSpace space) {
        this.space = space;
    }

    protected LocalOrionModel() {
    }

    public LocalOrionModel commit() {
        OrionType t;
        int i;
        for (i = 0; i < this.typeList.size(); ++i) {
            t = (OrionType)this.typeList.get(i);
            this.resolve(t);
        }
        for (i = 0; i < this.typeList.size(); ++i) {
            t = (OrionType)this.typeList.get(i);
            this.validateTypeHierarchy(t);
        }
        this.committed = true;
        return this;
    }

    private void resolve(OrionType type) {
        boolean hasKey = false;
        Property[] properties = type.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            this.resolve(type, properties[i]);
            if (hasKey) continue;
            hasKey = BOrionObject.isKey(properties[i]);
        }
        if (!type.isAssociation() && !hasKey) {
            throw new OrionException("Non-association types must have at least one identity property. (" + (Object)((Object)type.getOrionTypeId()) + ")");
        }
    }

    private void resolve(OrionType type, Property p) {
        if (p.getType() == BRef.TYPE) {
            BRef ref = (BRef)p.getDefaultValue();
            BOrionTypeId targetTypeId = ref.getTargetOrionTypeId();
            OrionType targetType = this.getType(targetTypeId);
            if (targetType == null) {
                throw new OrionException("Cannot resolve target type for ref " + type.getTypeName() + "." + p.getName() + "->" + (Object)((Object)targetTypeId));
            }
            Object var6_6 = null;
        }
    }

    @Override
    public OrionType addType(OrionType newType) {
        if (this.committed) {
            throw new OrionException("Cannot add " + (Object)((Object)newType.getOrionTypeId()) + " to the local model.  The model has already been committed.");
        }
        OrionType mtype = newType;
        this.typeList.add((Object)mtype);
        this.idMap.put(mtype.getOrionTypeId(), mtype);
        return mtype;
    }

    public void mergeModel(OrionModel model) {
        OrionType[] types = model.getTypes();
        for (int i = 0; i < types.length; ++i) {
            this.addType(types[i]);
        }
    }

    @Override
    public OrionType[] getTypes() {
        return (OrionType[])this.typeList.trim();
    }

    @Override
    public OrionType getType(BOrionTypeId id) {
        return this.idMap.get((Object)id);
    }

    @Override
    public OrionType getType(OrionType type, boolean add) {
        OrionType modelType = this.getType(type.getOrionTypeId());
        if (modelType != null) {
            return modelType;
        }
        if (add) {
            return this.addType(type);
        }
        return null;
    }

    @Override
    public BTypeDependency[] getDependentTypes(OrionType baseType) {
        BOrionTypeId baseTypeId = baseType.getOrionTypeId();
        Array temp = new Array(BTypeDependency.class);
        for (OrionType type : this.typeList) {
            Property[] props = type.getProperties();
            for (int j = 0; j < props.length; ++j) {
                BRef def;
                Property p = props[j];
                if (p.getType() != BRef.TYPE || !(def = (BRef)p.getDefaultValue()).getTargetOrionTypeId().equals((Object)baseTypeId)) continue;
                temp.add((Object)BTypeDependency.make(type.getOrionTypeId(), p.getName(), baseType.getOrionTypeId(), baseType.getKey()[0].getName()));
            }
        }
        return (BTypeDependency[])temp.trim();
    }

    public void dump() {
        PrintWriter out = new PrintWriter(System.out);
        this.dump(out);
        out.flush();
    }

    public void dump(PrintWriter out) {
        out.println("LocalOrionModel");
        for (OrionType t : this.typeList) {
            LocalOrionModel.dump(out, t);
            out.println();
        }
    }

    public static void dump(PrintWriter out, OrionType type) {
        String name = type.getTypeName();
        BOrionTypeId id = type.getOrionTypeId();
        Property[] identity = type.getKey();
        BOrionTypeId superTypeId = type.getSuperTypeId();
        OrionType superType = type.getOrionSuperType();
        Property[] props = type.getProperties();
        out.println("  " + name + ": " + (Object)((Object)id));
        if (identity != null) {
            out.print("    identity=");
            boolean first = true;
            for (int i = 0; i < identity.length; ++i) {
                if (!first) {
                    out.print(", ");
                }
                first = false;
                out.print(identity[i].getName());
            }
            out.println();
        }
        out.println("    abstract=" + type.isAbstract());
        out.println("    final=" + type.isFinal());
        if (superTypeId != null) {
            if (superType != null) {
                out.println("    super type=" + superType);
            } else {
                out.println("    super type=" + (Object)((Object)superTypeId) + " UNRESOLVED");
            }
        }
        out.println("    properties:");
        for (int i = 0; i < props.length; ++i) {
            out.print("      " + props[i]);
            if (props[i].getType() == BRef.TYPE) {
                out.print(" " + props[i].getDefaultValue());
            }
            out.println();
        }
    }

    public void validateTypeHierarchy(OrionType type) {
        HashMap<BOrionTypeId, OrionType> hierarchy = new HashMap<BOrionTypeId, OrionType>();
        for (OrionType t = type; t != null; t = t.getOrionSuperType()) {
            if (hierarchy.get((Object)t.getOrionTypeId()) != null) {
                throw new OrionException("Cycle detected in type hierarchy for " + this);
            }
            hierarchy.put(t.getOrionTypeId(), t);
        }
    }
}

