/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.HashMap;
import javax.baja.io.BIContextEncodable;
import javax.baja.io.ValueDocEncoder;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.xml.XWriter;

public class OrionOutput {
    private XWriter out;
    private HashMap<BOrionTypeId, OrionType> types = new HashMap();
    private OrionType lastType = null;
    private Context passwordContext = null;
    private boolean isLegacyConnection = false;

    public OrionOutput(OutputStream out, Context passwordContext) throws IOException {
        this.out = new XWriter(out);
        this.passwordContext = passwordContext;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    public void writeIntElem(String elemName, String attrName, int value) throws Exception {
        this.out.w((Object)"<").w((Object)elemName).w((Object)" ").attr(attrName, String.valueOf(value)).w((Object)"></").w((Object)elemName).w((Object)">").nl();
    }

    public void writeObject(BIOrionObject obj) throws Exception {
        if (obj == null) {
            return;
        }
        OrionType type = obj.getOrionType();
        if (type != this.lastType) {
            if (!type.getOrionTypeId().isTemporary() && this.types.get((Object)type.getOrionTypeId()) == null) {
                this.types.put(type.getOrionTypeId(), type);
            }
            this.lastType = type;
            this.writeType(type);
        }
        this.out.w((Object)"<obj ").attr("type", type.getOrionTypeId().encodeToString()).w((Object)">").nl();
        Property[] props = type.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getType() == BRef.TYPE) {
                BRef ref = (BRef)obj.get(props[i]);
                this.out.indent(2).w((Object)"<p ");
                this.out.attr("n", props[i].getName()).w((Object)" ");
                boolean resolved = ref.isResolved();
                this.out.attr("r", resolved ? "true" : "false").w((Object)" ");
                this.out.attr("v", ref.encodeToString());
                if (!resolved) {
                    this.out.w((Object)"/>").nl();
                    continue;
                }
                this.out.w((Object)">").nl();
                this.out.indent(4).w((Object)"<resolved>").nl();
                this.writeObject(ref.getTarget());
                this.out.indent(4).w((Object)"</resolved>").nl();
                this.out.indent(2).w((Object)"</p>").nl();
                continue;
            }
            this.out.indent(2).w((Object)"<p ");
            this.out.attr("n", props[i].getName()).w((Object)" ");
            BValue pval = obj.get(props[i]);
            if (pval instanceof BSimple) {
                if (pval instanceof BIContextEncodable) {
                    if (this.isLegacyConnection()) {
                        BPassword password = (BPassword)pval;
                        this.out.attr("v", LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)password).getValue()), (int)0));
                    } else {
                        this.out.attr("v", ((BIContextEncodable)pval).encodeToString(this.passwordContext));
                    }
                } else {
                    this.out.attr("v", ((BSimple)pval).encodeToString());
                }
            } else {
                this.out.attr("v", ValueDocEncoder.marshal((BValue)pval));
            }
            this.out.w((Object)"/>").nl();
        }
        this.out.w((Object)"</obj>").nl();
    }

    public void writeUpdate(BIOrionObject obj) throws Exception {
        if (obj == null) {
            return;
        }
        OrionType type = obj.getOrionType();
        if (type != this.lastType) {
            if (this.types.get((Object)type.getOrionTypeId()) == null) {
                this.types.put(type.getOrionTypeId(), type);
            }
            this.lastType = type;
            this.writeType(type);
        }
        this.out.w((Object)"<obj ").attr("type", type.getOrionTypeId().encodeToString()).w(' ').attr("update", "true").w((Object)">").nl();
        Property[] props = type.getProperties();
        for (int i = 0; i < props.length; ++i) {
            this.out.indent(2).w((Object)"<p ");
            this.out.attr("n", props[i].getName()).w((Object)" ");
            BSimple simp = (BSimple)obj.get(props[i]);
            if (this.isLegacyConnection()) {
                this.out.attr("v", ((BSimple)obj.get(props[i])).encodeToString());
            } else if (simp instanceof BIContextEncodable) {
                this.out.attr("v", ((BIContextEncodable)simp).encodeToString(this.passwordContext));
            } else {
                this.out.attr("v", ((BSimple)obj.get(props[i])).encodeToString());
            }
            this.out.w((Object)"/>").nl();
        }
        this.out.w((Object)"</obj>").nl();
    }

    public void writeType(OrionType type) throws Exception {
        this.writeType(type, 0);
    }

    public void writeType(OrionType type, int indent) throws Exception {
        Property[] props;
        this.out.indent(indent).w((Object)"<type ");
        this.out.attr("id", type.getOrionTypeId().encodeToString()).w(' ');
        if (type.isAbstract()) {
            this.out.attr("abstract", "true").w(' ');
        }
        if (type.isFinal()) {
            this.out.attr("final", "true").w(' ');
        }
        this.out.w((Object)">").nl();
        BOrionTypeId superId = type.getSuperTypeId();
        if (superId != null) {
            this.writeSuperType(superId, indent + 2);
        }
        if ((props = type.getProperties()).length != 0) {
            this.writeProperty(props, indent + 2);
        }
        this.out.indent(indent).w((Object)"</type>").nl();
    }

    private void writeSuperType(BOrionTypeId superId, int indent) throws Exception {
        this.out.indent(indent).w((Object)"<superType ");
        this.out.attr("id", superId.encodeToString()).w(' ');
        this.out.w((Object)"/>").nl();
    }

    private void writeProperty(Property[] props, int indent) throws Exception {
        for (int i = 0; i < props.length; ++i) {
            this.writeProperty(props[i], indent);
        }
    }

    private void writeProperty(Property prop, int indent) throws Exception {
        if (prop.getType() == BRef.TYPE) {
            this.out.indent(indent).w((Object)"<ref ");
            this.out.attr("name", prop.getName()).w(' ');
            this.out.attr("target", ((BRef)prop.getDefaultValue()).getTargetOrionTypeId().encodeToString()).w(' ');
            this.out.attr("facets", BFacets.makeRemove((BFacets)prop.getFacets(), (String)"inverse").encodeToString()).w(' ');
            this.out.w((Object)">").nl();
            String inverseName = prop.getFacets().gets("inverse", null);
            if (inverseName != null) {
                this.out.indent(indent + 2).w((Object)"<inverse ").attr("name", inverseName).w((Object)"/>").nl();
            }
            this.out.indent(indent).w((Object)"</ref>").nl();
        } else {
            this.out.indent(indent).w((Object)"<property ");
            this.out.attr("name", prop.getName()).w(' ');
            this.out.attr("type", prop.getType().getTypeSpec().encodeToString()).w(' ');
            this.out.attr("facets", prop.getFacets().encodeToString()).w(' ');
            if (prop.getType() == BAbsTime.TYPE) {
                this.out.attr("def", Long.toString(((BAbsTime)prop.getDefaultValue()).getMillis()));
            } else {
                this.out.attr("def", PropertyValue.encodeValueToString(prop.getDefaultValue(), this.passwordContext, this.isLegacyConnection())).w(' ');
            }
            this.out.w((Object)"/>").nl();
        }
    }

    public void setLegacyConnection(boolean legacyConnection) {
        this.isLegacyConnection = legacyConnection;
    }

    public boolean isLegacyConnection() {
        return this.isLegacyConnection;
    }
}

