/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BIFoxProxySpace;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionModule;
import com.tridium.orion.BOrionRoot;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.OrionException;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.orion.priv.fox.FoxDbSpec;
import com.tridium.orion.priv.sys.OrionLoadCallbacks;
import java.util.HashMap;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.space.LoadCallbacks;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"fox:FoxSession"})})
public class BFoxOrionSpace
extends BOrionSpace
implements BIFoxProxySpace {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxOrionSpace.class);
    private BFoxSession foxSession;
    private OrionLoadCallbacks loadCallbacks = new OrionLoadCallbacks();
    private HashMap<BOrd, BOrionDatabase> dbsByAppOrd = new HashMap();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public LoadCallbacks getLoadCallbacks() {
        return this.loadCallbacks;
    }

    public void init(BFoxSession foxSession) throws Exception {
        this.foxSession = foxSession;
        this.setRootComponent(this.getChannel().requestHandler.loadOrionRoot());
    }

    public void cleanup(BFoxSession foxSession) throws Exception {
        this.foxSession = null;
    }

    @Override
    public BOrionDatabase getOrionDatabase(String dbId) {
        BOrionRoot root = (BOrionRoot)this.getRootComponent();
        root.loadSlots();
        return (BOrionDatabase)root.get(dbId);
    }

    @Override
    public BOrionDatabase getOrionDatabase(BRdbms rdbms) {
        return this.getOrionDatabase(rdbms.getName());
    }

    @Override
    public BOrionDatabase getOrionDatabaseForApp(BOrd appOrd) {
        BOrionDatabase db = this.dbsByAppOrd.get(appOrd);
        if (db == null) {
            try {
                String dbId = this.getChannel().requestHandler.getDbForApp(appOrd);
                if (dbId != null) {
                    db = this.getOrionDatabase(dbId);
                }
                if (db != null) {
                    this.dbsByAppOrd.put(appOrd, db);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return db;
    }

    @Override
    public BOrionDatabase getOrionDatabaseForApp(BIOrionApp app) {
        return this.getOrionDatabaseForApp(((BComponent)app).getOrdInSession());
    }

    @Override
    public BOrionDatabase[] getOrionDatabases() throws Exception {
        BOrionChannel channel = this.getChannel();
        FoxDbSpec[] dbIds = channel.requestHandler.getOrionDatabases();
        BOrionDatabase[] dbs = new BFoxOrionDatabase[dbIds.length];
        for (int i = 0; i < dbIds.length; ++i) {
            dbs[i] = new BFoxOrionDatabase(this, dbIds[i]);
        }
        return dbs;
    }

    @Override
    public BOrionModule[] listModules(BOrionDatabase db) {
        BOrionChannel channel = this.getChannel();
        try {
            return channel.requestHandler.listModules((BFoxOrionDatabase)db);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Cannot list modules for " + db.getName(), ex);
        }
    }

    @Override
    public BOrionType[] listTypes(BOrionDatabase db, BOrionModule module) {
        BOrionChannel channel = this.getChannel();
        try {
            return channel.requestHandler.listTypes((BFoxOrionDatabase)db, module);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Cannot list modules for " + db.getName(), ex);
        }
    }

    @Override
    public Transaction newTransaction(Context cx) {
        return new Transaction(this, this.getEncodingContext(cx)){

            public void commit(Context cx) throws Exception {
                BFoxOrionSpace.this.getChannel().circuitHandler.commitSyncBuffer((SyncBuffer)this);
            }
        };
    }

    public BFoxSession getFoxSession() {
        return this.foxSession;
    }

    public synchronized BOrionChannel getChannel() {
        BFoxClientConnection conn = this.getFoxSession().getConnection();
        BOrionChannel channel = (BOrionChannel)conn.getChannels().get("orion", BOrionChannel.TYPE);
        return channel;
    }
}

