/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.priv.audit.BOrionAuditWorker;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.SessionHelper;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.util.BUuid;

public class Insert
extends SessionHelper {
    public Insert(DbOrionSession session) {
        super(session);
    }

    public void insert(BIOrionObject obj) {
        try {
            if (this.conn.isReadOnly()) {
                throw new OrionException("This is a readonly database context.");
            }
            obj.setOrionDatabase(this.db);
            if (obj.beforeInsert(this.session)) {
                this.doInsert(obj);
                obj.clearAllModified();
                ((BObject)obj).fw(702, null, null, null, null);
                if (obj.isAuditable() && this.session.getUser() != null) {
                    BOrionAuditWorker.auditCreated(obj, this.session);
                }
                obj.afterInsert(this.session);
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "VETOED INSERT: " + obj);
            }
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }

    private void doInsert(BIOrionObject obj) throws SQLException {
        switch (this.dialect.getInsertionMode()) {
            case 1: {
                this.createViaIdentity(obj);
                break;
            }
            case 2: {
                this.createViaIdentityLookup(obj);
                break;
            }
            case 0: {
                this.createViaSequence(obj);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void createViaIdentity(BIOrionObject obj) throws SQLException {
        TableDefinition tableDef = TableDefinition.get(this.db, obj.getOrionType());
        ColumnDefinition identCol = tableDef.getIdentityColumn();
        RdbmsPreparedStatement prep = this.session.makeAutoKeyStatement(this.db, this.conn, Insert.buildInsertSql(tableDef, false), identCol == null ? 2 : 1);
        Insert.loadInsertStatement(prep, tableDef, false, obj);
        prep.executeUpdate();
        Insert.retrieveIdentityKeys(prep, identCol, new BIOrionObject[]{obj});
    }

    private void createViaIdentityLookup(BIOrionObject obj) throws SQLException {
        TableDefinition tableDef = TableDefinition.get(this.db, obj.getOrionType());
        ColumnDefinition identCol = tableDef.getIdentityColumn();
        RdbmsPreparedStatement prep = this.session.makeStatement(this.db, this.conn, Insert.buildInsertSql(tableDef, false));
        Insert.loadInsertStatement(prep, tableDef, false, obj);
        prep.executeUpdate();
        Insert.retrieveIdentityLookupKeys(this.dialect, this.conn, identCol, new BIOrionObject[]{obj});
    }

    private void createViaSequence(BIOrionObject obj) throws SQLException {
        TableDefinition tableDef = TableDefinition.get(this.db, obj.getOrionType());
        ColumnDefinition identCol = tableDef.getIdentityColumn();
        RdbmsPreparedStatement prep = this.session.makeStatement(this.db, this.conn, Insert.buildInsertSql(tableDef, true));
        Insert.lookupSequenceKey(this.dialect, this.conn, tableDef, identCol, obj);
        Insert.loadInsertStatement(prep, tableDef, true, obj);
        prep.executeUpdate();
    }

    public static void retrieveIdentityKeys(RdbmsPreparedStatement prep, ColumnDefinition identCol, BIOrionObject[] objs) throws SQLException {
        if (identCol != null) {
            RdbmsResultSet genKey = new RdbmsResultSet(prep.getGeneratedKeys());
            Property identProp = identCol.getProperty();
            genKey.next();
            for (int i = 0; i < objs.length; ++i) {
                objs[i].set(identProp, identCol.getTranslator().getResultSetValue(genKey, 1, (Context)identProp.getFacets()));
                genKey.next();
            }
        }
    }

    public static void retrieveIdentityLookupKeys(RdbmsDialect dialect, Connection conn, ColumnDefinition identCol, BIOrionObject[] objs) throws SQLException {
        if (identCol != null) {
            RdbmsResultSet genKey = null;
            try (Statement statement = conn.createStatement();){
                genKey = new RdbmsResultSet(statement.executeQuery(dialect.getIdentityLookup()));
                Property identProp = identCol.getProperty();
                genKey.next();
                for (int i = 0; i < objs.length; ++i) {
                    objs[i].set(identProp, identCol.getTranslator().getResultSetValue(genKey, 1, (Context)identProp.getFacets()));
                    genKey.next();
                }
            }
        }
    }

    public static void lookupSequenceKey(RdbmsDialect dialect, Connection conn, TableDefinition tableDef, ColumnDefinition identCol, BIOrionObject obj) throws SQLException {
        if (identCol != null) {
            RdbmsResultSet genKey = null;
            try (Statement statement = conn.createStatement();){
                genKey = new RdbmsResultSet(statement.executeQuery(dialect.getSequenceLookup(tableDef.getTableName())));
                Property identProp = identCol.getProperty();
                genKey.next();
                obj.set(identProp, identCol.getTranslator().getResultSetValue(genKey, 1, (Context)identProp.getFacets()));
            }
        }
    }

    public static String buildInsertSql(TableDefinition tableDef, boolean includeIdentity) {
        ColumnDefinition[] columns = tableDef.getColumns();
        Array fields = new Array(String.class);
        Array values = new Array(String.class);
        for (int i = 0; i < columns.length; ++i) {
            ColumnDefinition col = columns[i];
            Property prop = columns[i].getProperty();
            if (BOrionObject.isIdentity(prop) && !includeIdentity) continue;
            fields.add((Object)col.getColumnName());
            values.add((Object)"?");
        }
        return "INSERT INTO " + tableDef.getTableName() + " (" + TextUtil.join((String[])((String[])fields.trim()), (char)',') + ") VALUES (" + TextUtil.join((String[])((String[])values.trim()), (char)',') + ")";
    }

    public static void loadInsertStatement(RdbmsPreparedStatement prep, TableDefinition tableDef, boolean includeIdentity, BIOrionObject obj) {
        int n = 1;
        ColumnDefinition[] columns = tableDef.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            ColumnDefinition col = columns[i];
            Property prop = columns[i].getProperty();
            BValue value = obj.get(columns[i].getProperty());
            if (BOrionObject.isKey(prop) && value.equals((Object)BUuid.NULL)) {
                value = BUuid.make();
                obj.set(columns[i].getProperty(), value);
            }
            if (BOrionObject.isIdentity(prop) && !includeIdentity) continue;
            columns[i].getTranslator().setPreparedStatementValue(prep, n++, value, (Context)prop.getFacets());
        }
    }
}

