/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.audit.BOrionAuditWorker;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.SessionHelper;
import com.tridium.orion.priv.db.sql.SqlHelper;
import com.tridium.orion.priv.db.sql.SqlVisitor;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.baja.query.BExpression;
import javax.baja.query.BExtent;
import javax.baja.query.BQuery;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Type;

public class Delete
extends SessionHelper {
    public Delete(DbOrionSession session) {
        super(session);
    }

    public boolean delete(BIOrionObject obj) {
        if (obj.beforeDelete(this.session)) {
            int rowCount = this.doDelete((OrionType)obj.getType(), PropertyValue.makeKeys(obj));
            if (rowCount < 0 || rowCount > 1) {
                throw new OrionException("Unexpected row count during deletion: " + rowCount);
            }
            if (obj.isAuditable() && this.session.getUser() != null) {
                BOrionAuditWorker.auditDeleted(obj, this.session);
            }
            obj.afterDelete(this.session);
            return rowCount == 1;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "VETOED DELETE: " + obj);
        }
        return false;
    }

    public int delete(OrionType type, BExpression condition) {
        BSqlQuery delete = new BSqlQuery();
        delete.from((BExtent)BSqlExtent.make((Type)type));
        if (condition != null) {
            delete.where(condition);
        }
        DeleteVisitor dv = new DeleteVisitor(this.db);
        dv.visit(delete);
        this.logBQuery(dv);
        return this.updateOrDelete("DELETE", dv.getQueryString(), dv.getParameters());
    }

    private int doDelete(OrionType type, PropertyValue[] propValues) {
        TableDefinition tableDef = TableDefinition.get(this.db, type);
        String sql = Delete.buildDeleteSql(tableDef, type, propValues);
        try {
            RdbmsPreparedStatement prep = this.session.makeStatement(this.db, this.conn, sql.toString());
            Delete.loadDeleteStatement(prep, tableDef, type, propValues);
            return prep.executeUpdate();
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }

    public static String buildDeleteSql(TableDefinition tableDef, OrionType type, PropertyValue[] propValues) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(tableDef.getTableName()).append(" WHERE ");
        for (int i = 0; i < propValues.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append("(");
            sql.append(propValues[i].getProperty().getName());
            sql.append(" = ?)");
        }
        return sql.toString();
    }

    public static void loadDeleteStatement(RdbmsPreparedStatement prep, TableDefinition tableDef, OrionType type, PropertyValue[] propValues) {
        for (int i = 0; i < propValues.length; ++i) {
            Property prop = propValues[i].getProperty();
            ColumnDefinition colDef = tableDef.getColumn(prop.getName());
            colDef.getTranslator().setPreparedStatementValue(prep, i + 1, propValues[i].getValue(), (Context)prop.getFacets());
        }
    }

    public static class DeleteVisitor
    extends SqlVisitor {
        public DeleteVisitor(BLocalOrionDatabase db) {
            super(db);
        }

        public void visit(BQuery delete) {
            this.initialize();
            this.helper = new SqlHelper(this.db, delete);
            this.queryText.append("DELETE FROM ");
            this.visit(delete.getExtent());
            if (delete.hasPredicate()) {
                this.queryText.append("WHERE ");
                this.visit(delete.getPredicate());
            }
        }
    }
}

