/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.Fetch;
import com.tridium.orion.priv.db.sql.SelectVisitor;
import com.tridium.orion.sql.BJoin;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BQueryNode;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.util.Columns;
import javax.baja.sys.Property;

public class AutoResolveVisitor
extends SelectVisitor {
    private static final String arPrefix = "ar";
    private int arIndex;
    protected Fetch fetcher;
    protected Array<BSqlJoin> autoResolvedJoins;

    public AutoResolveVisitor(BLocalOrionDatabase db, Fetch fetcher) {
        this(db);
        this.fetcher = fetcher;
    }

    protected AutoResolveVisitor(BLocalOrionDatabase db) {
        super(db);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.autoResolvedJoins = new Array(BSqlJoin.class);
        this.arIndex = 0;
    }

    @Override
    public void visit(BFieldExpression node) {
        super.visit(node);
        if (this.inProjectionColumn((BQueryNode)node)) {
            ArTableDefinition exprTable = this.getTableDefForExpr(node);
            Property p = this.helper.getFieldProperty(node);
            if (!BOrionObject.isAutoResolve(p)) {
                return;
            }
            BSqlField sourceFK = new BSqlField(exprTable.getOrionType(), p).alias(exprTable.getTableAlias());
            ArTableDefinition refTbl = new ArTableDefinition(this.fetcher.getRefTableDef((BRef)p.getDefaultValue()));
            this.doAutoResolve(sourceFK, refTbl);
        }
    }

    protected void doAutoResolve(BSqlField sourceFK, ArTableDefinition refDef) {
        ColumnDefinition refKey = refDef.getKeyColumn();
        BSqlField refField = new BSqlField(refDef.getOrionType(), refKey.getProperty());
        String refAlias = null;
        ++this.arIndex;
        refAlias = arPrefix + this.arIndex;
        refField.alias(refAlias);
        refDef.setTableAlias(refAlias);
        BSqlJoin autoJoin = new BSqlJoin(BJoin.leftOuterJoin, (BSqlField)sourceFK.newCopy(), refField);
        this.autoResolvedJoins.add((Object)autoJoin);
        ColumnDefinition[] cols = refDef.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            this.queryText.append(", ");
            this.queryText.append(refDef.getTableAlias()).append('.').append(cols[i].getColumnName());
            if (this.query.hasGrouping()) {
                BSqlField groupField = new BSqlField(refDef.getOrionType(), cols[i].getColumnName());
                groupField.alias(refDef.getTableAlias());
                this.query.getGrouping().add(Columns.groupBy((BExpression)groupField));
            }
            if (!cols[i].isAutoResolve()) continue;
            BSqlField newSourceFK = new BSqlField(refDef.getOrionType(), cols[i].getProperty()).alias(refDef.getTableAlias());
            ArTableDefinition targetDef = new ArTableDefinition(this.fetcher.getRefTableDef(cols[i]));
            this.doAutoResolve(newSourceFK, targetDef);
        }
    }

    @Override
    public void visit(BSqlJoin[] inner) {
        super.visit(inner);
        BSqlJoin[] autoJoins = (BSqlJoin[])this.autoResolvedJoins.trim();
        for (int i = 0; i < autoJoins.length; ++i) {
            this.visit(autoJoins[i]);
        }
    }

    protected ArTableDefinition getTableDefForExpr(BFieldExpression expr) {
        String alias = this.helper.nodeToAlias.get(expr);
        return expr instanceof BSqlField ? new ArTableDefinition(TableDefinition.get(this.db, ((BSqlField)expr).getExtentType()), alias) : new ArTableDefinition(TableDefinition.get(this.db, this.getExtentType()), alias);
    }

    public class ArTableDefinition {
        private TableDefinition td;
        private String tableAlias = null;

        public ArTableDefinition(TableDefinition toWrap) {
            this(toWrap, "");
        }

        public ArTableDefinition(TableDefinition toWrap, String tblAlias) {
            this.td = toWrap;
            this.tableAlias = tblAlias;
        }

        public String getTableName() {
            return this.td.getTableName();
        }

        public OrionType getOrionType() {
            return this.td.getOrionType();
        }

        public ColumnDefinition[] getKeyColumns() {
            return this.td.getKeyColumns();
        }

        public ColumnDefinition getKeyColumn() {
            return this.td.getKeyColumn();
        }

        public ColumnDefinition getIdentityColumn() {
            return this.td.getIdentityColumn();
        }

        public ColumnDefinition[] getColumns() {
            return this.td.getColumns();
        }

        public ColumnDefinition getColumn(String name) {
            return this.td.getColumn(name);
        }

        public String getTableAlias() {
            return this.tableAlias.equals("") ? null : this.tableAlias;
        }

        public void setTableAlias(String alias) {
            this.tableAlias = alias;
        }

        public boolean hasTableAlias() {
            return this.getTableAlias() != null;
        }
    }
}

