/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.trans.TranslatorFactory;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import java.util.HashMap;
import java.util.Map;
import javax.baja.nre.util.Array;
import javax.baja.sys.Property;

public class TableDefinition {
    private BOrionDatabase db;
    private OrionType type;
    private RdbmsDialect dialect;
    private BIOrionObject instance;
    private String tableName;
    private ColumnDefinition[] columns;
    private ColumnDefinition[] keyColumns;
    private ColumnDefinition identCol;
    private Map<String, ColumnDefinition> colsByName = new HashMap<String, ColumnDefinition>();

    public TableDefinition(BOrionDatabase db, OrionType type) {
        int i;
        this.db = db;
        this.type = type;
        this.dialect = (RdbmsDialect)db.getRdbms().getRdbmsContext();
        this.instance = (BIOrionObject)type.getInstance();
        Property[] props = type.getPersistentProperties();
        Array arr = new Array(ColumnDefinition.class);
        Array keys = new Array(ColumnDefinition.class);
        for (i = 0; i < props.length; ++i) {
            if ((props[i].getDefaultFlags() & 2) != 0) {
                throw new IllegalStateException();
            }
            BColumnTranslator t = TranslatorFactory.make(this.dialect, this.instance.get(props[i]));
            ColumnDefinition col = new ColumnDefinition(db, type, props[i], t);
            arr.add((Object)col);
            if (BOrionObject.isKey(props[i])) {
                keys.add((Object)col);
            }
            this.colsByName.put(col.getColumnName(), col);
        }
        this.columns = (ColumnDefinition[])arr.trim();
        this.keyColumns = (ColumnDefinition[])keys.trim();
        this.identCol = null;
        for (i = 0; i < this.columns.length; ++i) {
            if (!BOrionObject.isIdentity(this.columns[i].getProperty())) continue;
            if (this.identCol == null) {
                this.identCol = this.columns[i];
                continue;
            }
            throw new OrionException("Only one identity column per table is allowed: " + this.columns[i].getColumnName());
        }
    }

    public ColumnDefinition getIdentityColumn() {
        return this.identCol;
    }

    public ColumnDefinition[] getColumns() {
        return this.columns;
    }

    public ColumnDefinition[] getKeyColumns() {
        return this.keyColumns;
    }

    public ColumnDefinition getKeyColumn() {
        if (this.keyColumns == null || this.keyColumns.length == 0) {
            throw new OrionException("No keys found for target " + this.type);
        }
        if (this.keyColumns.length > 1) {
            throw new OrionException("More than one key found for target " + this.type);
        }
        return this.keyColumns[0];
    }

    public ColumnDefinition getColumn(String name) {
        return this.colsByName.get(name);
    }

    public BIOrionObject getInstance() {
        return (BIOrionObject)this.type.getInstance();
    }

    public OrionType getOrionType() {
        return this.type;
    }

    public String getTableName() {
        if (this.tableName == null) {
            this.tableName = this.db.getTableName(this.type);
        }
        return this.tableName;
    }

    public static OrionType getRefType(BOrionDatabase db, BRef ref) {
        BOrionTypeId targetTypeId = ref.getTargetOrionTypeId();
        return db.getType(targetTypeId);
    }

    public static TableDefinition get(BOrionDatabase db, OrionType type) {
        return (TableDefinition)db.fw(701, type, null, null, null);
    }
}

