/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.Fetch;
import com.tridium.orion.priv.db.trans.TranslatorFactory;
import com.tridium.orion.priv.util.CursorUtil;
import com.tridium.orion.priv.util.OrionCursorManager;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import java.sql.ResultSet;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class DbCursor
implements OrionCursor {
    private static OrionCursorManager cursorManager = new OrionCursorManager();
    protected TableDefinition tableDef;
    private DbOrionSession session;
    private BLocalOrionDatabase db;
    private RdbmsDialect dialect;
    private OrionType type;
    private RdbmsResultSet dbRs;
    private Fetch fetcher;
    private boolean isRawSql;
    private boolean adminRequired = false;

    public DbCursor(DbOrionSession session, OrionType type, ResultSet rs, boolean adminRequired) {
        this(session, type, rs, false, adminRequired);
    }

    public DbCursor(DbOrionSession session, OrionType type, ResultSet rs, boolean isRawSql, boolean adminRequired) {
        this.session = session;
        this.db = (BLocalOrionDatabase)session.getDb();
        this.dialect = (RdbmsDialect)this.db.getRdbms().getRdbmsContext();
        this.type = type;
        this.dbRs = new RdbmsResultSet(rs);
        this.fetcher = new Fetch(session);
        this.isRawSql = isRawSql;
        this.adminRequired = adminRequired;
        this.tableDef = (TableDefinition)this.db.fw(701, type, null, null, null);
        cursorManager.openSpy(this);
    }

    @Override
    public OrionSession getSession() {
        return this.session;
    }

    @Override
    public OrionType getOrionType() {
        return this.type;
    }

    @Override
    public BIOrionObject[] toArray() {
        return CursorUtil.toArray(this);
    }

    public void close() {
        this.dbRs.close();
        cursorManager.closeSpy(this);
    }

    public Context getContext() {
        return this.session;
    }

    public boolean next() {
        boolean checkPermissions;
        boolean bl = checkPermissions = this.getContext().getUser() != null;
        if (!checkPermissions) {
            return this.dbRs.next();
        }
        while (this.dbRs.next()) {
            BPermissions p = this.getPermissionsFor((BIOrionObject)this.get());
            if (!(this.adminRequired ? p.hasAdminRead() : p.hasOperatorRead())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextComponent() {
        while (this.next()) {
            if (!this.get().isComponent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean next(Class<?> cls) {
        while (this.next()) {
            if (!cls.isInstance(this.get())) continue;
            return true;
        }
        return false;
    }

    public BObject get() {
        BIOrionObject obj = (BIOrionObject)this.type.getInstance();
        if (this.tableDef == null) {
            Property[] props = this.type.getProperties();
            for (int i = 0; i < props.length; ++i) {
                Property prop = props[i];
                BColumnTranslator trans = TranslatorFactory.make(this.dialect, prop.getDefaultValue());
                if (this.dbRs.isNull(i + 1)) {
                    ((BObject)obj).fw(704, (Object)prop, (Object)Boolean.TRUE, null, null);
                    obj.set(prop, prop.getDefaultValue());
                    continue;
                }
                obj.set(prop, trans.getResultSetValue(this.dbRs, i + 1, (Context)prop.getFacets()));
            }
            obj.clearAllModified();
        } else {
            this.fetcher.setPropertyValues(this.tableDef, obj, this.dbRs, this.isRawSql);
        }
        obj.setOrionDatabase(this.db);
        ((BObject)obj).fw(702, null, null, null, null);
        return (BObject)obj;
    }

    public BPermissions getPermissionsFor(BIOrionObject o) {
        if (o instanceof BIProtected) {
            return o.getPermissions(this.session);
        }
        return BPermissions.all;
    }

    public boolean canRead(BIOrionObject o) {
        return this.getPermissionsFor(o).hasOperatorRead();
    }

    public boolean canWrite(BIOrionObject o) {
        return this.getPermissionsFor(o).hasOperatorWrite();
    }

    public ResultSet getUnderylingResultSet() {
        return this.dbRs.getResultSet();
    }
}

