/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionSession;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OrionAppSchemaManager {
    protected ISchemaUpgrader[] upgraders;
    protected BIOrionApp app;
    public static Logger log = Logger.getLogger("orion");

    public OrionAppSchemaManager(BIOrionApp app, ISchemaUpgrader[] upgraders) {
        this.app = app;
        this.upgraders = upgraders;
    }

    public void performSchemaUpgrade(BLocalOrionDatabase db, BSchemaVersion oldVersion) throws Exception {
        BSchemaVersion currentVersion = oldVersion;
        ISchemaUpgrader bestUpgrader = null;
        try (OrionSession session = db.createSession(null);){
            session.setAutoCommit(false);
            while (true) {
                for (int i = 0; i < this.upgraders.length; ++i) {
                    if (!this.upgraders[i].getFromVersion().equals((Object)currentVersion) || this.upgraders[i].getFromVersion().equals((Object)this.upgraders[i].getToVersion()) || bestUpgrader != null && this.upgraders[i].getToVersion().compareTo((Object)bestUpgrader.getToVersion()) <= 0) continue;
                    bestUpgrader = this.upgraders[i];
                }
                if (bestUpgrader == null) break;
                log.log(Level.INFO, "Converting Orion Application " + this.app.toString(null) + " from version " + (Object)((Object)bestUpgrader.getFromVersion()) + " to " + (Object)((Object)bestUpgrader.getToVersion()));
                bestUpgrader.upgrade(db, this.app, session);
                currentVersion = bestUpgrader.getToVersion();
                bestUpgrader = null;
            }
            if (!currentVersion.equals((Object)this.app.getSchemaVersion())) {
                throw new IllegalStateException("No support available for upgrading Orion Appplication " + this.app.toString(null) + " from version " + (Object)((Object)currentVersion) + " to " + (Object)((Object)this.app.getSchemaVersion()));
            }
            session.commit();
        }
    }
}

