/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionDatabaseObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="dbOrd", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(BFacets.TARGET_TYPE, \"rdb:Rdbms\")")})
public abstract class BAbstractOrionApp
extends BAbstractService
implements BIOrionApp,
BIOrionDatabaseObject {
    @Generated
    public static final Property dbOrd = BAbstractOrionApp.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"rdb:Rdbms"));
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractOrionApp.class);

    @Generated
    public BOrd getDbOrd() {
        return (BOrd)this.get(dbOrd);
    }

    @Generated
    public void setDbOrd(BOrd v) {
        this.set(dbOrd, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void checkConfig() {
        if (this.getDbOrd().isNull()) {
            this.configFatal("Database ORD not configured.");
            return;
        }
        BRdbms rdbms = null;
        try {
            rdbms = (BRdbms)this.getDbOrd().resolve((BObject)this).get();
        }
        catch (Exception ex) {
            this.configFatal("Database ORD not configured properly.");
            ex.printStackTrace();
        }
    }

    public void serviceStarted() {
        this.checkConfig();
        if (!this.getStatus().isFault()) {
            this.registerApp();
        }
    }

    public void registerApp() {
        BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BRdbms rdbms = this.getRdbms();
        ((BLocalOrionDatabase)service.getOrionDatabase(rdbms)).registerApp(this);
    }

    public BRdbms getRdbms() {
        if (this.getDbOrd().isNull()) {
            throw new OrionException("Database ORD not configured.");
        }
        return (BRdbms)this.getDbOrd().resolve((BObject)this).get();
    }

    @Override
    public BOrionDatabase getOrionDatabase() {
        BRdbms rdbms = this.getRdbms();
        BOrionSpace orionSpace = (BOrionSpace)BOrd.make((String)"orion:").resolve((BObject)this).get();
        return orionSpace.getOrionDatabase(rdbms);
    }

    public OrionSession createSession(Context cx) {
        return this.getOrionDatabase().createSession(cx);
    }

    @Override
    public void orionReady(BOrionDatabase db) {
    }

    public void changed(Property property, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(dbOrd) && Sys.getStation().isRunning()) {
            this.configFatal("Database ORD changed, restart required.");
        }
    }
}

