/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.util.SnmpUtil;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

@NiagaraType
public class BMibListDialog
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BMibListDialog.class);
    static Lexicon lex = Lexicon.make(BMibListDialog.class);
    BList mibs;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMibListDialog() {
    }

    public BMibListDialog(String[] init) {
        this.mibs = new BList();
        for (int i = 0; i < init.length; ++i) {
            this.mibs.addItem((Object)init[i]);
        }
        AddMib addMib = new AddMib((BWidget)this);
        RemoveMib removeMib = new RemoveMib((BWidget)this);
        BGridPane actions = new BGridPane();
        actions.setColumnAlign(BHalign.fill);
        actions.setUniformColumnWidth(true);
        actions.add(null, (BValue)new BButton((Command)addMib));
        actions.add(null, (BValue)new BButton((Command)removeMib));
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.mibs));
        pane.setBottom((BWidget)new BBorderPane((BWidget)actions));
        this.setCenter((BWidget)new BBorderPane((BWidget)pane));
    }

    public void computePreferredSize() {
        int pw = Math.max((int)this.getPreferredWidth(), 300);
        int ph = Math.max((int)this.getPreferredHeight(), 200);
        this.setPreferredSize(pw, ph);
    }

    public String[] getMibPaths() {
        int count = this.mibs.getItemCount();
        String[] mibPaths = new String[count];
        for (int i = 0; i < count; ++i) {
            mibPaths[i] = (String)this.mibs.getItem(i);
        }
        return mibPaths;
    }

    class RemoveMib
    extends Command {
        RemoveMib(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("action.remove"), BImage.make((String)"module://icons/x16/delete.png"), null, null);
        }

        public CommandArtifact doInvoke() {
            BMibListDialog.this.mibs.removeSelectedItems();
            return null;
        }
    }

    class AddMib
    extends Command {
        AddMib(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("action.add"), BImage.make((String)"module://icons/x16/add.png"), null, null);
        }

        public CommandArtifact doInvoke() {
            BDirectoryChooser fileChooser = BDirectoryChooser.make((BWidget)this.getOwner());
            fileChooser.setTitle(lex.getText("mibPathDialog.addDirectory"));
            BOrd file = fileChooser.show();
            if (file == null) {
                return null;
            }
            try {
                BMibListDialog.this.mibs.addItem((Object)SnmpUtil.ordToAbsolutePath((BOrd)file));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

