/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.platCrypto.certs;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.baja.file.BAbstractFile;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Certificate;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPassword;
import javax.baja.sys.BInterface;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public interface BICertificateFormatHandler
extends BInterface {
    @Generated
    public static final Type TYPE = Sys.loadType(BICertificateFormatHandler.class);

    default public void writeCertToFile(IX509Certificate[] certChain, BAbstractFile certFile) throws IOException {
        X509Certificate[] x509Chain = new X509Certificate[certChain.length];
        for (int i = 0; i < certChain.length; ++i) {
            x509Chain[i] = certChain[i].getCertificate();
        }
        this.writeCertToFile(x509Chain, certFile);
    }

    public void writeCertToFile(X509Certificate[] var1, BAbstractFile var2) throws IOException;

    public void writeKeyToFile(PrivateKey var1, boolean var2, BPassword var3, BAbstractFile var4) throws IOException;

    public void writeCertAndKeyToFile(PrivateKey var1, boolean var2, BPassword var3, X509Certificate[] var4, BAbstractFile var5) throws IOException;

    default public String writeCert(X509Certificate[] certChain) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public String writeKey(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public String writeCertAndKey(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey, X509Certificate[] certChain) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getMimeType();

    public Set<String> getSupportedFileExtensions();

    public String getDefaultFileExtension();

    public String getCertificateFormatName(Context var1);

    public String getCertificateFormatFileTypeName(Context var1);

    public boolean supportsPrivateKey();

    public static Set<BICertificateFormatHandler> getCertificateFormatHandlers() {
        return CertificateFormatHandlerHolder.INSTANCE;
    }

    public static BICertificateFormatHandler getHandlerFromFormatName(String formatName, Context cx) {
        for (BICertificateFormatHandler handler : CertificateFormatHandlerHolder.INSTANCE) {
            if (!handler.getCertificateFormatName(cx).equals(formatName)) continue;
            return handler;
        }
        return null;
    }

    public static final class CertificateFormatHandlerHolder {
        static final Set<BICertificateFormatHandler> INSTANCE;

        static {
            TypeInfo[] certFormatHandlerTypes;
            INSTANCE = new HashSet<BICertificateFormatHandler>();
            for (TypeInfo certFormatHandlerType : certFormatHandlerTypes = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo())) {
                INSTANCE.add((BICertificateFormatHandler)certFormatHandlerType.getInstance());
            }
        }
    }
}

