/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.util;

import com.tridium.crypto.core.cert.CertValidationResult;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.TridiumCertValidator;
import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.platcrypto.core.IExtCryptoManager;
import com.tridium.util.BSessionInfo;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

@NiagaraType
public class BSslSessionInfo
extends BSessionInfo {
    @Generated
    public static final Type TYPE = Sys.loadType(BSslSessionInfo.class);
    private static final Logger LOG = Logger.getLogger("platCrypto");
    private static final Lexicon LEX = Lexicon.make((String)"platCrypto");
    private NX509Certificate cert = null;
    private String protocol = null;
    private String cipherSuite = null;
    private boolean hostnameVerified = false;
    private boolean validCertChain = false;
    private boolean certExpired = false;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BSessionInfo make(String name, BAbsTime connected, Socket socket, String username, String hostname, boolean isFips) {
        return new BSslSessionInfo(name, connected, socket, username, hostname, isFips);
    }

    public BSslSessionInfo() {
    }

    public BSslSessionInfo(String name, BAbsTime connected, Socket socket, String username, String suppliedHostName, boolean isFips) {
        super(name, connected, username, suppliedHostName, isFips);
        SSLSocket sslSocket = (SSLSocket)socket;
        SSLSession session = sslSocket.getSession();
        if (session != null) {
            this.cipherSuite = session.getCipherSuite();
            this.protocol = session.getProtocol();
            try {
                Certificate[] certs = session.getPeerCertificates();
                if (certs != null && certs.length > 0 && certs[0] instanceof X509Certificate) {
                    this.cert = NX509Certificate.make((X509Certificate)((X509Certificate)certs[0]));
                }
                X509Certificate[] x509Certs = (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
                IExtCryptoManager mgr = (IExtCryptoManager)CertManagerFactory.getInstance();
                String peerHostName = session.getPeerHost();
                String host = session.getPeerHost() + ':' + session.getPeerPort();
                CertValidationResult suppliedResult = TridiumCertValidator.validateCertificate((ICoreCryptoManager)mgr.getCoreCryptoManager(), (X509Certificate[])x509Certs, (String)suppliedHostName, (String)host);
                CertValidationResult peerResult = TridiumCertValidator.validateCertificate((ICoreCryptoManager)mgr.getCoreCryptoManager(), (X509Certificate[])x509Certs, (String)peerHostName, (String)host);
                this.hostnameVerified = peerResult.isHostnameVerified() || suppliedResult.isHostnameVerified();
                this.validCertChain = peerResult.isValidCertChain() || suppliedResult.isValidCertChain();
                this.certExpired = peerResult.isCertExpired() || suppliedResult.isCertExpired();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Exception occurred building SslSessionInfo object", e);
            }
        }
    }

    public BIcon getIdentityVerifiedIcon() {
        if (!this.hostnameVerified || !this.validCertChain || this.certExpired) {
            return BIcon.make((String)LEX.getText("session.info.identityVerified.failed.icon"));
        }
        return BIcon.make((String)LEX.getText("session.info.identityVerified.succeeded.icon"));
    }

    public String getIdentityVerifiedMessage() {
        if (!this.hostnameVerified || !this.validCertChain || this.certExpired) {
            StringBuilder buf = new StringBuilder(LEX.getText("session.info.identityVerified.failed.title")).append("\n");
            if (!this.hostnameVerified) {
                buf.append(" - " + LEX.getText("session.info.identityVerified.failed.hostnameMismatch")).append("\n");
            }
            if (!this.validCertChain) {
                buf.append(" - " + LEX.getText("session.info.identityVerified.failed.certValidation")).append("\n");
            }
            if (this.certExpired) {
                buf.append(" - " + LEX.getText("session.info.identityVerified.failed.certExpired")).append("\n");
            }
            return buf.toString();
        }
        return LEX.getText("session.info.identityVerified.succeeded", new Object[]{this.cert.getIssuer()});
    }

    public BIcon getSessionEncryptedIcon() {
        return BIcon.make((String)LEX.getText("session.info.sessionEncrypted.icon"));
    }

    public String getSessionEncryptedMessage() {
        return LEX.getText("session.info.sessionEncrypted", new Object[]{this.name, CryptoSupport.getEncryptionBits((String)this.cipherSuite) + "", this.protocol, CryptoSupport.getEncryptionCipher((String)this.cipherSuite), CryptoSupport.getMessageAuthCipher((String)this.cipherSuite), CryptoSupport.getKeyExchangeCipher((String)this.cipherSuite)});
    }

    public String getProtocol() {
        return this.protocol;
    }

    public NX509Certificate getCertificate() {
        return this.cert;
    }

    public String toString(Context context) {
        return "SslSessionInfo: cert=" + (this.cert == null ? "null" : this.cert.getSubject()) + ", protocol=" + this.protocol + ", cipherSuite=" + this.cipherSuite + ", hostnameVerified=" + this.hostnameVerified + ", validCertChain=" + this.validCertChain + ", certExpired=" + this.certExpired;
    }
}

