/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.platcrypto.signing.BCertificateParameter;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;

public interface IRequesterComponent {
    public static final Permission SIGNING_SERVICE_PERMISSION = new NiagaraBasicPermission("SIGNING_SERVICE");
    public static final BCertificateParameter[] NO_PARAMETERS = new BCertificateParameter[0];

    public BCertificateAliasAndPassword getCertificateAliasAndPassword();

    default public String getCertAlias() {
        return this.getCertificateAliasAndPassword().getAlias();
    }

    default public Optional<BPassword> getCertificatePassword() {
        IRequesterComponent.checkSigningServicePermission();
        BPassword password = this.supplyCertificatePassword();
        boolean undefined = password == null || !this.getCertificateAliasAndPassword().isPasswordSet() || password.getValue().isEmpty();
        return undefined ? Optional.empty() : Optional.of(password);
    }

    public BPassword supplyCertificatePassword();

    default public boolean requiresCertificateParameterTemplates() {
        return false;
    }

    default public BCertificateParameter[] getCertificateParameters() {
        return NO_PARAMETERS;
    }

    public void certificateSigned(X509Certificate[] var1);

    public static void checkSigningServicePermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SIGNING_SERVICE_PERMISSION);
        }
    }

    default public boolean allowExistingCertReplacement() {
        return false;
    }
}

