/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BRequesterState;
import com.tridium.platcrypto.signing.BaseSigningRequesterTask;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;

class GetSigningResult
extends BaseSigningRequesterTask {
    private final boolean renewal;
    private int attempts;

    public GetSigningResult(BAbstractSigningRequester requester, boolean renewal, Context cx) {
        super(requester, cx);
        this.renewal = renewal;
    }

    @Override
    public void execute() throws Exception {
        BAbstractSigningRequester requester = this.getSigningRequester();
        ++this.attempts;
        if (BAbstractSigningRequester.LOG.isLoggable(Level.FINEST)) {
            BAbstractSigningRequester.LOG.finest("GetSigningResults attempt " + this.attempts + " of " + requester.getMaxSigningResultsCheckAttempts());
        }
        try {
            X509Certificate[] certificateChain = AccessController.doPrivileged(() -> requester.getCertificateSigningResult(this.renewal));
            if (certificateChain == null) {
                if (this.attempts < requester.getMaxSigningResultsCheckAttempts()) {
                    this.scheduleNextTask(this, requester.getSigningCheckCheckRetryDelay(), TimeUnit.MILLISECONDS);
                } else if (this.renewal) {
                    requester.fail(BAbstractSigningRequester.LEX.getText("signingRequester.timedOutWaitingForSigningResults"), null, false);
                    requester.setRequesterState(BRequesterState.renewalFailed);
                    requester.scheduleRenewalCheck(BAbsTime.now().add(requester.getRetryPeriod()));
                } else {
                    requester.fail(BAbstractSigningRequester.LEX.getText("signingRequester.timedOutWaitingForSigningResults"), null, true);
                    BAbstractSigningRequester.LOG.warning("Failed to retrieve certificate signing result. Resetting requester state to notOnboarded.");
                    requester.setRequesterState(BRequesterState.notOnboarded);
                }
            } else {
                GetSigningResult.storeSuccessfulSignedCertificate(requester, certificateChain, this.renewal);
            }
        }
        catch (Exception e) {
            if (this.renewal) {
                requester.setRequesterState(BRequesterState.renewalFailed);
                requester.scheduleRenewalCheck(BAbsTime.now().add(requester.getRetryPeriod()));
            } else {
                BAbstractSigningRequester.LOG.warning("Failed to retrieve certificate signing result. Resetting requester state to notOnboarded.");
                requester.setRequesterState(BRequesterState.notOnboarded);
            }
            throw e;
        }
    }

    static void storeSuccessfulSignedCertificate(BAbstractSigningRequester requester, X509Certificate[] certificateChain, boolean renewal) throws Exception {
        AccessController.doPrivileged(() -> {
            requester.storeSignedCertificate(certificateChain, renewal);
            return null;
        });
        requester.setRequesterState(BRequesterState.onboarded);
        AccessController.doPrivileged(() -> {
            requester.getRequesterComponent().certificateSigned(certificateChain);
            return null;
        });
        requester.success();
        if (BAbstractSigningRequester.LOG.isLoggable(Level.FINE)) {
            BAbstractSigningRequester.LOG.fine("Stored certificate for " + requester.getRequesterComponent().getCertAlias());
        }
        requester.scheduleRenewalCheck();
    }
}

