/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BApprovalState;
import com.tridium.platcrypto.signing.BRequesterState;
import com.tridium.platcrypto.signing.BaseSigningRequesterTask;
import com.tridium.platcrypto.signing.GenerateCertificateAndSubmitCsr;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.baja.sys.Context;

class CheckOnboardingApproval
extends BaseSigningRequesterTask {
    private int attempts;

    CheckOnboardingApproval(BAbstractSigningRequester requester, Context cx) {
        super(requester, cx);
    }

    @Override
    public boolean isOnboardingTaskOnly() {
        return true;
    }

    @Override
    public void execute() throws Exception {
        BAbstractSigningRequester requester = this.getSigningRequester();
        try {
            ++this.attempts;
            if (BAbstractSigningRequester.LOG.isLoggable(Level.FINEST)) {
                BAbstractSigningRequester.LOG.finest("CheckOnboardingApproval attempt " + this.attempts + " of " + requester.getMaxApprovalCheckAttempts());
            }
            BApprovalState result = requester.checkOnboardingApproval();
            BAbstractSigningRequester.LOG.finest("  onboarding approval state: " + result.getDisplayTag(null));
            if (result == BApprovalState.approved) {
                this.submitNextTask(new GenerateCertificateAndSubmitCsr(requester, this.getContext()));
            } else if (result == BApprovalState.unapproved) {
                if (this.attempts < requester.getMaxApprovalCheckAttempts()) {
                    this.scheduleNextTask(this, requester.getApprovalCheckRetryDelay(), TimeUnit.MILLISECONDS);
                }
            } else {
                requester.setRequesterState(BRequesterState.notOnboarded);
                requester.fail(BAbstractSigningRequester.LEX.getText("signingRequester.approvalFailed", new Object[]{result.getDisplayTag(null)}), null, true);
            }
        }
        catch (Exception e) {
            BAbstractSigningRequester.LOG.warning("Failed to check for onboarding approval, resetting requester state to notOnboarded");
            requester.setRequesterState(BRequesterState.notOnboarded);
            throw e;
        }
    }
}

