/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.baja.sys.Context;

abstract class AbstractSigningRequesterTask
implements Runnable {
    AbstractSigningRequesterTask() {
    }

    abstract BAbstractSigningRequester getSigningRequester();

    abstract Context getContext();

    abstract void execute() throws Exception;

    public boolean isOnboardingTaskOnly() {
        return false;
    }

    @Override
    public final void run() {
        String taskName = this.getClass().getSimpleName();
        String taskDisplayName = BAbstractSigningRequester.LEX.getText(this.getClass().getSimpleName());
        if (BAbstractSigningRequester.LOG.isLoggable(Level.FINE)) {
            BAbstractSigningRequester.LOG.fine(taskName + "#execute(), requester: " + this.getSigningRequester().getRequesterId());
        }
        try {
            this.execute();
        }
        catch (Throwable t) {
            if (BAbstractSigningRequester.LOG.isLoggable(Level.FINE)) {
                BAbstractSigningRequester.LOG.log(Level.FINE, taskName + "#execute() failed, requester: " + this.getSigningRequester().getRequesterId(), t);
            }
            this.getSigningRequester().fail(BAbstractSigningRequester.LEX.getText("signingRequester.task.failed", new Object[]{taskDisplayName, BAbstractSigningRequester.extractErrorMessage(t)}), null, this.isOnboardingTaskOnly());
        }
    }

    public Future<?> submitNextTask(AbstractSigningRequesterTask task) {
        if (BAbstractSigningRequester.LOG.isLoggable(Level.FINE)) {
            BAbstractSigningRequester.LOG.fine(this.getClass().getSimpleName() + " submitted " + task.getClass().getSimpleName());
        }
        return this.getSigningRequester().getExecutorService().submit(task);
    }

    public ScheduledFuture<?> scheduleNextTask(AbstractSigningRequesterTask task, long delay, TimeUnit unit) {
        if (BAbstractSigningRequester.LOG.isLoggable(Level.FINE)) {
            BAbstractSigningRequester.LOG.fine(this.getClass().getSimpleName() + " scheduled " + task.getClass().getSimpleName() + " in " + delay + ' ' + unit.name().toLowerCase(Locale.ROOT));
        }
        return this.getSigningRequester().getExecutorService().schedule(task, delay, unit);
    }
}

